/*
 * Decompiled with CFR 0.152.
 */
package org.opencarto.algo.deformation.constraint;

import com.vividsolutions.jts.geom.Coordinate;
import java.util.logging.Logger;
import org.opencarto.algo.deformation.GPoint;
import org.opencarto.algo.deformation.GRelationnalConstraint;
import org.opencarto.algo.deformation.submicro.GSegment;
import org.opencarto.algo.deformation.submicro.GSinglePoint;

public class PointSegmentMinimalDistance
extends GRelationnalConstraint {
    private static Logger logger = Logger.getLogger(PointSegmentMinimalDistance.class.getName());
    public double distance;
    private GSinglePoint ps;
    private GSegment s;

    public PointSegmentMinimalDistance(GSinglePoint ps, GSegment s, double imp, double distance) {
        super(ps, s, imp);
        this.ps = ps;
        this.s = s;
        this.distance = distance;
    }

    @Override
    public Coordinate getDisplacement(GPoint p, double alpha) {
        double ps1 = (this.s.getPt2().getX() - this.s.getPt1().getX()) * (this.ps.getPoint().getX() - this.s.getPt1().getX()) + (this.s.getPt2().getY() - this.s.getPt1().getY()) * (this.ps.getPoint().getY() - this.s.getPt1().getY());
        double ps2 = (this.s.getPt1().getX() - this.s.getPt2().getX()) * (this.ps.getPoint().getX() - this.s.getPt2().getX()) + (this.s.getPt1().getY() - this.s.getPt2().getY()) * (this.ps.getPoint().getY() - this.s.getPt2().getY());
        if (p == this.ps.getPoint()) {
            if (ps1 > 0.0 && ps2 > 0.0) {
                Coordinate proj = p.getProjected(this.s);
                double d = p.getDistance(proj.x, proj.y);
                if (d > this.distance) {
                    return new Coordinate(0.0, 0.0);
                }
                if (d == 0.0) {
                    double a = this.distance * alpha * 0.5 / this.s.getLength();
                    return new Coordinate(a * (this.s.getPt2().getY() - this.s.getPt1().getY()), a * (this.s.getPt1().getX() - this.s.getPt2().getX()));
                }
                double a = alpha * 0.5 * (this.distance / d - 1.0);
                return new Coordinate(a * (p.getX() - proj.x), a * (p.getY() - proj.y));
            }
            if (ps1 <= 0.0 && ps2 > 0.0) {
                double d = p.getDistance(this.s.getPt1());
                if (d > this.distance) {
                    return new Coordinate(0.0, 0.0);
                }
                if (d == 0.0) {
                    double a = this.distance * alpha * 0.5 / this.s.getLength();
                    return new Coordinate(a * (this.s.getPt1().getX() - this.s.getPt2().getX()), a * (this.s.getPt1().getY() - this.s.getPt2().getY()));
                }
                double a = alpha * 0.5 * (this.distance / d - 1.0);
                return new Coordinate(a * (p.getX() - this.s.getPt1().getX()), a * (p.getY() - this.s.getPt1().getY()));
            }
            if (ps2 <= 0.0 && ps1 > 0.0) {
                double d = p.getDistance(this.s.getPt2());
                if (d > this.distance) {
                    return new Coordinate(0.0, 0.0);
                }
                if (d == 0.0) {
                    double a = this.distance * alpha * 0.5 / this.s.getLength();
                    return new Coordinate(a * (this.s.getPt2().getX() - this.s.getPt1().getX()), a * (this.s.getPt2().getY() - this.s.getPt1().getY()));
                }
                double a = alpha * 0.5 * (this.distance / d - 1.0);
                return new Coordinate(a * (p.getX() - this.s.getPt2().getX()), a * (p.getY() - this.s.getPt2().getY()));
            }
        } else if (p == this.s.getPt1() || p == this.s.getPt2()) {
            if (ps1 > 0.0 && ps2 > 0.0) {
                Coordinate proj = this.ps.getPoint().getProjected(this.s);
                double d = this.ps.getPoint().getDistance(proj.x, proj.y);
                if (d > this.distance) {
                    return new Coordinate(0.0, 0.0);
                }
                if (d == 0.0) {
                    double d_ = p.getDistance(this.ps.getPoint());
                    double dd = this.s.getLength();
                    double a = (1.0 - d_ / dd) * alpha * 0.5 * this.distance;
                    return new Coordinate(a * (this.s.getPt1().getY() - this.s.getPt2().getY()), a * (this.s.getPt2().getX() - this.s.getPt1().getX()));
                }
                double d_ = p.getDistance(proj.x, proj.y);
                double dd = this.s.getLength();
                double a = (1.0 - d_ / dd) * alpha * 0.5 * (this.distance / d - 1.0);
                return new Coordinate(a * (proj.x - this.ps.getPoint().getX()), a * (proj.y - this.ps.getPoint().getY()));
            }
            double d = this.ps.getPoint().getDistance(p.getX(), p.getY());
            if (d > this.distance) {
                return new Coordinate(0.0, 0.0);
            }
            if (d == 0.0) {
                GPoint p_ = null;
                p_ = p == this.s.getPt1() ? this.s.getPt2() : this.s.getPt1();
                double a = alpha * 0.5 * this.distance;
                return new Coordinate(a * (p_.getX() - p.getX()), a * (p_.getY() - p.getY()));
            }
            double a = alpha * 0.5 * (this.distance / d - 1.0);
            return new Coordinate(a * (p.getX() - this.ps.getPoint().getX()), a * (p.getY() - this.ps.getPoint().getY()));
        }
        logger.severe("Error");
        return null;
    }
}

