/*
 * Decompiled with CFR 0.152.
 */
package org.opencarto.algo.deformation.constraint;

import com.vividsolutions.jts.geom.Coordinate;
import java.util.logging.Logger;
import org.opencarto.algo.deformation.GPoint;
import org.opencarto.algo.deformation.GSimpleConstraint;
import org.opencarto.algo.deformation.submicro.GSegment;

public class SegmentLength
extends GSimpleConstraint {
    private static Logger logger = Logger.getLogger(SegmentLength.class.getName());
    private double goal;

    public SegmentLength(GSegment s, double imp) {
        this(s, imp, s.getIniLength());
    }

    public SegmentLength(GSegment s, double imp, double goalLength) {
        super(s, imp);
        this.goal = goalLength;
    }

    @Override
    public Coordinate getDisplacement(GPoint pt, double alpha) {
        double dy;
        double dx;
        GSegment seg = (GSegment)this.getSubmicro();
        double length = seg.getLength();
        if (length == 0.0) {
            double a = 0.5 * alpha * this.goal / seg.getIniLength();
            dx = a * (seg.getPt1().getXIni() - seg.getPt2().getXIni());
            dy = a * (seg.getPt1().getYIni() - seg.getPt2().getYIni());
        } else {
            double a = 0.5 * alpha * (this.goal / length - 1.0);
            dx = a * (seg.getPt1().getX() - seg.getPt2().getX());
            dy = a * (seg.getPt1().getY() - seg.getPt2().getY());
        }
        if (pt == seg.getPt1()) {
            return new Coordinate(dx, dy);
        }
        if (pt == seg.getPt2()) {
            return new Coordinate(-dx, -dy);
        }
        logger.severe("Error");
        return null;
    }
}

