/*
 * Decompiled with CFR 0.152.
 */
package org.opencarto.algo.deformation.constraint;

import com.vividsolutions.jts.geom.Coordinate;
import java.util.logging.Logger;
import org.opencarto.algo.deformation.GPoint;
import org.opencarto.algo.deformation.GSimpleConstraint;
import org.opencarto.algo.deformation.submicro.GSegment;

public class SegmentOrientation
extends GSimpleConstraint {
    private static Logger logger = Logger.getLogger(SegmentOrientation.class.getName());
    private double goal;

    public SegmentOrientation(GSegment seg, double imp) {
        this(seg, imp, seg.getPt1().getIniOrientation(seg.getPt2()));
    }

    public SegmentOrientation(GSegment seg, double imp, double goalOrientation) {
        super(seg, imp);
        this.goal = goalOrientation;
    }

    @Override
    public Coordinate getDisplacement(GPoint pt, double alpha) {
        GSegment seg = (GSegment)this.getSubmicro();
        double angle = alpha * seg.getOrientationGap(this.goal);
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        double dx = 0.5 * (seg.getPt2().getX() - seg.getPt1().getX() + cos * (seg.getPt1().getX() - seg.getPt2().getX()) + sin * (seg.getPt1().getY() - seg.getPt2().getY()));
        double dy = 0.5 * (seg.getPt2().getY() - seg.getPt1().getY() - sin * (seg.getPt1().getX() - seg.getPt2().getX()) + cos * (seg.getPt1().getY() - seg.getPt2().getY()));
        if (pt == seg.getPt1()) {
            return new Coordinate(dx, dy);
        }
        if (pt == seg.getPt2()) {
            return new Coordinate(-dx, -dy);
        }
        logger.severe("Error: point is not one of the segment's ones");
        return null;
    }
}

