/*
 * Decompiled with CFR 0.152.
 */
package org.opencarto.algo.deformation.constraint;

import com.vividsolutions.jts.geom.Coordinate;
import java.util.logging.Logger;
import org.opencarto.algo.deformation.GPoint;
import org.opencarto.algo.deformation.GRelationnalConstraint;
import org.opencarto.algo.deformation.submicro.GSegment;

public class SegmentSegmentJoin
extends GRelationnalConstraint {
    private static Logger logger = Logger.getLogger(SegmentSegmentJoin.class.getName());
    private GSegment s1;
    private GSegment s2;

    public SegmentSegmentJoin(GSegment s1, GSegment s2, double importance) {
        super(s1, s2, importance);
        this.s1 = s1;
        this.s2 = s2;
    }

    @Override
    public Coordinate getDisplacement(GPoint p, double alpha) {
        GSegment s = null;
        if (p == this.s1.getPt1() || p == this.s1.getPt2()) {
            s = this.s2;
        } else if (p == this.s2.getPt1() || p == this.s2.getPt2()) {
            s = this.s1;
        } else {
            logger.severe("Erreur dans la contrainte " + this + ". le point " + p + " n'est pas un point des segments " + this.s1 + " et " + this.s2);
            return new Coordinate(0.0, 0.0);
        }
        double ps1 = (p.getX() - s.getPt1().getX()) * (s.getPt2().getX() - s.getPt1().getX()) + (p.getY() - s.getPt1().getY()) * (s.getPt2().getY() - s.getPt1().getY());
        double ps2 = (p.getX() - s.getPt2().getX()) * (s.getPt1().getX() - s.getPt2().getX()) + (p.getY() - s.getPt2().getY()) * (s.getPt1().getY() - s.getPt2().getY());
        double dx = 0.0;
        double dy = 0.0;
        if (ps1 > 0.0 && ps2 > 0.0) {
            Coordinate proj = p.getProjected(s);
            dx = alpha * 0.5 * (proj.x - p.getX());
            dy = alpha * 0.5 * (proj.y - p.getY());
        } else if (ps1 <= 0.0 && ps2 > 0.0) {
            dx = alpha * 0.5 * (s.getPt1().getX() - p.getX());
            dy = alpha * 0.5 * (s.getPt1().getY() - p.getY());
        } else if (ps1 > 0.0 && ps2 <= 0.0) {
            dx = alpha * 0.5 * (s.getPt2().getX() - p.getX());
            dy = alpha * 0.5 * (s.getPt2().getY() - p.getY());
        }
        return new Coordinate(dx, dy);
    }
}

