/*
 * Decompiled with CFR 0.152.
 */
package org.opencarto.algo.deformation.constraint;

import com.vividsolutions.jts.geom.Coordinate;
import org.opencarto.algo.deformation.GPoint;
import org.opencarto.algo.deformation.GSimpleConstraint;
import org.opencarto.algo.deformation.submicro.GTriangle;

public class TriangleCenterPreservation
extends GSimpleConstraint {
    public TriangleCenterPreservation(GTriangle t, double imp) {
        super(t, imp);
    }

    @Override
    public Coordinate getDisplacement(GPoint pt, double alpha) {
        GTriangle tri = (GTriangle)this.getSubmicro();
        if (tri.istReverted()) {
            return new Coordinate(0.0, 0.0);
        }
        double xG = (tri.getPt1().getX() + tri.getPt2().getX() + tri.getPt3().getX()) / 3.0;
        double yG = (tri.getPt1().getY() + tri.getPt2().getY() + tri.getPt3().getY()) / 3.0;
        double length = Math.sqrt((xG - pt.getX()) * (xG - pt.getX()) + (yG - pt.getY()) * (yG - pt.getY()));
        if (length == 0.0) {
            return new Coordinate(alpha * (pt.getX() - xG), alpha * (pt.getY() - yG));
        }
        double xGIni = (tri.getPt1().getXIni() + tri.getPt2().getXIni() + tri.getPt3().getXIni()) / 3.0;
        double yGIni = (tri.getPt1().getYIni() + tri.getPt2().getYIni() + tri.getPt3().getYIni()) / 3.0;
        double lengthIni = Math.hypot(xGIni - pt.getXIni(), yGIni - pt.getYIni());
        return new Coordinate(alpha * (1.0 - lengthIni / length) * (xG - pt.getX()), alpha * (1.0 - lengthIni / length) * (yG - pt.getY()));
    }
}

