/*
 * Decompiled with CFR 0.152.
 */
package org.opencarto.algo.deformation.submicro;

import org.opencarto.algo.deformation.GPoint;
import org.opencarto.algo.deformation.Submicro;

public class GAngle
extends Submicro {
    private GPoint pt;
    private GPoint pt1;
    private GPoint pt2;
    private double initialValue = -999.9;

    public GPoint getPt() {
        return this.pt;
    }

    public GPoint getPt1() {
        return this.pt1;
    }

    public GPoint getPt2() {
        return this.pt2;
    }

    public GAngle(GPoint pt1, GPoint pt, GPoint pt2) {
        pt1.getSubmicros().add(this);
        pt.getSubmicros().add(this);
        pt2.getSubmicros().add(this);
        this.getPoints().add(pt1);
        this.getPoints().add(pt);
        this.getPoints().add(pt2);
        this.pt = pt;
        if ((pt1.getXIni() - pt.getXIni()) * (pt2.getYIni() - pt.getYIni()) - (pt1.getYIni() - pt.getYIni()) * (pt2.getXIni() - pt.getXIni()) > 0.0) {
            this.pt1 = pt1;
            this.pt2 = pt2;
        } else {
            this.pt1 = pt2;
            this.pt2 = pt1;
        }
        pt1.getPointsRel().add(pt2);
        pt1.getPointsRel().add(pt);
        pt2.getPointsRel().add(pt1);
        pt2.getPointsRel().add(pt);
        pt.getPointsRel().add(pt1);
        pt.getPointsRel().add(pt2);
    }

    public double getValue() {
        double value = Math.atan2((this.getPt1().getX() - this.getPt().getX()) * (this.getPt2().getY() - this.getPt().getY()) - (this.getPt1().getY() - this.getPt().getY()) * (this.getPt2().getX() - this.getPt().getX()), (this.getPt1().getX() - this.getPt().getX()) * (this.getPt2().getX() - this.getPt().getX()) + (this.getPt1().getY() - this.getPt().getY()) * (this.getPt2().getY() - this.getPt().getY()));
        if (value < 0.0) {
            value += Math.PI * 2;
        }
        return value;
    }

    public double getInitialValue() {
        if (this.initialValue == -999.9) {
            double pv = (this.getPt1().getXIni() - this.getPt().getXIni()) * (this.getPt2().getYIni() - this.getPt().getYIni()) - (this.getPt1().getYIni() - this.getPt().getYIni()) * (this.getPt2().getXIni() - this.getPt().getXIni());
            double ps = (this.getPt1().getXIni() - this.getPt().getXIni()) * (this.getPt2().getXIni() - this.getPt().getXIni()) + (this.getPt1().getYIni() - this.getPt().getYIni()) * (this.getPt2().getYIni() - this.getPt().getYIni());
            this.initialValue = Math.atan2(pv, ps);
        }
        return this.initialValue;
    }

    public double getValueDifference(double val) {
        double diff = val - this.getValue();
        if (diff < -Math.PI) {
            return diff + Math.PI * 2;
        }
        if (diff > Math.PI) {
            return diff - Math.PI * 2;
        }
        return diff;
    }

    public double getValueDifference() {
        return this.getValueDifference(this.getInitialValue());
    }

    @Override
    public double getX() {
        return this.getPt().getX();
    }

    @Override
    public double getY() {
        return this.getPt().getY();
    }

    @Override
    public void clean() {
        super.clean();
        this.pt = null;
        this.pt1 = null;
        this.pt2 = null;
    }
}

