/*
 * Decompiled with CFR 0.152.
 */
package org.opencarto.algo.deformation.submicro;

import java.util.logging.Logger;
import org.opencarto.algo.deformation.GPoint;
import org.opencarto.algo.deformation.Submicro;

public class GSegment
extends Submicro {
    static Logger logger = Logger.getLogger(GSegment.class.getName());
    private GPoint pt1;
    private GPoint pt2;
    protected double iniLength = -999.0;
    private double iniOr = -999.9;

    public GPoint getPt1() {
        return this.pt1;
    }

    public GPoint getPt2() {
        return this.pt2;
    }

    public GSegment(GPoint pt1, GPoint pt2) {
        this.pt1 = pt1;
        this.pt2 = pt2;
        this.getPoints().add(pt1);
        this.getPoints().add(pt2);
        pt1.getSubmicros().add(this);
        pt2.getSubmicros().add(this);
        pt1.getPointsRel().add(pt2);
        pt2.getPointsRel().add(pt1);
    }

    public double getLength() {
        return this.getPt1().getDistance(this.getPt2());
    }

    public double getIniLength() {
        if (this.iniLength == -999.0) {
            this.iniLength = this.getPt1().getIniDistance(this.getPt2());
        }
        return this.iniLength;
    }

    public double getOrientation() {
        return this.getPt1().getOrientation(this.getPt2());
    }

    public double getIniOrientation() {
        if (this.iniOr == -999.9) {
            this.iniOr = this.getPt1().getIniOrientation(this.getPt2());
        }
        return this.iniOr;
    }

    public double getOrientationGap(double orientation) {
        double diff = this.getPt1().getOrientation(this.getPt2()) - orientation;
        if (diff < -Math.PI) {
            return diff + Math.PI * 2;
        }
        if (diff > Math.PI) {
            return diff - Math.PI * 2;
        }
        return diff;
    }

    public double getOrientationGap() {
        return this.getOrientationGap(this.getPt1().getIniOrientation(this.getPt2()));
    }

    @Override
    public double getX() {
        return (this.getPt1().getX() + this.getPt2().getX()) * 0.5;
    }

    @Override
    public double getY() {
        return (this.getPt1().getY() + this.getPt2().getY()) * 0.5;
    }

    @Override
    public void clean() {
        super.clean();
        this.pt1 = null;
        this.pt2 = null;
    }
}

