/*
 * Decompiled with CFR 0.152.
 */
package org.opencarto.algo.deformation.submicro;

import com.vividsolutions.jts.geom.Coordinate;
import org.opencarto.algo.deformation.GPoint;
import org.opencarto.algo.deformation.Submicro;

public class GTriangle
extends Submicro {
    private GPoint pt1;
    private GPoint pt2;
    private GPoint pt3;
    private double iniArea = -999.9;

    public GPoint getPt1() {
        return this.pt1;
    }

    public GPoint getPt2() {
        return this.pt2;
    }

    public GPoint getPt3() {
        return this.pt3;
    }

    public GTriangle(GPoint pt1, GPoint pt2, GPoint pt3) {
        pt1.getSubmicros().add(this);
        pt2.getSubmicros().add(this);
        pt3.getSubmicros().add(this);
        this.getPoints().add(pt1);
        this.getPoints().add(pt2);
        this.getPoints().add(pt3);
        if ((pt2.getX() - pt1.getX()) * (pt3.getY() - pt1.getY()) - (pt2.getY() - pt1.getY()) * (pt3.getX() - pt1.getX()) > 0.0) {
            this.pt1 = pt1;
            this.pt2 = pt2;
            this.pt3 = pt3;
        } else {
            this.pt1 = pt1;
            this.pt2 = pt3;
            this.pt3 = pt2;
        }
        pt1.getPointsRel().add(pt2);
        pt1.getPointsRel().add(pt3);
        pt2.getPointsRel().add(pt1);
        pt2.getPointsRel().add(pt3);
        pt3.getPointsRel().add(pt1);
        pt3.getPointsRel().add(pt2);
    }

    public double getArea() {
        double s = this.istReverted() ? -1.0 : 1.0;
        return s * Math.abs(this.getPt2().getX() * this.getPt1().getY() - this.getPt1().getX() * this.getPt2().getY() + this.getPt3().getX() * this.getPt2().getY() - this.getPt2().getX() * this.getPt3().getY() + this.getPt1().getX() * this.getPt3().getY() - this.getPt3().getX() * this.getPt1().getY()) * 0.5;
    }

    public double getInitialArea() {
        if (this.iniArea == -999.9) {
            this.iniArea = Math.abs(this.getPt2().getXIni() * this.getPt1().getYIni() - this.getPt1().getXIni() * this.getPt2().getYIni() + this.getPt3().getXIni() * this.getPt2().getYIni() - this.getPt2().getXIni() * this.getPt3().getYIni() + this.getPt1().getXIni() * this.getPt3().getYIni() - this.getPt3().getXIni() * this.getPt1().getYIni()) * 0.5;
        }
        return this.iniArea;
    }

    public boolean contains(Coordinate c) {
        if ((this.getPt1().getX() - c.x) * (this.getPt2().getY() - c.y) - (this.getPt1().getY() - c.y) * (this.getPt2().getX() - c.x) < 0.0) {
            return false;
        }
        if ((this.getPt2().getX() - c.x) * (this.getPt3().getY() - c.y) - (this.getPt2().getY() - c.y) * (this.getPt3().getX() - c.x) < 0.0) {
            return false;
        }
        return !((this.getPt3().getX() - c.x) * (this.getPt1().getY() - c.y) - (this.getPt3().getY() - c.y) * (this.getPt1().getX() - c.x) < 0.0);
    }

    public boolean containsInitial(Coordinate c) {
        if ((this.getPt1().getXIni() - c.x) * (this.getPt2().getYIni() - c.y) - (this.getPt1().getYIni() - c.y) * (this.getPt2().getXIni() - c.x) < 0.0) {
            return false;
        }
        if ((this.getPt2().getXIni() - c.x) * (this.getPt3().getYIni() - c.y) - (this.getPt2().getYIni() - c.y) * (this.getPt3().getXIni() - c.x) < 0.0) {
            return false;
        }
        return !((this.getPt3().getXIni() - c.x) * (this.getPt1().getYIni() - c.y) - (this.getPt3().getYIni() - c.y) * (this.getPt1().getXIni() - c.x) < 0.0);
    }

    public String getDirection() {
        double pv = (this.getPt2().getX() - this.getPt1().getX()) * (this.getPt3().getY() - this.getPt1().getY()) - (this.getPt2().getY() - this.getPt1().getY()) * (this.getPt3().getX() - this.getPt1().getX());
        if (pv > 0.0) {
            return "d";
        }
        if (pv < 0.0) {
            return "i";
        }
        return "n";
    }

    public boolean istReverted() {
        return !this.getDirection().equals("d");
    }

    @Override
    public double getX() {
        return (this.getPt1().getX() + this.getPt2().getX() + this.getPt3().getX()) / 3.0;
    }

    @Override
    public double getY() {
        return (this.getPt1().getY() + this.getPt2().getY() + this.getPt3().getY()) / 3.0;
    }

    @Override
    public void clean() {
        super.clean();
        this.pt1 = null;
        this.pt2 = null;
        this.pt3 = null;
    }
}

