/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.event;

import com.bbn.openmap.MapBean;
import com.bbn.openmap.event.CoordMouseMode;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.proj.Proj;
import com.bbn.openmap.proj.ProjMath;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;

public class NavMouseMode
extends CoordMouseMode {
    public static final transient String modeID = "Navigation";
    protected Point point1;
    protected Point point2;
    protected boolean autoZoom = false;
    protected DrawingAttributes rectAttributes = DrawingAttributes.getDefaultClone();

    public NavMouseMode() {
        this(true);
        this.rectAttributes.setFillPaint(Color.lightGray);
        this.rectAttributes.setLinePaint(Color.darkGray);
    }

    public NavMouseMode(boolean shouldConsumeEvents) {
        super(modeID, shouldConsumeEvents);
        this.setModeCursor(Cursor.getPredefinedCursor(1));
    }

    public void mousePressed(MouseEvent e) {
        if (Debug.debugging("mousemode")) {
            Debug.output(this.getID() + "|NavMouseMode.mousePressed()");
        }
        e.getComponent().requestFocus();
        if (!this.mouseSupport.fireMapMousePressed(e) && e.getSource() instanceof MapBean) {
            this.point1 = e.getPoint();
            this.point2 = null;
            this.autoZoom = true;
        }
    }

    public void mouseClicked(MouseEvent e) {
        Object obj = e.getSource();
        this.mouseSupport.fireMapMouseClicked(e);
        if (!(obj instanceof MapBean) || this.point1 == null) {
            return;
        }
        MapBean map = (MapBean)obj;
        Projection projection = map.getProjection();
        Proj p = (Proj)projection;
        Point2D llp = map.getCoordinates(e);
        boolean shift = e.isShiftDown();
        boolean control = e.isControlDown();
        if (control) {
            if (shift) {
                p.setScale(p.getScale() * 2.0f);
            } else {
                p.setScale(p.getScale() / 2.0f);
            }
        }
        this.point1 = null;
        this.point2 = null;
        p.setCenter(llp);
        map.setProjection(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseReleased(MouseEvent e) {
        if (Debug.debugging("mousemode")) {
            Debug.output(this.getID() + "|NavMouseMode.mouseReleased()");
        }
        Object obj = e.getSource();
        this.mouseSupport.fireMapMouseReleased(e);
        if (!(obj instanceof MapBean) || !this.autoZoom || this.point1 == null || this.point2 == null) {
            return;
        }
        MapBean map = (MapBean)obj;
        Projection projection = map.getProjection();
        Proj p = (Proj)projection;
        NavMouseMode navMouseMode = this;
        synchronized (navMouseMode) {
            this.point2 = this.getRatioPoint((MapBean)e.getSource(), this.point1, e.getPoint());
            int dx = Math.abs(this.point2.x - this.point1.x);
            int dy = Math.abs(this.point2.y - this.point1.y);
            if (dx < 5 || dy < 5) {
                this.paintRectangle(map, this.point1, this.point2);
                if (dx < 5 && dy < 5) {
                    Point2D llp = map.getCoordinates(e);
                    boolean shift = e.isShiftDown();
                    boolean control = e.isControlDown();
                    if (control) {
                        if (shift) {
                            p.setScale(p.getScale() * 2.0f);
                        } else {
                            p.setScale(p.getScale() / 2.0f);
                        }
                    }
                    this.point1 = null;
                    this.point2 = null;
                    p.setCenter(llp);
                    map.setProjection(p);
                }
                return;
            }
            float newScale = ProjMath.getScale(this.point1, this.point2, projection);
            int centerx = Math.min(this.point1.x, this.point2.x) + dx / 2;
            int centery = Math.min(this.point1.y, this.point2.y) + dy / 2;
            Point2D center = map.inverse(centerx, centery, null);
            p.setScale(newScale);
            p.setCenter(center);
            this.point1 = null;
            this.point2 = null;
            map.setProjection(p);
        }
    }

    public void mouseEntered(MouseEvent e) {
        if (Debug.debugging("mousemodedetail")) {
            Debug.output(this.getID() + "|NavMouseMode.mouseEntered()");
        }
        super.mouseEntered(e);
        this.autoZoom = true;
    }

    public void mouseExited(MouseEvent e) {
        if (Debug.debugging("mousemodedetail")) {
            Debug.output(this.getID() + "|NavMouseMode.mouseExited()");
        }
        super.mouseExited(e);
        if (e.getSource() instanceof MapBean) {
            this.autoZoom = false;
            this.paintRectangle((MapBean)e.getSource(), this.point1, this.point2);
            this.point2 = null;
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (Debug.debugging("mousemodedetail")) {
            Debug.output(this.getID() + "|NavMouseMode.mouseDragged()");
        }
        super.mouseDragged(e);
        if (e.getSource() instanceof MapBean) {
            if (!this.autoZoom) {
                return;
            }
            this.paintRectangle((MapBean)e.getSource(), this.point1, this.point2);
            this.point2 = this.getRatioPoint((MapBean)e.getSource(), this.point1, e.getPoint());
            this.paintRectangle((MapBean)e.getSource(), this.point1, this.point2);
        }
    }

    protected Point getRatioPoint(MapBean map, Point pt1, Point pt2) {
        return ProjMath.getRatioPoint(map.getProjection(), pt1, pt2);
    }

    protected void paintRectangle(MapBean map, Point pt1, Point pt2) {
        if (map != null) {
            this.paintRectangle(map.getGraphics(), pt1, pt2);
        }
    }

    protected void paintRectangle(Graphics g, Point pt1, Point pt2) {
        g.setXORMode((Color)this.rectAttributes.getFillPaint());
        g.setColor((Color)this.rectAttributes.getLinePaint());
        if (pt1 != null && pt2 != null) {
            int width = Math.abs(pt2.x - pt1.x);
            int height = Math.abs(pt2.y - pt1.y);
            if (width == 0) {
                ++width;
            }
            if (height == 0) {
                ++height;
            }
            g.drawRect(pt1.x < pt2.x ? pt1.x : pt2.x, pt1.y < pt2.y ? pt1.y : pt2.y, width, height);
            g.drawRect(pt1.x < pt2.x ? pt1.x + (pt2.x - pt1.x) / 2 - 1 : pt2.x + (pt1.x - pt2.x) / 2 - 1, pt1.y < pt2.y ? pt1.y + (pt2.y - pt1.y) / 2 - 1 : pt2.y + (pt1.y - pt2.y) / 2 - 1, 2, 2);
        }
    }

    public void listenerPaint(Graphics g) {
        this.paintRectangle(g, this.point1, this.point2);
    }

    public DrawingAttributes getRectAttributes() {
        return this.rectAttributes;
    }

    public void setRectAttributes(DrawingAttributes rectAttributes) {
        this.rectAttributes = rectAttributes;
    }
}

