/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.proj;

import com.bbn.openmap.proj.GeoProj;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Point2D;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AspectRatioProjection
extends GeoProj {
    private GeoProj wrappedProjection;
    private float xFactor;
    private float yFactor;
    private float halfWidth;
    private float halfWrappedWidth;
    private float halfHeight;
    private float halfWrappedHeight;
    private boolean xHasFactor;
    private boolean yHasFactor;

    public AspectRatioProjection(GeoProj proj, int w, int h) {
        super(proj.getCenter(), proj.getScale(), w, h);
        this.wrappedProjection = proj;
        this.xHasFactor = proj.getWidth() != w;
        this.yHasFactor = proj.getHeight() != h;
        this.computeParameters();
    }

    private Point2D fromWrapped(Point2D pt) {
        pt.setLocation(this.xFromWrapped((float)pt.getX()), this.yFromWrapped((float)pt.getY()));
        return pt;
    }

    private float xFromWrapped(float x) {
        if (!this.xHasFactor) {
            return x;
        }
        return (x - this.halfWrappedWidth) * this.xFactor + this.halfWidth;
    }

    private float yFromWrapped(float y) {
        if (!this.yHasFactor) {
            return y;
        }
        return (y - this.halfWrappedHeight) * this.yFactor + this.halfHeight;
    }

    private float xToWrapped(float x) {
        if (!this.xHasFactor) {
            return x;
        }
        return (x - this.halfWidth) / this.xFactor + this.halfWrappedWidth;
    }

    private float yToWrapped(float y) {
        if (!this.yHasFactor) {
            return y;
        }
        return (y - this.halfHeight) / this.yFactor + this.halfWrappedHeight;
    }

    @Override
    protected ArrayList<float[]> _forwardPoly(float[] rawllpts, int ltype, int nsegs, boolean isFilled) {
        ArrayList<float[]> stuff = this.wrappedProjection._forwardPoly(rawllpts, ltype, nsegs, isFilled);
        int size = stuff.size();
        for (int i = 0; i < size; i += 2) {
            float[] xpts = stuff.get(i);
            if (this.xHasFactor) {
                for (int j = 0; j < xpts.length; ++j) {
                    xpts[j] = this.xFromWrapped(xpts[j]);
                }
            }
            if (!this.yHasFactor) continue;
            float[] ypts = stuff.get(i + 1);
            for (int j = 0; j < ypts.length; ++j) {
                ypts[j] = this.yFromWrapped(ypts[j]);
            }
        }
        return stuff;
    }

    @Override
    protected void computeParameters() {
        if (this.wrappedProjection != null) {
            this.wrappedProjection.computeParameters();
            this.xFactor = (float)((double)this.getWidth() / (double)this.wrappedProjection.getWidth());
            this.yFactor = (float)((double)this.getHeight() / (double)this.wrappedProjection.getHeight());
            this.halfWidth = (float)this.getWidth() / 2.0f;
            this.halfHeight = (float)this.getHeight() / 2.0f;
            this.halfWrappedWidth = (float)this.wrappedProjection.getWidth() / 2.0f;
            this.halfWrappedHeight = (float)this.wrappedProjection.getHeight() / 2.0f;
        }
    }

    @Override
    public void drawBackground(Graphics2D g, Paint p) {
        this.wrappedProjection.drawBackground(g, p);
    }

    @Override
    public void drawBackground(Graphics g) {
        this.wrappedProjection.drawBackground(g);
    }

    @Override
    public double normalizeLatitude(double lat) {
        if (this.wrappedProjection == null) {
            if (lat > 1.5707963705062866) {
                return 1.5707963705062866;
            }
            if (lat < -1.5707963705062866) {
                return -1.5707963705062866;
            }
            return lat;
        }
        return this.wrappedProjection.normalizeLatitude(lat);
    }

    @Override
    public Point2D forward(Point2D llp, Point2D pt) {
        return this.fromWrapped(this.wrappedProjection.forward(llp, pt));
    }

    @Override
    public Point2D forward(double lat, double lon, Point2D pt) {
        return this.fromWrapped(this.wrappedProjection.forward(lat, lon, pt));
    }

    @Override
    public boolean forwardRaw(float[] rawllpts, int rawoff, float[] xcoords, float[] ycoords, boolean[] visible, int copyoff, int copylen) {
        boolean r = this.wrappedProjection.forwardRaw(rawllpts, rawoff, xcoords, ycoords, visible, copyoff, copylen);
        int end = copylen + copyoff;
        for (int i = copyoff; i < end; ++i) {
            if (this.xHasFactor) {
                xcoords[i] = this.xFromWrapped(xcoords[i]);
            }
            if (!this.yHasFactor) continue;
            ycoords[i] = this.yFromWrapped(ycoords[i]);
        }
        return r;
    }

    @Override
    public Point2D getLowerRight() {
        return this.wrappedProjection.getLowerRight();
    }

    @Override
    public Point2D getUpperLeft() {
        return this.wrappedProjection.getUpperLeft();
    }

    public Point2D inverse(Point2D point, Point2D llpt) {
        return this.inverse(point.getX(), point.getY(), llpt);
    }

    @Override
    public boolean isPlotable(float lat, float lon) {
        return this.wrappedProjection.isPlotable(lat, lon);
    }

    @Override
    protected ArrayList<float[]> _forwardPoly(double[] rawllpts, int ltype, int nsegs, boolean isFilled) {
        ArrayList<float[]> stuff = this.wrappedProjection._forwardPoly(rawllpts, ltype, nsegs, isFilled);
        int size = stuff.size();
        for (int i = 0; i < size; i += 2) {
            float[] xpts = stuff.get(i);
            if (this.xHasFactor) {
                for (int j = 0; j < xpts.length; ++j) {
                    xpts[j] = this.xFromWrapped(xpts[j]);
                }
            }
            if (!this.yHasFactor) continue;
            float[] ypts = stuff.get(i + 1);
            for (int j = 0; j < ypts.length; ++j) {
                ypts[j] = this.yFromWrapped(ypts[j]);
            }
        }
        return stuff;
    }

    @Override
    public Point2D forward(double lat, double lon, Point2D pt, boolean isRadian) {
        return this.fromWrapped(this.wrappedProjection.forward(lat, lon, pt, isRadian));
    }

    public Point2D inverse(double x, double y, Point2D llpt) {
        return this.wrappedProjection.inverse(this.xToWrapped((float)x), this.yToWrapped((float)y), llpt);
    }

    @Override
    public boolean isPlotable(double lat, double lon) {
        return this.wrappedProjection.isPlotable(lat, lon);
    }
}

