/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.tools.roads;

import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMRect;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.tools.roads.RoadGraphic;
import com.bbn.openmap.tools.roads.RoadLayer;
import com.bbn.openmap.tools.roads.RoadObject;
import com.bbn.openmap.tools.roads.Visual;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.io.Serializable;
import java.util.logging.Logger;

public abstract class Waypoint
extends Visual
implements Serializable {
    protected LatLonPoint location;
    protected Point screenLocation = null;
    private boolean modified = false;

    public Waypoint(LatLonPoint loc, RoadLayer layer) {
        this.location = loc;
        this.layer = layer;
    }

    public static Class getGraphicClass() {
        return Graphic.class;
    }

    public void setModified(boolean newValue) {
        this.modified = newValue;
    }

    public boolean getModified() {
        return this.modified;
    }

    public LatLonPoint getLocation() {
        return this.location;
    }

    public void setLocation(LatLonPoint loc) {
        this.location = loc;
        this.update();
    }

    public Point getScreenLocation() {
        if (this.screenLocation == null) {
            this.screenLocation = (Point)this.getRoadLayer().getProjection().forward(this.location, new Point());
        }
        return this.screenLocation;
    }

    public void setScreenLocation(Point loc) {
        this.setLocation(this.getRoadLayer().getProjection().inverse(loc.x, loc.y, new LatLonPoint.Double()));
    }

    public void update() {
        super.update();
        this.screenLocation = null;
    }

    public RoadLayer getRoadLayer() {
        return this.layer;
    }

    public void moveTo(Point loc) {
        this.setScreenLocation(loc);
    }

    public float getLatitude() {
        return this.getLocation().getLatitude();
    }

    public float getLongitude() {
        return this.getLocation().getLongitude();
    }

    public abstract void render(OMGraphicList var1, boolean var2);

    public String toString() {
        return "Waypoint : location " + this.location;
    }

    public abstract class Graphic
    extends OMRect
    implements RoadGraphic {
        Logger logger;
        private boolean blinkState;

        protected Graphic(int radius) {
            super((double)Waypoint.this.getLocation().getLatitude(), (double)Waypoint.this.getLocation().getLongitude(), -radius, -radius, radius, radius);
            this.logger = Logger.getLogger(this.getClass().getName());
            this.blinkState = false;
            this.setLinePaint(Color.black);
        }

        public void blink(boolean newState) {
            this.blinkState = newState;
        }

        public void render(Graphics g) {
            if (!this.blinkState) {
                super.render(g);
            }
        }

        public abstract RoadObject getRoadObject();
    }
}

