/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.tools.symbology.milStd2525;

import com.bbn.openmap.tools.symbology.milStd2525.CodeOptions;
import com.bbn.openmap.tools.symbology.milStd2525.CodePosition;
import com.bbn.openmap.tools.symbology.milStd2525.SymbolPart;
import com.bbn.openmap.util.ComponentFactory;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class CodeScheme
extends CodePosition {
    protected String defaultSymbolCode = "               ";
    protected String hierarchyAddition;
    public static final String DefaultSymbolCodeProperty = "defaultSymbolCode";
    public static final String HierarchyCodeAdditionProperty = "hierarchyCodeAddition";
    protected CodeOptions options;

    public CodeScheme() {
        super("Scheme", 1, 1);
    }

    public CodePosition addPositionChoice(int index, String entry, String prefix, Properties props) {
        CodeScheme cs = (CodeScheme)super.addPositionChoice(index, entry, prefix, props);
        String next = props.getProperty((prefix = PropUtils.getScopedPropertyPrefix(prefix) + entry + ".") + "next");
        if (next != null) {
            String nextClassName = props.getProperty(next + ".class");
            if (nextClassName != null) {
                CodePosition cp = (CodePosition)ComponentFactory.create(nextClassName);
                if (this.DEBUG) {
                    Debug.output("CodeScheme created next class(" + next + "), " + nextClassName);
                }
                if (cp != null) {
                    cs.nextPosition = cp;
                    cp.parsePositions(next, props);
                }
            } else if (this.DEBUG) {
                Debug.output("CodeScheme couldn't create next class(" + next + "), " + nextClassName);
            }
        }
        cs.defaultSymbolCode = props.getProperty(prefix + DefaultSymbolCodeProperty);
        cs.hierarchyAddition = props.getProperty(prefix + HierarchyCodeAdditionProperty, "");
        return cs;
    }

    public SymbolPart parseHierarchy(Properties props, SymbolPart parent) {
        String hCode = this.getHierarchyNumber() + this.hierarchyAddition;
        String entry = props.getProperty(hCode);
        SymbolPart sp = null;
        if (entry != null) {
            sp = new SymbolPart(this, entry, props, parent);
            this.parseHierarchy(hCode, props, sp);
        }
        return sp;
    }

    public void parseHierarchy(String hCode, Properties props, SymbolPart parent) {
        List codePositionList = null;
        if (this.nextPosition != null) {
            codePositionList = this.nextPosition.getPositionChoices();
        }
        if (codePositionList == null || codePositionList.isEmpty()) {
            Debug.output(this.prettyName + ".parseHierarchy(): codePositionList.size = 0");
            return;
        }
        ArrayList<SymbolPart> parentList = null;
        for (CodePosition cp : codePositionList) {
            String entry;
            String newHCode = hCode + "." + cp.getHierarchyNumber();
            if (this.DEBUG) {
                Debug.output("CodeScheme.parse: " + newHCode + " with " + cp.getPrettyName());
            }
            if ((entry = props.getProperty(newHCode)) != null) {
                SymbolPart sp = new SymbolPart(cp, entry, props, parent);
                if (parentList == null && (parentList = parent.getSubs()) == null) {
                    parentList = new ArrayList<SymbolPart>();
                    parent.setSubs(parentList);
                }
                if (this.DEBUG) {
                    Debug.output("CodeScheme.parse: adding " + sp.getPrettyName() + " to " + parent.getPrettyName());
                }
                parentList.add(sp);
                if (this.DEBUG) {
                    Debug.output("CodeScheme.parse: handling " + cp.getPrettyName() + " children for " + sp.getPrettyName());
                }
                cp.parseHierarchy(newHCode, props, sp);
                continue;
            }
            if (!this.DEBUG) continue;
            Debug.output("CodeScheme.parse: no entry found for " + newHCode);
        }
    }

    public StringBuffer getDefaultSymbolCode() {
        return new StringBuffer(this.defaultSymbolCode);
    }

    public void setCodeOptions(CodeOptions co) {
        this.options = co;
    }

    public CodeOptions getCodeOptions() {
        return this.options;
    }

    public CodeOptions getCodeOptions(SymbolPart sp) {
        return this.options;
    }
}

