/** Copyright (c) 2010 Scott A. Crosby. <scott@sacrosby.com>

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU Lesser General Public License as 
   published by the Free Software Foundation, either version 3 of the 
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

package crosby.binary.test;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.zip.CRC32;

import com.google.protobuf.InvalidProtocolBufferException;

import crosby.binary.Osmformat.HeaderBlock;
import crosby.binary.Osmformat.PrimitiveBlock;
import crosby.binary.file.BlockInputStream;
import crosby.binary.file.BlockReaderAdapter;
import crosby.binary.file.FileBlock;
import crosby.binary.file.FileBlockPosition;

public class TestBlockReader implements BlockReaderAdapter {
  @Override
  public boolean skipBlock(FileBlockPosition message) {
    return false;
  }

  int blocknum = 0;
  CRC32 crc = new CRC32();
  
  @Override
  public void handleBlock(FileBlock message) {

    try {
      crc.update(message.getData().toByteArray());
      long crcval = crc.getValue();
      System.out.format("Block %6d (%s) = %d\n", blocknum++, message.getType(),
          crcval);
      crc.reset();

      if (crcval == 100267638 || crcval == 921813027) {
        if ("OSMHeader".equals(message.getType())) {
          HeaderBlock.Builder h = HeaderBlock.newBuilder();
          h.mergeFrom(message.getData());
          System.out.println(h.build().toString());
        } else if ("OSMData".equals(message.getType())) {
          PrimitiveBlock.Builder p = PrimitiveBlock.newBuilder();
          p.mergeFrom(message.getData());
          System.out.println(p.build().toString());
        }
      }
    } catch (InvalidProtocolBufferException x) {
    }
  }

  @Override
  public void complete() {
  }

  
  public static void main(String args[]) {
    try {
      BlockInputStream input = new BlockInputStream(new FileInputStream(args[0]),new TestBlockReader());
      input.process();
    } catch (FileNotFoundException e) {
      e.printStackTrace();
    } catch (IOException e) {
      e.printStackTrace();
    }
  }
  
}
