<bgno> ========== BEGIN CAirplane OBJECT ==========

	///////////////////////////////////////////////////
	//
	//	Misc. need to know data
	//
	///////////////////////////////////////////////////

	<type> -- object type --
	plan
	<name> -- object name --
	MD-83
	<acid> -- tail number
	N2345B
	<make> -- manufacturer (cessna, piper, navajo, hawker, kingair) Used by phrase system
	McDonnell Douglas 
	<CLAS> -- classification --
	8
	<USAG> -- usage --
	1
	<mxdt> -- Min Frame Rate (fps)
	40
	<emas> -- empty mass (79686lbs) --
	2477.0
	<maxM> -- max mass (140000lbs) --
	4351.577
	<mine> ---- momentOfInertia ----
	900000,400000,150000
	<dcen> ---- dynamic center ----
	0,0,10
	<mxCG> - max cg movement (ft) -
	2.0,1.0,-2.00
	<posG> - Positive G Limit (g) -
	2.73
	<negG> - Negative G Limit (g) -
	-1.5
	<iceR> -- Ice Accumulation Rate (hz) --
	0.006
	<000a> - wing area -
	1270.00
	<001a> - wing span -
	107.84
	<002a> - mean chord -
	13.25
	<CEIL> - ceiling (ft)
	41000
	<043a> - maxCruiseSpeed (kts) -
	395
	<044a> - Approach Speed (kts) -
	155
	<045a> - Best Climb (fpm) -
	3000
	<048a> - Never Exceed Speed (kts) -
	400
	<saoa> - Stall Angle of Attack (deg) -
	18.8
	<stal> -- Simple Stall Speed (ktas) --
	145
	<aoaL> -- Landing AOA (deg) --
	6

	///////////////////////////////////////////////////
	//
	//	Aerodynamic Data
	//
	///////////////////////////////////////////////////

	<wing> -- Wing Section List
	<bgno>
		////////////////
		//            //
		//  Airfoils  //
		//            //
		////////////////
		<foil> -- Airfoil Data --
		<bgno>
			<name> -- Airfoil Name --
			Wing Airfoil
			<samn> -- Min Stall Angle of Attack (rad) --
			-0.468024
			<samx> -- Max Stall Angle of Attack (rad) --0.24870208
			0.27925244
			<lift> -- Lift vs AOA Data --
			<bgno>
				<ply1>
				<bgno>
					<coef>
					0.2 4.0
				<endo>
				<tbl1>
				<bgno> -- begin table object --
					<fmt1> - data in format 1
					-3.141593 0.000000
					-0.785400 -0.2
					-0.480000 -0.5
					-0.468024 -1.672095
					-0.2792 -1.769 
					-0.0175 0.021 
					0.0000 0.143 
					0.0175 0.266  
					0.0349 0.388 
					0.0524 0.510
					0.0698 0.632 
					0.0873 0.753 
					0.1047 0.874 
					0.1222 0.995 
					0.1396 1.116 
					0.1571 1.236 
					0.1745 1.356 
					0.1920 1.475
					0.2094 1.602
					0.2269 1.720 
					0.2443 1.838
					0.2618 1.955 
					0.2793 1.625
					0.2967 1.266
					0.3142 0.875
					0.3316 0.875
					0.3491 0.825
					0.3665 0.810
					0.3840 0.805
					0.4014 0.805
					0.4189 0.805
					0.4363 0.805
					0.4538 0.805
					0.4712 0.805
					0.4887 0.805
					0.5061 0.805
					0.5236 0.805					
					<endf> - end format
				<endo> -- end table object --
			<endo>
			<drag> -- Drag vs AOA Data --
			<bgno>
				<tbl1>
				<bgno> -- begin table object --
					<fmt3> - data in format 1
					-1.58 0.30
					-0.468024 0.177328
					0.368024 0.018394 0.090756 0.90756
					1.58 0.30
					<endf> - end format
				<endo> -- end table object --
			<endo>
		<endo>
		<foil> -- Airfoil Data --
		<bgno>
			<name> -- Airfoil Name --
			Tail Airfoil
			<samn> -- Min Stall Angle of Attack (rad) --
			-0.349
			<samx> -- Max Stall Angle of Attack (rad) --
			0.349
			<lift> -- Lift vs AOA Data --
			<bgno>
				<ply1>
				<bgno>
					<coef>
					0.0 6.0
				<endo>
				<tbl1>
				<bgno> -- begin table object --
					<fmt1> - data in format 1
					-1.58 0.000000
					-0.785400 -0.5
					-0.350000 -1.0
					-0.349 -2.094
					0.349 2.094
					0.350000 1.0
					0.785400 0.5
					1.58 0.000000
					<endf> - end format
				<endo> -- end table object --
			<endo>
			<drag> -- Drag vs AOA Data --
			<bgno>
				<tbl1>
				<bgno> -- begin table object --
					<fmt3> - data in format 1
					-1.58 10.0
					1.58 0.01 0.0 4.046
					<endf> - end format
				<endo> -- end table object --
			<endo>
		<endo>
		<foil> -- Airfoil Data --
		<bgno>
			<name> -- Airfoil Name --
			Stabilizer Airfoil
			<samn> -- Min Stall Angle of Attack (rad) --
			-0.349
			<samx> -- Max Stall Angle of Attack (rad) --
			0.349
			<lift> -- Lift vs AOA Data --
			<bgno>
				<ply1>
				<bgno>
					<coef>
					0.0 6.0
				<endo>
				<tbl1>
				<bgno> -- begin table object --
					<fmt1> - data in format 1
					-1.58 0.000000
					-0.785400 -0.5
					-0.350000 -1.5
					-0.349 -2.094
					0.349 2.094
					0.350000 1.5
					0.785400 0.5
					1.58 0.000000
					<endf> - end format
				<endo> -- end table object --
			<endo>
			<drag> -- Drag vs AOA Data --
			<bgno>
				<tbl1>
				<bgno> -- begin table object --
					<fmt3> - data in format 1
					-1.58 1.0
					-0.35 0.5
					0.35 0.01 0.0 2.046
					1.58 1.0
					<endf> - end format
				<endo> -- end table object --
			<endo>
		<endo>
		/////////////////////
		//                 //
		//  Wing Sections  //
		//                 //
		/////////////////////
		<wing> -- Left Wing/Aileron Section Data
		<bgno>
			<name> -- Wing Section Name --
			Left w/Aileron
			<foil> -- Airfoil Name --
			Wing Airfoil
			<ctrl> -- Controller Type --
			AILERON
			<area> -- Wing Area (sq.ft) --
			233.25
			<span> -- Wing Span (ft) --
			17.9
			<bPos> -- AC Location (rel. to MAC) --
			-37.8,0.0,0.0
			<bAng> -- Incidence Angles (deg) --
			-3,-8,-8
			<grnd> -- Use Ground Effect --
			<gAGL> -- Ground Effect AGL (ft) --
			51.4
			<geff> -- Ground Effect Fudge Factor (should be 1.0) --
			0.75
			<idcf> -- Ice Drag Coefficient --
			0.02
			<flpL> -- Lift vs Flap Angle Data --
			<bgno>
				<cof1>
				1.15
			<endo>
			<flpD> -- Drag vs Flap Angle Data --
			<bgno>
				<cof1>
				0.05
			<endo>
		<endo>
		<wing> -- Right Wing/Aileron Section Data
		<bgno>
			<name> -- Wing Section Name --
			Right w/Aileron
			<foil> -- Airfoil Name --
			Wing Airfoil
			<ctrl> -- Controller Type --
			AILERON
			<area> -- Win Area (sq.ft) --
			233.25
			<span> -- Wing Span (ft) --
			17.9
			<bPos> -- AC Location (rel. to MAC) --
			37.8,0.0,0.0
			<bAng> -- Incidence Angles (deg) --
			-3,8,8
			<grnd> -- Use Ground Effect --
			<gAGL> -- Ground Effect AGL (ft) --
			51.4
			<geff> -- Ground Effect Fudge Factor (should be 1.0) --
			0.75
			<idcf> -- Ice Drag Coefficient --
			0.02
			<flpL> -- Lift vs Flap Angle Data --
			<bgno>
				<cof1>
				-1.15
			<endo>
			<flpD> -- Drag vs Flap Angle Data --
			<bgno>
				<cof1>
				-0.05
			<endo>
		<endo>
		<wing> -- Left Wing/Flap Section Data
		<bgno>
			<name> -- Wing Section Name --
			Left w/Flap
			<foil> -- Airfoil Name --
			Wing Airfoil
			<ctrl> -- Controller Type --
			FLAP
			<splr> -- Spoiler Type --
			SPOILER
			<area> -- Wing Area (sq.ft) --
			402.17
			<span> -- Wing Span (ft) --
			36.0
			<bPos> -- AC Location (rel. to MAC) --
			-18.1,0,0
			<bAng> -- Incidence Angles (deg) --
			-3,-8,-8
			<grnd> -- Use Ground Effect --
			<gAGL> -- Ground Effect AGL (ft) --
			51.4
			<geff> -- Ground Effect Fudge Factor (should be 1.0) --
			0.75
			<hnge> -- Pitch Moment Cf due to flaps --
			15.0
			<idcf> -- Ice Drag Coefficient --
			0.02
			<flpL> -- Lift vs Flap Angle Data --
			<bgno>
				<cof1>
				1.40
			<endo>
			<flpD> -- Drag vs Flap Angle Data --
			<bgno>
				<cof1>
				0.45
			<endo>
			<splD> -- Drag vs Spoiler Angle Data --
			<bgno>
				<cof1>
				0.15
			<endo>
		<endo>
		<wing> -- Right Wing/Flap Section Data
		<bgno>
			<name> -- Wing Section Name --
			Right w/Flap
			<foil> -- Airfoil Name --
			Wing Airfoil
			<ctrl> -- Controller Type --
			FLAP
			<splr> -- Spoiler Type --
			SPOILER
			<area> -- Wing Area (sq.ft) --
			402.17
			<span> -- Wing Span (ft) --
			36.0
			<bPos> -- AC Location (rel. to MAC) --
			18.1,0,0
			<bAng> -- Incidence Angles (deg) --
			-3,8,8
			<grnd> -- Use Ground Effect --
			<gAGL> -- Ground Effect AGL (ft) --
			51.4
			<geff> -- Ground Effect Fudge Factor (should be 1.0) --
			0.75
			<hnge> -- Pitch Moment Cf due to flaps --
			15.0
			<idcf> -- Ice Drag Coefficient --
			0.02
			<flpL> -- Lift vs Flap Angle Data --
			<bgno>
				<cof1>
				1.40
			<endo>
			<flpD> -- Drag vs Flap Angle Data --
			<bgno>
				<cof1>
				0.45
			<endo>
			<splD> -- Drag vs Spoiler Angle Data --
			<bgno>
				<cof1>
				0.15
			<endo>
		<endo>
		<wing> -- Tail Wing Section Data
		<bgno>
			<name> -- Wing Section Name --
			Tail w/rudder
			<foil> -- Airfoil Name --
			Tail Airfoil
			<ctrl> -- Controller Type --
			RUDDER
			<orei> -- Orientation (1=Vertical) --
			1
			<area> -- Wing Area (sq.ft) --
			167.9
			<span> -- Wing Span (ft) --
			13.45
			<effL> -- Lift Efficiency --
			2.5
			<bPos> -- AC Location (rel. to MAC) --
			0,16.3,-55.5
			<idcf> -- Ice Drag Coefficient --
			0.02
			<flpL> -- Lift vs Flap Angle Data --
			<bgno>
				<cof1>
				-1.0
			<endo>
			<flpD> -- Drag vs Flap Angle Data --
			<bgno>
				<ply1>
				<bgno>
					<coef>
					0.0 0.0 0.36
				<endo>
			<endo>
		<endo>
		<wing> -- Stabilizer Wing Section Data
		<bgno>
			<name> -- Wing Section Name --
			Stabilizer w/elevator
			<foil> -- Airfoil Name --
			Stabilizer Airfoil
			<ctrl> -- Controller Type --
			ELEVATOR
			<area> -- Wing Area (sq.ft) --
			345.9
			<span> -- Wing Span (ft) --
			40.15
			<effL> -- Lift Efficiency --
			5.5
			<bPos> -- AC Location (rel. to MAC) --
			0,23.9,-63.7
			<bAng> -- Orientation Angles (deg) --
			3,0,0
			<idcf> -- Ice Drag Coefficient --
			0.02
			<flpL> -- Lift vs Flap Angle Data --
			<bgno>
				<cof1>
				6.5
			<endo>
			<flpD> -- Drag vs Flap Angle Data --
			<bgno>
				<ply1>
				<bgno>
					<coef>
					0.0 0.0 0.0
				<endo>
			<endo>
		<endo>
	<endo>

	///////////////////////////////////////////////////
	//
	//	Movable Surfaces
	//
	///////////////////////////////////////////////////

	<aprt> -- Movable Surfaces List --
	<bgno>
		<part> -- Rudder --
		<bgno>
			<name> -- Model Part Name --
			rudder
			<dflc> -- Deflection Controler Tag --
			RUDDER
			<axis> -- Rotation Axis --
			VERTICAL
		<endo>
		<part> -- Left Elevator --
		<bgno>
			<name> -- Model Part Name --
			leftelevator
			<dflc> -- Deflection Controler Tag --
			ELEVATOR
			<axis> -- Rotation Axis --
			LATERAL
			<nvrt> -- Invert deflection angle --
		<endo>
		<part> -- Right Elevator --
		<bgno>
			<name> -- Model Part Name --
			rightelevator
			<dflc> -- Deflection Controler Tag --
			ELEVATOR
			<axis> -- Rotation Axis --
			LATERAL
			<nvrt> -- Invert deflection angle --
		<endo>
		<part> -- Left Aileron --
		<bgno>
			<name> -- Model Part Name --
			laileron
			<dflc> -- Deflection Controler Tag --
			AILERON
			<axis> -- Rotation Axis --
			LATERAL
			<nvrt> -- Invert deflection angle --
		<endo>
		<part> -- Right Aileron --
		<bgno>
			<name> -- Model Part Name --
			raileron
			<dflc> -- Deflection Controler Tag --
			AILERON
			<axis> -- Rotation Axis --
			LATERAL
		<endo>
		<part> -- Right Flap (inner section)  --
		<bgno>
			<name> -- Model Part Name --
			leftflapspar1
			<dflc> -- Deflection Controler Tag --
			FLAP
			<axis> -- Rotation Axis --
			LATERAL
			<nvrt> -- Invert deflection angle --
			<dply> -- Deployable Controler Tag --
			FLAP
			<rPos> -- Relative position when deployed --
			0,0,0
			<rAng> -- Relative angle when deployed
			52,0,0
		<endo>
		<part> -- Right Flap (inner section)  --
		<bgno>
			<name> -- Model Part Name --
			leftflapspar2
			<dflc> -- Deflection Controler Tag --
			FLAP
			<axis> -- Rotation Axis --
			LATERAL
			<nvrt> -- Invert deflection angle --
			<dply> -- Deployable Controler Tag --
			FLAP
			<rPos> -- Relative position when deployed --
			0,0,0
			<rAng> -- Relative angle when deployed
			56,0,0
		<endo>
		<part> -- Right Flap (inner section)  --
		<bgno>
			<name> -- Model Part Name --
			leftflapspar3
			<dflc> -- Deflection Controler Tag --
			FLAP
			<axis> -- Rotation Axis --
			LATERAL
			<nvrt> -- Invert deflection angle --
			<dply> -- Deployable Controler Tag --
			FLAP
			<rPos> -- Relative position when deployed --
			0,0,0
			<rAng> -- Relative angle when deployed
			64,0,0
		<endo>
		<part> -- Right Flap (inner section)  --
		<bgno>
			<name> -- Model Part Name --
			leftflapouteru
			<dflc> -- Deflection Controler Tag --
			FLAP
			<axis> -- Rotation Axis --
			LATERAL
			<nvrt> -- Invert deflection angle --
			<dply> -- Deployable Controler Tag --
			FLAP
			<rPos> -- Relative position when deployed --
			0.3,0,1.7
			<rAng> -- Relative angle when deployed
			45,0,0
		<endo>
		<part> -- Right Flap (inner section)  --
		<bgno>
			<name> -- Model Part Name --
			leftflapouterl
			<dflc> -- Deflection Controler Tag --
			FLAP
			<axis> -- Rotation Axis --
			LATERAL
			<nvrt> -- Invert deflection angle --
			<dply> -- Deployable Controler Tag --
			FLAP
			<rPos> -- Relative position when deployed --
			0.3,0,1
			<rAng> -- Relative angle when deployed
			35,0,0
		<endo>
		<part> -- Right Flap (inner section)  --
		<bgno>
			<name> -- Model Part Name --
			leftflapu
			<dflc> -- Deflection Controler Tag --
			FLAP
			<axis> -- Rotation Axis --
			LATERAL
			<nvrt> -- Invert deflection angle --
			<dply> -- Deployable Controler Tag --
			FLAP
			<rPos> -- Relative position when deployed --
			0,0,0
			<rAng> -- Relative angle when deployed
			50,-.2,0
		<endo>
		<part> -- Right Flap (inner section)  --
		<bgno>
			<name> -- Model Part Name --
			leftflapl
			<dflc> -- Deflection Controler Tag --
			FLAP
			<axis> -- Rotation Axis --
			LATERAL
			<nvrt> -- Invert deflection angle --
			<dply> -- Deployable Controler Tag --
			FLAP
			<rPos> -- Relative position when deployed --
			0,0.7,0
			<rAng> -- Relative angle when deployed
			30,0,0
		<endo>
		<part> -- Right Flap (inner section)  --
		<bgno>
			<name> -- Model Part Name --
			rightflapspar1
			<dflc> -- Deflection Controler Tag --
			FLAP
			<axis> -- Rotation Axis --
			LATERAL
			<nvrt> -- Invert deflection angle --
			<dply> -- Deployable Controler Tag --
			FLAP
			<rPos> -- Relative position when deployed --
			0,0,0
			<rAng> -- Relative angle when deployed
			52,0,0
		<endo>
		<part> -- Right Flap (inner section)  --
		<bgno>
			<name> -- Model Part Name --
			rightflapspar2
			<dflc> -- Deflection Controler Tag --
			FLAP
			<axis> -- Rotation Axis --
			LATERAL
			<nvrt> -- Invert deflection angle --
			<dply> -- Deployable Controler Tag --
			FLAP
			<rPos> -- Relative position when deployed --
			0,0,0
			<rAng> -- Relative angle when deployed
			56,0,0
		<endo>
		<part> -- Right Flap (inner section)  --
		<bgno>
			<name> -- Model Part Name --
			rightflapspar3
			<dflc> -- Deflection Controler Tag --
			FLAP
			<axis> -- Rotation Axis --
			LATERAL
			<nvrt> -- Invert deflection angle --
			<dply> -- Deployable Controler Tag --
			FLAP
			<rPos> -- Relative position when deployed --
			0,0,0
			<rAng> -- Relative angle when deployed
			64,0,0
		<endo>
		<part> -- Right Flap (inner section)  --
		<bgno>
			<name> -- Model Part Name --
			rightflapouteru
			<dflc> -- Deflection Controler Tag --
			FLAP
			<axis> -- Rotation Axis --
			LATERAL
			<nvrt> -- Invert deflection angle --
			<dply> -- Deployable Controler Tag --
			FLAP
			<rPos> -- Relative position when deployed --
			0.3,0,1.7
			<rAng> -- Relative angle when deployed
			45,0,0
		<endo>
		<part> -- Right Flap (inner section)  --
		<bgno>
			<name> -- Model Part Name --
			rightflapouterl
			<dflc> -- Deflection Controler Tag --
			FLAP
			<axis> -- Rotation Axis --
			LATERAL
			<nvrt> -- Invert deflection angle --
			<dply> -- Deployable Controler Tag --
			FLAP
			<rPos> -- Relative position when deployed --
			0.3,0,1
			<rAng> -- Relative angle when deployed
			35,0,0
		<endo>
		<part> -- Right Flap (inner section)  --
		<bgno>
			<name> -- Model Part Name --
			rightflapu
			<dflc> -- Deflection Controler Tag --
			FLAP
			<axis> -- Rotation Axis --
			LATERAL
			<nvrt> -- Invert deflection angle --
			<dply> -- Deployable Controler Tag --
			FLAP
			<rPos> -- Relative position when deployed --
			0,0,0
			<rAng> -- Relative angle when deployed
			50,-.2,0
		<endo>
		<part> -- Right Flap (inner section)  --
		<bgno>
			<name> -- Model Part Name --
			rightflapl
			<dflc> -- Deflection Controler Tag --
			FLAP
			<axis> -- Rotation Axis --
			LATERAL
			<nvrt> -- Invert deflection angle --
			<dply> -- Deployable Controler Tag --
			FLAP
			<rPos> -- Relative position when deployed --
			0,0.7,0
			<rAng> -- Relative angle when deployed
			30,0,0
		<endo>
		<part> -- Left Speed Brake (top) --
		<bgno>
			<name> -- Model Part Name --
			leftspoiler
			<dflc> -- Deflection Controler Tag --
			SPOILER
			<axis> -- Rotation Axis --
			LATERAL
			<hide> -- Hide this part 
		<endo>
		<part> -- Left Speed Brake (bottom) --
		<bgno>
			<name> -- Model Part Name --
			lspoilerouter
			<dflc> -- Deflection Controler Tag --
			SPOILER
			<axis> -- Rotation Axis --
			LATERAL
			<hide> -- Hide this part 
		<endo>
		<part> -- Right Speed Barke (top)  --
		<bgno>
			<name> -- Model Part Name --
			rightspoiler
			<dflc> -- Deflection Controler Tag --
			SPOILER
			<axis> -- Rotation Axis --
			LATERAL
			<hide> -- Hide this part 		
		<endo>
		<part> -- Right Speed Barke (bottom)  --
		<bgno>
			<name> -- Model Part Name --
			rspoilerouter
			<dflc> -- Deflection Controler Tag --
			SPOILER
			<axis> -- Rotation Axis --
			LATERAL
			<hide> -- Hide this part 		
		<endo>
	<endo>

	///////////////////////////////////////////////////
	//
	//	Model Manager
	//
	///////////////////////////////////////////////////

	<mmgr> ---- model manager info ----
	<bgno> ========== BEGIN MODEL MANAGER ==========
		<mod2> ---- model entry ----
		comp
		md83h.arm
		200
		<mod2> ---- model entry ----
		comp
		md83h.arm
		50
		<mod2> ---- model entry ----
		comp
		md83h.arm
		10
	<endo> ========== END MODEL MANAGER ==========

	///////////////////////////////////////////////////
	//
	//	Camera Manager
	//
	///////////////////////////////////////////////////

	<cmgr> -- camera manager info --
	<bgno> ========== BEGIN CCAMERAMANAGER OBJECT ==========
		<came> ---- camera entry ----
		cock
		<bgno> ========== BEGIN CCAMERA OBJECT ==========
			<seat> ---- seat location (p,b,h,x,y,z) ----
			0
			0
			0
			-3.0
			10.0
			66.0
			<panl> ---- panel ----
			<bgno> ---- begin ----
				<id__> ---- id ----
				frnt
				<main> ---- default ----
				<hdg_> ---- heading ----
				0.0
				<ptch> ---- pitch ----
				5.0
				<pnls> ---- panels (L,R,U,D) ----
				uplt
				uprt
				over
				fms_
			<endo> ---- end ----
			<panl> ---- panel ----
			<bgno> ---- begin ----
				<id__> ---- id ----
				floo
				<hdg_> ---- heading ----
				0.0
				<ptch> ---- pitch ----
				45.0
				<pnls> ---- panels (L,R,U,D) ----
				ppnl
				cpnl
				fms_
				NONE
			<endo> ---- end ----
			<panl> ---- panel ----
			<bgno> ---- begin ----
				<id__> ---- id ----
				over
				<hdg_> ---- heading ----
				0.0
				<ptch> ---- pitch ----
				-45.0
				<pnls> ---- panels (L,R,U,D) ----
				NONE
				NONE
				NONE
				frnt
			<endo> ---- end ----
			<panl> ---- panel ----
			<bgno> ---- begin ----
				<id__> ---- id ----
				ppnl
				<hdg_> ---- heading ----
				270.0
				<ptch> ---- pitch ----
				45.0
				<pnls> ---- panels (L,R,U,D) ----
				NONE
				floo
				left
				NONE
			<endo> ---- end ----
			<panl> ---- panel ----
			<bgno> ---- begin ----
				<id__> ---- id ----
				cpnl
				<hdg_> ---- heading ----
				90.0
				<ptch> ---- pitch ----
				45.0
				<pnls> ---- panels (L,R,U,D) ----
				floo
				NONE
				rght
				NONE
			<endo> ---- end ----
			<panl> ---- panel ----
			<bgno> ---- begin ----
				<id__> ---- id ----
				apu_
				<hdg_> ---- heading ----
				270.0
				<ptch> ---- pitch ----
				0.0
				<pnls> ---- panels (L,R,U,D) ----
				lwlt
				left
				NONE
				NONE
			<endo> ---- end ----
			<panl> ---- panel ----
			<bgno> ---- begin ----
				<id__> ---- id ----
				fms_
				<hdg_> ---- heading ----
				0.0
				<ptch> ---- pitch ----
				45.0
				<pnls> ---- panels (L,R,U,D) ----
				ppnl
				cpnl
				frnt
				floo
			<endo> ---- end ----
			<panl> ---- panel ----
			<bgno> ---- begin ----
				<id__> ---- id ----
				uprt
				<hdg_> ---- heading ----
				45.0
				<pnls> ---- panels (L,R,U,D) ----
				frnt
				rght
				NONE
				NONE
			<endo> ---- end ----
			<panl> ---- panel ----
			<bgno> ---- begin ----
				<id__> ---- id ----
				rght
				<hdg_> ---- heading ----
				90.0
				<pnls> ---- panels (L,R,U,D) ----
				uprt
				lwrt
				NONE
				cpnl
			<endo> ---- end ----
			<panl> ---- panel ----
			<bgno> ---- begin ----
				<id__> ---- id ----
				lwrt
				<hdg_> ---- heading ----
				135.0
				<pnls> ---- panels (L,R,U,D) ----
				rght
				back
				NONE
				NONE
			<endo> ---- end ----
			<panl> ---- panel ----
			<bgno> ---- begin ----
				<id__> ---- id ----
				back
				<hdg_> ---- heading ----
				180.0
				<pnls> ---- panels (L,R,U,D) ----
				lwrt
				lwlt
				NONE
				NONE
			<endo> ---- end ----
			<panl> ---- panel ----
			<bgno> ---- begin ----
				<id__> ---- id ----
				lwlt
				<hdg_> ---- heading ----
				225.0
				<pnls> ---- panels (L,R,U,D) ----
				back
				apu_
				NONE
				NONE
			<endo> ---- end ----
			<panl> ---- panel ----
			<bgno> ---- begin ----
				<id__> ---- id ----
				left
				<hdg_> ---- heading ----
				270.0
				<pnls> ---- panels (L,R,U,D) ----
				apu_
				uplt
				NONE
				ppnl
			<endo> ---- end ----
			<panl> ---- panel ----
			<bgno> ---- begin ----
				<id__> ---- id ----
				uplt
				<hdg_> ---- heading ----
				315.0
				<pnls> ---- panels (L,R,U,D) ----
				left
				frnt
				NONE
				NONE
			<endo> ---- end ----
		<endo> ========== END CCAMERA OBJECT ==========
		<came> ---- camera entry ----
		spot
		<bgno> ========== BEGIN CCAMERA OBJECT ==========
		<endo> ========== END CCAMERA OBJECT ==========
		<came> ---- camera entry ----
		flyb
		<bgno> ========== BEGIN CCAMERA OBJECT ==========
		<endo> ========== END CCAMERA OBJECT ==========
		<came> ---- camera entry ----
		towr
		<bgno> ========== BEGIN CCAMERA OBJECT ==========
		<endo> ========== END CCAMERA OBJECT ==========
<endo> ========== END CCAMERAMANAGER OBJECT ==========

	///////////////////////////////////////////////////
	//
	//	Landing Gear
	//
	///////////////////////////////////////////////////

	<germ> -- landing gear
	<bgno> -- Begin Langing gear manager
		<gSpd> -- Gear Damage Speeds (kias) --
		220	Extended
		220	Extending
		220	Retracting
		<time> -- Total Sequence Time (sec) --
		4
		<gear> -- landing gear entry
		gsng
		<bgno> -- Begin Single axis gear
			<tim0> -- In Time (sec) --
			0
			<tim1> -- Out Time (sec) --
			4
			<part> -- Movable Part (Nose Gear) --
			<bgno>
				<name> -- Part Name --
				gfront
				<tim0> -- In Time (sec) --
				0.5
				<tim1> -- Out Time (sec) --
				3.5
				<ang0> -- In Angle (deg) (p,h,b) --
				90,0,0
				<ang1> -- Out Angle (deg) (p,h,b) --
				0,0,0
				<axis> -- Rotation Axis --
				LATERAL
				<pos0> -- In Position (ft) --
				0,0,-1
				<pos1> -- Out Position (ft) --
				0,0,0
				<hide> -- Hide this part when Retracted --
			<endo>
			<part> -- Movable Part (Left Nose Gear Door) (Phase 2) --
			<bgno>
				<name> -- Part Name --
				rightfrontdoor
				<tim0> -- In Time (sec) --
				0
				<tim1> -- Out Time (sec) --
				0.5
				<ang0> -- In Angle (deg) (p,h,b) --
				0,0,0
				<ang1> -- Out Angle (deg) (p,h,b) --
				0,0,90
				<axis> -- Rotation Axis --
				LONGITUDINAL
			<endo>
			<part> -- Movable Part (Right Nose Gear Door) (Phase 1) --
			<bgno>
				<name> -- Part Name --
				rightfrontdoor
				<tim0> -- In Time (sec) --
				3.5
				<tim1> -- Out Time (sec) --
				4.0
				<ang0> -- In Angle (deg) (p,h,b) --
				0,0,90
				<ang1> -- Out Angle (deg) (p,h,b) --
				0,0,0
				<axis> -- Rotation Axis --
				LONGITUDINAL
			<endo>
			<part> -- Movable Part (Left Nose Gear Door) (Phase 2) --
			<bgno>
				<name> -- Part Name --
				leftfrontdoor
				<tim0> -- In Time (sec) --
				0
				<tim1> -- Out Time (sec) --
				0.5
				<ang0> -- In Angle (deg) (p,h,b) --
				0,0,0
				<ang1> -- Out Angle (deg) (p,h,b) --
				0,0,-90
				<axis> -- Rotation Axis --
				LONGITUDINAL
			<endo>
			<part> -- Movable Part (Right Nose Gear Door) (Phase 1) --
			<bgno>
				<name> -- Part Name --
				leftfrontdoor
				<tim0> -- In Time (sec) --
				3.5
				<tim1> -- Out Time (sec) --
				4.0
				<ang0> -- In Angle (deg) (p,h,b) --
				0,0,-90
				<ang1> -- Out Angle (deg) (p,h,b) --
				0,0,0
				<axis> -- Rotation Axis --
				LONGITUDINAL
			<endo>
		<endo>
		<gear> -- landing gear entry
		gsng
		<bgno> -- Begin Single axis gear
			<tim0> -- In Time (sec) --
			0
			<tim1> -- Out Time (sec) --
			4
			<part> -- Movable Part (Right Gear) --
			<bgno>
				<name> -- Part Name --
				gright
				<tim0> -- In Time (sec) --
				0.5
				<tim1> -- Out Time (sec) --
				3.5
				<ang0> -- In Angle (deg) (p,h,b) --
				0,0,-85
				<ang1> -- Out Angle (deg) (p,h,b) --
				0,0,0
				<axis> -- Rotation Axis --
				LONGITUDINAL
				<pos0> -- In Position (ft) --
				1,0,0
				<pos1> -- Out Position (ft) --
				-0.1,0,0
				<hide> -- Hide this part when Retracted --
			<endo>
			<part> -- Movable Part (Right Gear Left Door) (Phase 1) --
			<bgno>
				<name> -- Part Name --
				rightreardoor
				<tim0> -- In Time (sec) --
				0
				<tim1> -- Out Time (sec) --
				0.5
				<ang0> -- In Angle (deg) (p,h,b) --
				0,0,0
				<ang1> -- Out Angle (deg) (p,h,b) --
				0,0,-90
				<axis> -- Rotation Axis --
				LONGITUDINAL
			<endo>
			<part> -- Movable Part (Right Gear Left Door) (Phase 2) --
			<bgno>
				<name> -- Part Name --
				rightreardoor
				<tim0> -- In Time (sec) --
				3.5
				<tim1> -- Out Time (sec) --
				4.0
				<ang0> -- In Angle (deg) (p,h,b) --
				0,0,-90
				<ang1> -- Out Angle (deg) (p,h,b) --
				0,0,0
				<axis> -- Rotation Axis --
				LONGITUDINAL
			<endo>
		<endo>
		<gear> -- landing gear entry
		gsng
		<bgno> -- Begin Single axis gear
			<tim0> -- In Time (sec) --
			0
			<tim1> -- Out Time (sec) --
			4
			<part> -- Movable Part (Left Gear) --
			<bgno>
				<name> -- Part Name --
				gleft
				<tim0> -- In Time (sec) --
				0.5
				<tim1> -- Out Time (sec) --
				3.5
				<ang0> -- In Angle (deg) (p,h,b) --
				0,0,85
				<ang1> -- Out Angle (deg) (p,h,b) --
				0,0,0
				<axis> -- Rotation Axis --
				LONGITUDINAL
				<pos0> -- In Position (ft) --
				-1,0,0
				<pos1> -- Out Position (ft) --
				0.1,0,0
				<hide> -- Hide this part when Retracted --
			<endo>
			<part> -- Movable Part (Right Gear Left Door) (Phase 1) --
			<bgno>
				<name> -- Part Name --
				leftreardoor
				<tim0> -- In Time (sec) --
				0
				<tim1> -- Out Time (sec) --
				0.5
				<ang0> -- In Angle (deg) (p,h,b) --
				0,0,0
				<ang1> -- Out Angle (deg) (p,h,b) --
				0,0,90
				<axis> -- Rotation Axis --
				LONGITUDINAL
			<endo>
			<part> -- Movable Part (Right Gear Left Door) (Phase 2) --
			<bgno>
				<name> -- Part Name --
				leftreardoor
				<tim0> -- In Time (sec) --
				3.5
				<tim1> -- Out Time (sec) --
				4.0
				<ang0> -- In Angle (deg) (p,h,b) --
				0,0,90
				<ang1> -- Out Angle (deg) (p,h,b) --
				0,0,0
				<axis> -- Rotation Axis --
				LONGITUDINAL
			<endo>
		<endo>
	<endo> -- End landing gear

	///////////////////////////////////////////////////
	//
	//	Cockpit Manager
	//
	///////////////////////////////////////////////////

	<ckmg> ---- cockpit manager info ----
	<bgno> ========== BEGIN CCOCKPITMANAGER OBJECT ==========
		<ckpt> ---- forward cockpit entry ----
		frnt
		MD83.pnl
		<ckpt> ---- floor console entry ----
		floo
		hawker1.pnl
		<ckpt> ---- overhead entry ----
		over
		hawker2.pnl
		<ckpt> ---- pilot panel entry ----
		ppnl
		hawker3.pnl
		<ckpt> ---- copilot panel entry ----
		cpnl
		hawker4.pnl
		<ckpt> ---- fms panel entry ----
		apu_
		hawker5.pnl
		<ckpt> ---- fms panel entry ----
		fms_
		hawker6.pnl
		<ckpt> ---- upper right cockpit entry ----
		uprt
		hawker01
		<ckpt> ---- right cockpit entry ----
		rght
		hawker02
		<ckpt> ---- lower right cockpit entry ----
		lwrt
		hawker03
		<ckpt> ---- backward cockpit entry ----
		back
		hawker04
		<ckpt> ---- lower left cockpit entry ----
		lwlt
		hawker05
		<ckpt> ---- left cockpit entry ----
		left
		hawker06
		<ckpt> ---- upper left cockpit entry ----
		uplt
		hawker07
	<endo> ========== END CCOCKPITMANAGER OBJECT ==========

	///////////////////////////////////////////////////
	//
	//	Sound Effects File Spec
	//
	///////////////////////////////////////////////////

	<sfxd> ---- sound effects data file ----
	pdjt
	MD83.sfx

	///////////////////////////////////////////////////
	//
	//	Mini Panel File Spec
	//
	///////////////////////////////////////////////////

	<mini> ---- mini cockpit panel file ----
	minihawk.pnl

	///////////////////////////////////////////////////
	//
	//	Suspension Manager
	//
	///////////////////////////////////////////////////

	<sspm> -- suspension object --
	<bgno> ========== BEGIN suspension ==========
		<susp> -- suspension info
		<bgno> -- begin independent suspension info --
			<name> -- wheel part name --
			frontwheel
			<damn> -- wheel damage region name --
			gfront
			<ster> -- steerable wheel --
			1
			<mStr> -- max steer angle (deg) --
			45.0
			<maxC> -- max compression --
			1.0
			<damR> -- damping ratio --
			0.85
			<drag> -- Drag Constant --
			1.7
			<fxht> -- Strut Height Adjustment (ft) --
			0.0
		<endo> -- end independent suspension info --
		<susp> -- suspension info
		<bgno> -- begin independent suspension info --
			<name> -- wheel part name --
			leftwheel
			<damn> -- wheel damage region name --
			gleft
			<brak> -- wheel has brake --
			-1
			<brkF> -- Brake Factor --
			1.0
			<maxC> -- max compression --
			1.5
			<damR> -- damping ratio --
			0.875
			<drag> -- Drag Constant --
			2.2
			<fxht> -- Strut Height Adjustment (ft) --
			0.0
		<endo> -- end independent suspension info --
		<susp> -- suspension info
		<bgno> -- begin independent suspension info --
			<name> -- wheel part name --
			rightwheel
			<damn> -- wheel damage region name --
			gright
			<brak> -- wheel has brake --
			1
			<brkF> -- Brake Factor --
			1.0
			<maxC> -- max compression --
			1.5
			<damR> -- damping ratio --
			0.875
			<drag> -- Drag Constant --
			2.2
			<fxht> -- Strut Height Adjustment (ft) --
			0.0
		<endo> -- end independent suspension info --
	<endo> ========== END SUSPENSION ==========

	///////////////////////////////////////////////////
	//
	//	Engine Manager
	//
	///////////////////////////////////////////////////

	<engm> -- engine manager --
	<bgno> -- begin engine list --
		<engn> -- Turbofan --
		Tfan
		<bgno>
			<ngnf> - Left engine spec file name
			MD83.ngn
			<bPos> - position of thrust
			-9.7,7.6,-46.0
			<eprt> -- Moving Parts List --
			<bgno>
				<part> -- Left Reverser (bottom) --
				<bgno>
					<name> -- Model Part Name --
					leftbottomreverse
					<axis> -- Rotation Axis --
					LATERAL
					<dply> -- Deployable Controler Tag --
					REVERSER
					<rPos> -- Relative position when deployed --
					0,0.2,0.3
					<rAng> -- Relative Angle when deployed --
					70,0,0
				<endo>
				<part> -- Left Reverser (top) --
				<bgno>
					<name> -- Model Part Name --
					lefttopreverse
					<axis> -- Rotation Axis --
					LATERAL
					<dply> -- Deployable Controler Tag --
					REVERSER
					<rPos> -- Relative position when deployed --
					0,-0.2,0.3
					<rAng> -- Relative Angle when deployed --
					-70,0,0
				<endo>
			<endo>
		<endo>
		<engn> -- Turboprop --
		Tfan
		<bgno>
			<ngnf> - Right engine spec file name
			MD83.ngn
			<bPos> - position of thrust
			9.7,7.6,-46.0
			<eprt> -- Moving Parts List --
			<bgno>
				<part> -- Right Reverer (Bottom) --
				<bgno>
					<name> -- Model Part Name --
					rightbottomreverse
					<axis> -- Rotation Axis --
					LATERAL
					<dply> -- Deployable Controler Tag --
					REVERSER
					<rPos> -- Relative position when deployed --
					0,0.2,0.3
					<rAng> -- Relative Angle when deployed --
					70,0,0
				<endo>
				<part> -- Right Reverser (top) --
				<bgno>
					<name> -- Model Part Name --
					righttopreverse
					<axis> -- Rotation Axis --
					LATERAL
					<dply> -- Deployable Controler Tag --
					REVERSER
					<rPos> -- Relative position when deployed --
					0,0.1,0.55
					<rAng> -- Relative Angle when deployed --
					-70,0,0
				<endo>
			<endo>
		<endo>
		<engn> -- APU --
		Tapu
		<bgno>
			<ngnf> - APU engine spec file name
			apu.ngn
		<endo>
		<csfn> -- Control Set File Name --
		hawker.jcs
	<endo> -- end engine list --

	///////////////////////////////////////////////////
	//
	//	Fuel Manager
	//
	///////////////////////////////////////////////////

	<fman> -- fuel system entry --
	<bgno>
		<engn> - Engine Fuel System Entry -
		<bgno>
			<xfed> -- Crossfeed System --
			2
			<pmpE> -- Engine Driven Fuel Pump Info --
			<bgno>
				<pres> -- Pressure Pumped (psi) --
				11
			<endo>
			<pmp1> -- Auxiliary Fuel Pump Info --
			<bgno>
				<pres> -- Pressure Pumped (psi) --
				12
			<endo>
			<cell> -- fuel cell entry --
			<bgno> -- Left Integral Wing Tank --
				<fcap> -- fuel cell capacity
				3916.0
				<fqty> -- fuel cell quantity
				3916.0
				<valv> -- fuel valve ON
				<bPos> -- cell position from cg
				0,0,-1
				<grop> -- group number --
				1
				<ordr> -- fill order --
				1
				<ufil> -- UI Image Filename
				LF-Gauge.bmp
				<utnk> -- UI Image Location
				531
				282
				<usdr> -- UI Slider Location
				531
				332
				141
			<endo> -- end fuel cell data --
		<endo> -- end Engine Fuel System --
		<engn> - Engine Fuel System Entry -
		<bgno>
			<xfed> -- Crossfeed System --
			1
			<pmpE> -- Engine Driven Fuel Pump Info --
			<bgno>
				<pres> -- Pressure Pumped (psi) --
				11
			<endo>
			<pmp1> -- Auxiliary Fuel Pump Info --
			<bgno>
				<pres> -- Pressure Pumped (psi) --
				12
			<endo>
			<cell> -- fuel cell entry --
			<bgno> -- Right Outboard Integral Wing Tank --
				<fcap> -- fuel cell capacity
				3916.0
				<fqty> -- fuel cell quantity
				3916.0
				<valv> -- fuel valve ON
				<bPos> -- cell position from cg
				0,0,-1
				<grop> -- group number --
				1
				<ordr> -- fill order --
				1
				<ufil> -- UI Image Filename
				LF-Gauge.bmp
				<utnk> -- UI Image Location
				135
				282
				<usdr> -- UI Slider Location
				135
				332
				141
			<endo> -- end fuel cell data --
		<endo> -- end Engine Fuel System --
	<endo> -- end fuel list --

	///////////////////////////////////////////////////
	//
	//	External Light Manager
	//
	///////////////////////////////////////////////////

	<ltmn> ---- vehicle light manager ----
	<lite> -- vehicle light --
	spot
	lnd1
	<bgno> ========== BEGIN OBJECT ==========
		<part> ---- associated part name ----
		rightwing
		<floc> ---- part space location ----
		2.05
		0.00
		4.00
		<iten> ---- intensity (ii.ff) ----
		700000
		<purp> -- Purpose (NAV|LAND) --
		LAND
		<rdus> -- radius of light bitmap -- 
		1.25
		<clen> -- cone length (ft) 
		150.
		<cnrm> -- cone rim radius (ft) 
		20.0
		<cnbr> -- cone base radius (ft) 
		0.25
		<ctex> -- cone texture 
		litefuzz.raw
		<ltex> -- light texture 
		headlite.raw
	<endo> ========== END OBJECT ==========
	<lite> -- vehicle light --
	spot
	lnd2
	<bgno> ========== BEGIN OBJECT ==========
		<part> ---- associated part name ----
		leftwing
		<floc> ---- part space location ----
		-2.05
		0.00
		4.00
		<iten> ---- intensity (ii.ff) ----
		700000
		<purp> -- Purpose (NAV|LAND) --
		LAND
		<rdus> -- radius of light bitmap -- 
		1.25
		<clen> -- cone length (ft) 
		150.0
		<cnrm> -- cone rim radius (ft) 
		20.0
		<cnbr> -- cone base radius (ft) 
		0.25
		<ctex> -- cone texture 
		litefuzz.raw
		<ltex> -- light texture 
		headlite.raw
	<endo> ========== END OBJECT ==========
	<lite> -- vehicle light --
	rlit
	tail
	<bgno> ========== BEGIN OBJECT ==========
		<part> ---- associated part name ----
		fuselage
		<floc> ---- part space location ----
		0.
		19.17
		65.87
		<iten> ---- intensity (ii.ff) ----
		300000
		<rdus> -- radius of light bitmap -- 
		0.5
		<purp> -- Purpose (NAV|LAND) --
		BEACON
		<tex1> ---- texture 1 ----
		redlite.raw
		<blnk> ---- on/off times (secs) ----
		0.209991455078125
		0.7899932861328125
	<endo> ========== END OBJECT ==========
	<lite> -- vehicle light --
	spot
	tax1
	<bgno> ========== BEGIN OBJECT ==========
		<part> ---- associated part name ----
		rightwing
		<floc> ---- part space location ----
		2.05
		0.00
		4.00
		<iten> ---- intensity (ii.ff) ----
		100000
		<purp> -- Purpose (NAV|LAND) --
		TAXI
		<rdus> -- radius of light bitmap -- 
		0.5
		<ipit> -- initial pitch (rads)
		0.1046999990940094
		<clen> -- cone length (ft) 
		150.0
		<cnrm> -- cone rim radius (ft) 
		20.0
		<cnbr> -- cone base radius (ft) 
		0.25
		<ctex> -- cone texture 
		litefuzz.raw
		<ltex> -- light texture 
		headlite.raw
	<endo> ========== END OBJECT ==========
	<lite> -- vehicle light --
	spot
	tax2
	<bgno> ========== BEGIN OBJECT ==========
		<part> ---- associated part name ----
		frontwheel
		<floc> ---- part space location ----
		-0.39
		2.49
		1.07
		<iten> ---- intensity (ii.ff) ----
		100000
		<purp> -- Purpose (NAV|LAND) --
		TAXI
		<rdus> -- radius of light bitmap -- 
		0.5
		<ipit> -- initial pitch (rads)
		0.1046999990940094
		<clen> -- cone length (ft) 
		80.
		<cnrm> -- cone rim radius (ft) 
		10.
		<cnbr> -- cone base radius (ft) 
		0.25
		<ctex> -- cone texture 
		litefuzz.raw
		<ltex> -- light texture 
		headlite.raw
	<endo> ========== END OBJECT ==========
	<lite> -- vehicle light --
	spot
	tax3
	<bgno> ========== BEGIN OBJECT ==========
		<part> ---- associated part name ----
		frontwheel
		<floc> ---- part space location ----
		0.32
		2.49
		1.07
		<iten> ---- intensity (ii.ff) ----
		10000
		<purp> -- Purpose (NAV|LAND) --
		TAXI
		<rdus> -- radius of light bitmap -- 
		0.5
		<ipit> -- initial pitch (rads)
		0.1046999990940094
		<clen> -- cone length (ft) 
		80.
		<cnrm> -- cone rim radius (ft) 
		10.
		<cnbr> -- cone base radius (ft) 
		0.25
		<ctex> -- cone texture 
		litefuzz.raw
		<ltex> -- light texture 
		headlite.raw
	<endo> ========== END OBJECT ==========
	<lite> -- vehicle light --
	spot
	tax4
	<bgno> ========== BEGIN OBJECT ==========
		<part> ---- associated part name ----
		leftwing
		<floc> ---- part space location ----
		-2.05
		0.00
		4.00
		<iten> ---- intensity (ii.ff) ----
		100000
		<purp> -- Purpose (NAV|LAND) --
		TAXI
		<rdus> -- radius of light bitmap -- 
		0.7
		<ipit> -- initial pitch (rads)
		0.1046999990940094
		<clen> -- cone length (ft) 
		150
		<cnrm> -- cone rim radius (ft) 
		20
		<cnbr> -- cone base radius (ft) 
		0.25
		<ctex> -- cone texture 
		litefuzz.raw
		<ltex> -- light texture 
		headlite.raw
	<endo> ========== END OBJECT ==========
	<lite> -- vehicle light --
	rlit
	blly
	<bgno> ========== BEGIN OBJECT ==========
		<part> ---- associated part name ----
		fuselage
		<floc> ---- part space location ----
		0.0
		-6.95
		-1.0
		<iten> ---- intensity (ii.ff) ----
		300000
		<rdus> -- radius of light bitmap -- 
		0.5
		<purp> -- Purpose (NAV|LAND) --
		BEACON
		<tex1> ---- texture 1 ----
		redlite.raw
		<blnk> ---- on/off times (secs) ----
		0.209991455078125
		0.7899932861328125
	<endo> ========== END OBJECT ==========
	<lite> -- vehicle light --
	rlit
	lnvl
	<bgno> ========== BEGIN OBJECT ==========
		<part> ---- associated part name ----
		leftwing
		<floc> ---- part space location ----
		-50.88
		1.64
		-24.5
		<iten> ---- intensity (ii.ff) ----
		300000
		<rdus> -- radius of light bitmap -- 
		0.5
		<purp> -- Purpose (NAV|LAND) --
		NAV
		<tex1> ---- texture 1 ----
		redlite.raw
	<endo> ========== END OBJECT ==========
	<lite> -- vehicle light --
	rlit
	lslt
	<bgno> ========== BEGIN OBJECT ==========
		<part> ---- associated part name ----
		leftwing
		<floc> ---- part space location ----
		-50.88
		1.64
		-24.5
		<iten> ---- intensity (ii.ff) ----
		500000
		<rdus> -- radius of light bitmap -- 
		0.5
		<purp> -- Purpose (NAV|LAND) --
		STROBE
		<tex1> ---- texture 1 ----
		whtlite.raw
		<blnk> ---- on/off times (secs) ----
		0.209991455078125
		0.7899932861328125
	<endo> ========== END OBJECT ==========
	<lite> -- vehicle light --
	rlit
	rnvl
	<bgno> ========== BEGIN OBJECT ==========
		<part> ---- associated part name ----
		rightwing
		<floc> ---- part space location ----
		50.88
		1.64
		-24.0
		<iten> ---- intensity (ii.ff) ----
		300000
		<rdus> -- radius of light bitmap -- 
		0.5
		<purp> -- Purpose (NAV|LAND) --
		NAV
		<tex1> ---- texture 1 ----
		grnlite.raw
	<endo> ========== END OBJECT ==========
	<lite> -- vehicle light --
	rlit
	rslt
	<bgno> ========== BEGIN OBJECT ==========
		<part> ---- associated part name ----
		rightwing
		<floc> ---- part space location ----
		50.88
		1.64
		-24.5
		<iten> ---- intensity (ii.ff) ----
		500000
		<rdus> -- radius of light bitmap -- 
		0.5
		<purp> -- Purpose (NAV|LAND) --
		STROBE
		<tex1> ---- texture 1 ----
		whtlite.raw
		<blnk> ---- on/off times (secs) ----
		0.209991455078125
		0.7899932861328125
	<endo> ========== END OBJECT ==========
<endo> ========== END OBJECT ==========

	///////////////////////////////////////////////////
	//
	//	Variable Load Manager
	//
	//	updated by Rene Birot
	//
	///////////////////////////////////////////////////

	<vLdm> - variable Load manager -
	<bgno>
		<unit> - Single Load Entry -
		<bgno>
			<name> - name of Load -
			First Class
			<bPos> - location of load WRT Design CG (fT) -
			0,0,36
			<load> - weight at load location (lbs) -
			1920
			<hiLm> - max weight (lbs) -
			2000
			<uloc> - UI Location
			150
			259
			<ueif> - UI Empty Image Filename
			MD83\efcseatsf.bmp
			<utyp> - UI Type Info
			Passenger
			MD83\pfcseatsf.bmp
		<endo>
		<unit> - Single Load Entry -
		<bgno>
			<name> - name of Load -
			CoachClass 1
			<bPos> - location of load WRT Design CG (fT) -
			0,0,6
			<load> - weight at load location (lbs) -
			6400
			<hiLm> - max weight (lbs) -
			12800
			<uloc> - UI Location
			225
			259
			<ueif> - UI Empty Image Filename
			MD83\eseatsf.bmp
			<utyp> - UI Type Info
			Passenger
			MD83\pseatsf.bmp
		<endo>
		<unit> - Single Load Entry -
		<bgno>
			<name> - name of Load -
			CoachClass 2
			<bPos> - location of load WRT Design CG (fT) -
			0,0,-37
			<load> - weight at load location (lbs) -
			4160
			<hiLm> - max weight (lbs) -
			8320
			<uloc> - UI Location
			475
			259
			<ueif> - UI Empty Image Filename
			MD83\eseatsf.bmp
			<utyp> - UI Type Info
			Passenger
			MD83\pseatsf.bmp
		<endo>
	<endo>
	<udat> - UI Data Image
	MD83\sa-side.bmp
	0
	25
	<udat> - UI Data Image
	MD83\sa-top.bmp
	0
	0
	<uwgt> - UI Weight Image
	MD83\LW-back.bmp
	6
	93
	<uful> - UI Fuel Image
	MD83\LF-Back.bmp
	12
	100

	///////////////////////////////////////////////////
	//
	//	Pitot-Static System
	//
	///////////////////////////////////////////////////

	<psys> -- Pitot-Static System
	<bgno>
		<iceT> -- Icing Condition Duration (sec) --
		60
		<port> -- Pilot Pitot Port Data --
		<bgno>
			<type> -- Port Type --
			PITOT
			<bPos> -- Port Location --
			-3,0,20
			<grup> -- Group Number --
			1
		<endo>
		<port> -- Copilot Pitot Port Data --
		<bgno>
			<type> -- Port Type --
			PITOT
			<bPos> -- Port Location --
			3,0,20
			<grup> -- Group Number --
			2
		<endo>
		<port> -- Pilot Static Port Data --
		<bgno>
			<type> -- Port Type --
			STATIC
			<bPos> -- Port Location --
			-3,0,-15
			<face> -- Fuselage Side --
			LEFT
			<grup> -- Group Number --
			1
			<wont> -- will not ice --
		<endo>
		<port> -- Copilot Static Port Data --
		<bgno>
			<type> -- Port Type --
			STATIC
			<bPos> -- Port Location --
			3,0,-15
			<face> -- Fuselage Side --
			RIGHT
			<grup> -- Group Number --
			2
			<wont> -- will not ice --
		<endo>
		<port> -- Pilot Static Port Data --
		<bgno>
			<type> -- Port Type --
			STATIC
			<bPos> -- Port Location --
			3,0,-15
			<face> -- Fuselage Side --
			RIGHT
			<grup> -- Group Number --
			1
		<endo>
		<port> -- Copilot Static Port Data --
		<bgno>
			<type> -- Port Type --
			STATIC
			<bPos> -- Port Location --
			-3,0,-15
			<face> -- Fuselage Side --
			LEFT
			<grup> -- Group Number --
			2
		<endo>
		<port> -- Port Data --
		<bgno> -- Pilot Alternate Static Port --
			<type> -- Port Type --
			STATIC
			<bPos> -- Port Location --
			0,0,0
			<grup> -- Group Number --
			1
			<inie> -- Interior Port --
			<stat> -- Port Enabled? (1=Yes|0=No) --
			0
		<endo>
	<endo>

	///////////////////////////////////////////////////
	//
	//	AI Autopilot
	//
	///////////////////////////////////////////////////

	<apAI> -- AI --
	<bgno>
		<atop> -- autopilot specification --
		<bgno>
			<fcsf> -- Autopilot File --
			MD83.fcs
		<endo>
	<endo> - AI spec -

	///////////////////////////////////////////////////
	//
	//	Subsystems
	//
	///////////////////////////////////////////////////

	<elec> -- electrical system entry --
	hawk
	<bgno> -- begin Systems --
		<chck> -- Checklists --
		<bgno>
			<file> -- Checklist File Name --
			MD83.ckl
		<endo>
		<subs> - Subsystem entry -
		suct
		<bgno> - Suction Gage -
			<timK>
			1.0
			<pump>
			<bgno>
				<eNum> - engine number -
				1
				<uNum> - unit number -
				1
				<suct> - Suction Pressure (psi) -
				5
			<endo>
			<pump>
			<bgno>
				<eNum> - engine number -
				1
				<uNum> - unit number -
				2
				<suct> - Suction Pressure (psi) -
				5
			<endo>
		<endo>
		<subs> - Subsystem entry -
		pzat
		<bgno> - Pressurization Panel -
			<difP> -- max differential pressure --
			8.55
		<endo>
		<subs> - Subsystem entry -
		elts
		<bgno> - Emergency Locator Transmitter -
			<gLim> -- Activation G Limit --
			1.0
		<endo>
		<subs> - Subsystem entry -
		fire
		<bgno> - Engine Fire System -
			<eNum> -- Engine Number --
			1
		<endo>
		<subs> - Subsystem entry -
		fire
		<bgno> - Engine Fire System -
			<eNum> -- Engine Number --
			2
		<endo>
		<subs> - Subsystem entry -
		fire
		<bgno> - Engine Fire System -
			<eNum> -- Engine Number --
			3
		<endo>
		<subs> - Subsystem Entry -
		anlt
		<bgno> -- Decision Height Annunciator Lt --
			<unId> - Unit Id -
			deh1
			<annr> - depends on annunciator -
			deh1
			<eBus>
			PS1_
			<_AND>
			<fWAV> -- Wave File --
			radaralt.wav
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		annr
		<bgno> -- Decision Height Annunciator --
			<unId> - Unit Id -
			deh1
			<info>
			<bgno> -- begin Announcer Info --
				<anId> -- Unique Id of Announcing System --
				dh__
				<bgno>
					<grou>
					alti
					<user>
					UNIT,1
					<user>
					HARDWARE,GAUGE
				<endo>
			<endo> -- end Announcer Info --
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		anlt
		<bgno> -- Decision Height Annunciator Lt --
			<unId> - Unit Id -
			deh2
			<annr> - depends on annunciator -
			deh2
			<eBus>
			PS2_
			<_AND>
			<fWAV> -- Wave File --
			radaralt.wav
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		annr
		<bgno> -- Decision Height Annunciator --
			<unId> - Unit Id -
			deh2
			<info>
			<bgno> -- begin Announcer Info --
				<anId> -- Unique Id of Announcing System --
				dh__
				<bgno>
					<grou>
					alti
					<user>
					UNIT,2
					<user>
					HARDWARE,GAUGE
				<endo>
			<endo> -- end Announcer Info --
		<endo> -- end annunciator --
		<subs> - Subsystem entry -
		alti
		<bgno> - Standby Altimeter (Pilot) -
			<gNum> -- Port Group Number --
			1
			<uNum> -- unit number --
			1
		<endo>
		<subs> - Subsystem entry -
		vsi_
		<bgno> - Pilot vertical speed -
			<gNum> -- Port Group Number --
			1
			<timK>
			0.5
			<uNum> -- unit number --
			1
		<endo>
		<subs> - Subsystem entry -
		sped
		<bgno> - Standby Airspeed (Pilot) -
			<gNum> -- Port Group Number --
			1
			<uNum> -- unit number --
			1
		<endo>
		<subs> - Subsystem entry -
		atti
		<bgno> - Standby Attitude (Pilot) -
			<timK> - erection time constant -
			0.5
			<prat> - precession rate -
			1440.0
			<uNum> -- unit number --
			1
		<endo>
		<subs> - Subsystem entry -
		alti
		<bgno> - Standby Altimeter (Copilot) -
			<gNum> -- Port Group Number --
			2
			<uNum> -- unit number --
			2
		<endo>
		<subs> - Subsystem entry -
		sped
		<bgno> - Standby Airspeed (Copilot) -
			<gNum> -- Port Group Number --
			2
			<uNum> -- unit number --
			2
		<endo>
		<subs> - Subsystem entry -
		atti
		<bgno> - Standby Attitude (Copilot) -
			<timK> - erection time constant -
			0.5
			<prat> - precession rate -
			1440.0
			<uNum> -- unit number --
			2
		<endo>
		<subs> - Subsystem entry -
		_N1_
		<bgno> - Engine #1 N1 Tachometer -
			<eNum> -- engine number --
			1
			<timK> -- Time Constant --
			1.0
		<endo>
		<subs> - Subsystem entry -
		_N1_
		<bgno> - Engine #2 N1 Tachometer -
			<eNum> -- engine number --
			2
			<timK> -- Time Constant --
			1.0
		<endo>
		<subs> - Subsystem entry -
		_N2_
		<bgno> - Engine #1 N2 Tachometer -
			<eNum> -- engine number --
			1
			<timK> -- Time Constant --
			1.0
		<endo>
		<subs> - Subsystem entry -
		_N2_
		<bgno> - Engine #2 N2 Tachometer -
			<eNum> -- engine number --
			2
			<timK> -- Time Constant --
			1.0
		<endo>
		<subs> - Subsystem entry -
		oilP
		<bgno> - Engine 1 Oil Pressure Gage (OP) -
			<timK>
			1.0
			<eNum> -- Engine Number --
			1
			<eBus> -- Bus Circuit --
			PS1_
			<lowP> -- Low oil pressure (psi) --
			20
		<endo>
		<subs> - Subsystem entry -
		oilP
		<bgno> - Engine 2 Oil Pressure Gage (OP) -
			<timK>
			1.0
			<eNum> -- Engine Number --
			2
			<eBus> -- Bus Circuit --
			PS2_
			<lowP> -- Low oil pressure (psi) --
			20
		<endo>
		<subs> - Subsystem entry -
		oilT
		<bgno> - Engine 1 Oil Temperature Gage (OT) -
			<timK>
			1.0
			<load> - circuit requirement -
			0.39
			<eNum> -- Engine Number --
			1
			<eBus> -- Bus Circuit --
			PS1_
			<degC> -- Display in Celsius --
		<endo>
		<subs> - Subsystem entry -
		oilT
		<bgno> - Engine 2 Oil Temperature Gage (OT) -
			<timK>
			1.0
			<load> - circuit requirement -
			0.39
			<eNum> -- Engine Number --
			2
			<eBus> -- Bus Circuit --
			PS2_
			<degC> -- Display in Celsius --
		<endo>
		<subs> - Subsystem entry -
		eITT
		<bgno> - Engine 1 Inter Turbine Temperature Gage (ITT) -
			<timK>
			1.0
			<eNum> -- Engine Number --
			1
			<degC> -- Display in Celsius --
			<timK> -- Time Constant --
			1.0
		<endo>
		<subs> - Subsystem entry -
		eITT
		<bgno> - Engine 2 Inter Turbine Temperature Gage (ITT) -
			<timK>
			1.0
			<eNum> -- Engine Number --
			2
			<degC> -- Display in Celsius --
			<timK> -- Time Constant --
			1.0
		<endo>
		<subs> - Subsystem entry -
		fgag
		<bgno> - Left Fuel Tank Gage -
			<eNum> - engine number -
			1
			<tNum> - tank number -
			1
			<timK>
			1.0
			<load> - circuit requirement -
			0.39
			<eBus> -- Bus Circuit --
			PS1A
			<lowF> -- Low Fuel (gal) --
			50
		<endo>
		<subs> - Subsystem entry -
		fgag
		<bgno> - Right Fuel Tank Gage -
			<eNum> - engine number -
			2
			<tNum> - tank number -
			1
			<timK>
			1.0
			<load> - circuit requirement -
			0.39
			<eBus> -- Bus Circuit --
			PS2A
			<lowF> -- Low Fuel (gal) --
			50
		<endo>
		<subs> - Subsystem entry -
		thro
		<bgno> - Engine 1 Throttle Control -
			<eNum> -- Engine Number --
			1
		<endo>
		<subs> - Subsystem entry -
		thro
		<bgno> - Engine 2 Throttle Control -
			<eNum> -- Engine Number --
			2
		<endo>
		<subs> - Subsystem entry -
		idle
		<bgno> - Engine 1 HP Cock -
			<eNum>
			1
			<uNum> 
			1
			<Aign> -- Auto Ignition Enabled --
			<Arpm> -- Ignition RPM --
			10
			<rpmO> -- RPM Option (0=RPM, 1=N1, 2=N2) --
			2
			<eBus> -- PE Bus --
			PEbs
		<endo>
		<subs> - Subsystem entry -
		idle
		<bgno> - Engine 2 HP Cock -
			<eNum>
			2
			<uNum>
			2
			<Aign> -- Auto Ignition Enabled --
			<Arpm> -- Ignition RPM --
			10
			<rpmO> -- RPM Option (0=RPM, 1=N1, 2=N2) --
			2
			<eBus> -- PE Bus --
			PEbs
		<endo>
		<subs> - Subsystem entry -
		trev
		<bgno> - Engine 1 Thrust Reverser Control -
			<eNum>
			1
			<dTim> -- Deployment Time (sec) --
			3.0
			<eBus>
			PEbs
		<endo>
		<subs> - Subsystem entry -
		trev
		<bgno> - Engine 2 Thrust Reverser Control -
			<eNum>
			2
			<dTim> -- Deployment Time (sec) --
			3.0
			<eBus>
			PEbs
		<endo>
		<subs> - Subsystem entry -
		flap
		<bgno> - flap control -
			<flpP> - array of positions (deg) -
			9
			0
			5
			10
			15
			20
			25
			30
			40
			60
			<flpS> - array of speeds (kias) -
			9
			0
			250
			250
			250
			200
			200
			200
			180
			180
			<timK>
			10.0
			<load> - circuit load (amps) -
			15
			<dump> -- Dump Index --
			9
			<eBus> - Essential Buss -
			PEbs
		<endo>
		<subs> - Subsystem entry -
		flpg
		<bgno> - flap gauge -
		<endo> 
		<subs> - Subsystem entry -
		abrk
		<bgno> - Air Brake Control -
			<scal> -- Scale --
			60
			<timK> -- Stow Rate --
			1.0
			<mFlp> -- Flap Subsystem --
			<bgno>
				<grou>
				flap
				<user>
				HARDWARE,SWITCH
			<endo>
		<endo>
		<subs> - Subsystem entry -
		rudr
		<bgno> - rudder control -
			<scal>
			15.0
			<step>
			0.05
			<bend>
			0.0
			<timK>
			5.0
		<endo>
		<subs> - Subsystem entry -
		ailr
		<bgno> - aileron control -
			<scal>
			15.0
			<step>
			0.05
			<timK>
			10.0
		<endo>
		<subs> - Subsystem entry -
		elvr
		<bgno> - elevator control -
			<scal>
			15.0
			<step>
			0.025
			<bend>
			0.0
			<timK>
			1.0
		<endo>
		<subs> - Subsystem entry -
		rtrm
		<bgno> - rudder trim control -
			<posn> -- Trim Position -- P0.0140
			0.0
			<scal>
			5.0
			<step>
			0.02
		<endo>
		<subs> - Subsystem entry -
		atrm
		<bgno> - aileron trim control -
			<posn> -- Trim Position -- Q0.03930
			0.0
			<scal>
			5.0
			<step>
			0.02
		<endo>
		<subs> - Subsystem entry -
		etrm
		<bgno> - elevator trim control -
			<scal>
			10.0
			<step>
			0.01
		<endo>
		//
		//	Fuel Control and Indication
		//
		<subs> - Subsystem Entry -
		fsrc
		<bgno> - Left Fuel Cutoff Valve -
			<eNum> - engine number -
			1
		<endo>
		<subs> - Subsystem Entry -
		fsrc
		<bgno> - Right Fuel Cutoff Valve -
			<eNum> - engine number -
			2
		<endo>
		<subs> - Subsystem Entry -
		fflw
		<bgno> - Fuel Flow Gage (Left Engine) -
			<eNum> - engine number -
			1
			<timK>
			1.0
			<_pph> -- Display in Pounds per Hour --
		<endo>
		<subs> - Subsystem Entry -
		fflw
		<bgno> - Fuel Flow Gage (Right Engine) -
			<eNum> - engine number -
			2
			<timK>
			1.0
			<_pph> -- Display in Pounds per Hour --
		<endo>
		<subs> - Subsystem Entry -
		fprs
		<bgno> - Fuel Pressure Gage (Left Engine) -
			<eNum> - engine number -
			1
			<timK>
			1.0
			<loPs> -- Low Pressure (psi) --
			10
		<endo>
		<subs> - Subsystem Entry -
		fprs
		<bgno> - Fuel Pressure Gage (Right Engine) -
			<eNum> - engine number -
			2
			<timK>
			1.0
			<loPs> -- Low Pressure (psi) --
			10
		<endo>
		<subs> - Subsystem Entry -
		fpsw
		<bgno> - Fuel Boost Pump (Left Engine) -
			<unId> - Unit Id -
			sfpL
			<crct> -- activated by circuit --
			<eNum> - engine number -
			1
			<pNum> - pump number -
			1
			<st8t>
			1
			<bool> -- state --
			fpLE
			<bool> -- state --
			fpLO
		<endo>
		<subs> - Subsystem entry -
		swst
		<bgno> - Left Fuel Pump Switch Set -
			<unId> - unit id -
			fpLS
			<dflt> -- Default Switch Position --
			2
			<smsg> -- Message Data (pos 1, Emergency) --
			<bgno>
				<grou>
				fpLE
				<user>
				HARDWARE,STATE
			<endo>
			<smsg> -- Message Data (pos2, Off) --
			<bgno>
				<grou>
				fpLF
				<user>
				HARDWARE,STATE
			<endo>
			<smsg> -- Message Data (pos3, On) --
			<bgno>
				<grou>
				fpLO
				<user>
				HARDWARE,STATE
			<endo>
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Fuel Pump State (Pos 1) -
			<unId> - unit id -
			fpLE
			<hwId> - hardware type -
			STATE
			<eBus> -- Bus Circuit --
			PS1A
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Fuel Pump State (Pos 2) -
			<unId> - unit id -
			fpLF
			<hwId> - hardware type -
			STATE
			<eBus> -- Bus Circuit --
			PS1A
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Fuel Pump State (Pos 3) -
			<unId> - unit id -
			fpLO
			<hwId> - hardware type -
			STATE
			<eBus> -- Bus Circuit --
			PS1A
		<endo>
		<subs> - Subsystem Entry -
		fpsw
		<bgno> - Fuel Boost Pump (Right Engine) -
			<unId> - Unit Id -
			sfpR
			<crct> -- activated by circuit --
			<eNum> - engine number -
			2
			<pNum> - pump number -
			1
			<st8t>
			1
			<bool> -- state --
			fpRE
			<bool> -- state --
			fpRO
		<endo>
		<subs> - Subsystem entry -
		swst
		<bgno> - Right Fuel Pump Switch Set -
			<unId> - unit id -
			fpRS
			<dflt> -- Default Switch Position --
			2
			<smsg> -- Message Data (pos 1, Emergency) --
			<bgno>
				<grou>
				fpRE
				<user>
				HARDWARE,STATE
			<endo>
			<smsg> -- Message Data (pos2, Off) --
			<bgno>
				<grou>
				fpRF
				<user>
				HARDWARE,STATE
			<endo>
			<smsg> -- Message Data (pos3, On) --
			<bgno>
				<grou>
				fpRO
				<user>
				HARDWARE,STATE
			<endo>
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Fuel Pump State (Pos 1) -
			<unId> - unit id -
			fpRE
			<hwId> - hardware type -
			STATE
			<eBus> -- Bus Circuit --
			PS2A
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Fuel Pump State (Pos 2) -
			<unId> - unit id -
			fpRF
			<hwId> - hardware type -
			STATE
			<eBus> -- Bus Circuit --
			PS2A
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Fuel Pump State (Pos 3) -
			<unId> - unit id -
			fpRO
			<hwId> - hardware type -
			STATE
			<eBus> -- Bus Circuit --
			PS2A
		<endo>
		////////////////////////////
		//
		// Fuel Crossfeed Control
		//
		////////////////////////////
		<subs> - Subsystem Entry -
		xfed
		<bgno>
			<posn> -- Crossfeed Switch Position Data --
			<bgno>
				<_id_> -- Position Tag --
				_off
				<st8t> -- Status Report --
				0
				<sact> -- Selection Action data --
				<bgno>
					<uNum> -- Unit Number --
					1
					<st8t> -- Switch State --
					0
				<endo>
				<sact> -- Selection Action data --
				<bgno>
					<uNum> -- Unit Number --
					2
					<st8t> -- Switch State --
					0
				<endo>
			<endo>
			<posn> -- Switch Position Data --
			<bgno>
				<_id_> -- Position Tag --
				_on_
				<st8t> -- Status Report --
				1
				<sact> -- Selection Action data --
				<bgno>
					<uNum> -- Unit Number --
					1
					<st8t> -- Switch State --
					1
				<endo>
				<sact> -- Selection Action data --
				<bgno>
					<uNum> -- Unit Number --
					2
					<st8t> -- Switch State --
					1
				<endo>
			<endo>
		<endo>
		//////////////////////
		//
		//////////////////////
		<subs> - Subsystem entry -
		dpnd
		<bgno> - (do not use) -
			<unId> - unit id -
			ps1_
			<hwId> - hardware type -
			BUS
			<cntr> - Left Generator Contactor -
			Lgen
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - (do not use) -
			<unId> - unit id -
			ps2_
			<hwId> - hardware type -
			BUS
			<cntr> - Right Generator Contactor -
			Rgen
			<cntr> - Right Generator Contactor -
			Agen
		<endo>
		///////////////////////////
		//
		//	APU Indications
		//
		///////////////////////////
		<subs> - Subsystem entry -
		_N1_
		<bgno> - APU Engine N1 Tachometer -
			<eNum> -- engine number --
			3
		<endo>
		<subs> - Subsystem entry -
		eITT
		<bgno> - APU Inter Turbine Temperature Gage (ITT) -
			<timK>
			1.0
			<eNum> -- APU Engine Number --
			3
			<degC> -- Display in Celsius --
		<endo>
		<subs> - Subsystem entry -
		amps
		<bgno> - Load Ammeter -
			<unId> - unit id -
			Aamp
			<lodm> - Load meter -
			<timK>
			5.0
			<mMon> -- Monitored System --
			<bgno>
				<grou>
				Agen
				<user>
				HARDWARE,GENERATOR
			<endo>
		<endo>
		<subs> - Subsystem entry -
		genr
		<bgno> - APU Generator -
			<unId> - unit id -
			Agen
			<eNum> - Engine Number -
			3
			<mxld> - max capacity (amps)
			120
			<loRg> - least RPM regulatable -
			50
			<volt> - voltage -
			28
			<batt> -- Battery (dont ask) --
			:batt
		<endo>
		<subs> - Subsystem entry -
		oilP
		<bgno> - APU Oil Pressure Gage (OP) -
			<eNum> -- Engine Number --
			3
			<lowP> -- Low Oil Pressure Limit --
			20
		<endo>
		///////////////////////////
		//
		//	APU Controls
		//
		///////////////////////////
		<subs> - Subsystem Entry -
		fAPU
		<bgno> - APU Fuel Source -
			<eNum> - apu engine number -
			3
			<mFS_> -- Depends on Left Engine Fuel Source --
			<bgno>
				<grou>
				fsrc
				<user>
				ENGINE,1
			<endo>
			<bool> -- APU Fuel available Logic --
			Afav
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - APU Fuel Available Logic -
			<unId> - unit id -
			Afav
			<hwId> - hardware type -
			STATE
			<swch> - APU Master -
			Amas
			<swch> - Fire Extinguisher
			~Aoff
			<_AND>
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - APU Master Switch -
			<unId> - unit id -
			Amas
			<hwId> - hardware type -
			SWITCH
			<eBus> - Essential Buss -
			PEbs
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - APU Fire Extinguisher Switch -
			<unId> - unit id -
			Aoff
			<hwId> - hardware type -
			SWITCH
		<endo>
		<subs> - Subsystem entry -
		StIg
		<bgno> - APU Starter/Igniter Switch -
			<unId> - unit id -
			Astr
			<eNum> - Engine Number -
			3
			<hwId> - hardware type -
			SWITCH
			<eBus> - Starter Buss -
			strB
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - APU Main Test Switch -
			<unId> - unit id -
			Aman
			<hwId> - hardware type -
			SWITCH
			<eBus> - Essential Buss -
			PEbs
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - APU Lamp Test Switch -
			<unId> - unit id -
			Almp
			<hwId> - hardware type -
			SWITCH
			<eBus> - Essential Buss -
			PEbs
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - APU Fire Test Switch -
			<unId> - unit id -
			Afir
			<hwId> - hardware type -
			SWITCH
			<eBus> - Essential Buss -
			PEbs
			<fWAV> - sfx -
			firebell.wav
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - APU Bleed Air Switch -
			<unId> - unit id -
			Abld
			<hwId> - hardware type -
			SWITCH
			<eBus> -  PS 2 Buss -
			PS2_
		<endo>
		<subs> - Subsystem entry -
		cntr
		<bgno> - APU Generator Contactor -
			<unId> - unit id -
			Agen
			<genr> - Generator -
			Agen
			<clos> - Close Logic Subsystem -
			<bgno>
				<grou>
				AgnC
				<user>
				HARDWARE,STATE
			<endo>
			<open> - Open Logic Subsystem -
			<bgno>
				<grou>
				AgnO
				<user>
				HARDWARE,STATE
			<endo>
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - APU Generator Contactor Logic (Close) -
			<unId> -- Unit Id --
			AgnC
			<hwId>
			STATE
			<genr> -- APU Generator Active --
			Agen
			<bool> -- APU Gen Switch (pos 1, CLOSE)
			Agp1
			<_AND> -- AND Gate Logic --
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - APU Generator Contactor Logic (Open) -
			<unId> -- Unit Id --
			AgnO
			<hwId>
			STATE
			<genr> -- not APU Generator Active --
			~Agen
			<bool> -- APU Gen Switch (pos 3, TRIP)
			Agp3
		<endo>
		<subs> - Subsystem entry -
		swst
		<bgno> - APU Generator Switch Set -
			<unId> - unit id -
			AgSS
			<dflt> -- Default Switch Position --
			2
			<smsg> -- Message Data (pos 1, CLOSE) --
			<bgno>
				<grou>
				Agp1
				<user>
				HARDWARE,STATE
			<endo>
			<smsg> -- Message Data (pos2, no name) --
			<bgno>
				<grou>
				Agp2
				<user>
				HARDWARE,STATE
			<endo>
			<smsg> -- Message Data (pos3, TRIP) --
			<bgno>
				<grou>
				Agp3
				<user>
				HARDWARE,STATE
			<endo>
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - APU Switch State (Pos 1) -
			<unId> - unit id -
			Agp1
			<hwId> - hardware type -
			STATE
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - APU Switch State (Pos 2) -
			<unId> - unit id -
			Agp2
			<hwId> - hardware type -
			STATE
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - APU Switch State (Pos 3) -
			<unId> - unit id -
			Agp3
			<hwId> - hardware type -
			STATE
		<endo>
		///////////////////////////
		//
		//	APU Annunciators
		//
		///////////////////////////
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - APU Fire (red) -
			APUF
			<hwId>
			LIGHT
			<swch> -- APU Lamp Test Switch --
			Afir
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - APU Gen Offline -
			Agnf
			<hwId>
			LIGHT
			<eBus> -- Essential Buss --
			PEbs
			<bool> -- APU Gen Logic --
			Agnf
			<_AND>
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - APU Gen Logic -
			Agnf
			<hwId>
			STATE
			<swch> -- APU Lamp Test Switch --
			Almp
			<cntr> -- APU Gen Contactor --
			~Agen
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - APU Bleed Air Valve Fail -
			Abaf
			<hwId>
			LIGHT
			<eBus> -- Essential Buss --
			PEbs
			<bool> -- APU Bleed Air Valve Fail Logic --
			Abaf
			<_AND>
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - APU Bleed Air Valve Fail Logic -
			Abaf
			<hwId>
			STATE
			<swch> -- APU Lamp Test Switch --
			Almp
			<swch> -- APU Main Test Switch --
			Aman
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - APU Ready To Load -
			Artl
			<hwId>
			LIGHT
			<eBus> -- PE Busbar --
			PEbs
			<bool> -- APU Ready Logic --
			Artl
			<_AND>
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - APU Ready Logic -
			Artl
			<hwId>
			STATE
			<swch> -- APU Lamp Test Switch --
			Almp
			<genr> -- APU Generator Active --
			Agen
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - APU Low Oil Pressure -
			Alop
			<hwId>
			LIGHT
			<eBus> -- PE Busbar --
			PEbs
			<bool> -- APU Low Oil Pressure Logic --
			Alop
			<_AND>
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - APU Low Oil Pressure Logic -
			Alop
			<hwId>
			STATE
			<swch> -- APU Lamp Test Switch --
			Almp
			<annr> -- APU Oil Pressure Ann --
			Alop
		<endo> -- end annunciator --
		<subs> -- Subsystem Entry --
		annr
		<bgno> -- APU Low Oil Pressure annunciator --
			<unId> -- unique id --
			Alop
			<info> -- Announcer Info Entry --
			<bgno> -- begin Announcer Info --
				<anId> -- Unique Annunciator Id --
				loOP
				<bgno> -- Home of Announcing System --
					<grou>
					oilP
					<user>
					UNIT,1
					<user>
					HARDWARE,GAUGE
					<user>
					ENGINE,3
				<endo>
			<endo> -- end Announcer Info --
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - APU High Oil Temperature -
			Ahot
			<hwId>
			LIGHT
			<swch> -- APU Lamp Test Switch --
			Almp
		<endo> -- end annunciator --
		<subs> - Subsystem entry -
		dpnd
		<bgno> - APU Bleed Air On -
			<unId> - unit id -
			Abld
			<hwId> - hardware type -
			LIGHT
			<swch> - Bleed Air Switch -
			Abld
			<swch> -- APU Lamp Test Switch --
			Almp
		<endo>
		//
		//
		//
		<subs> - Subsystem entry -
		gear
		<bgno> - Gear Control -
			<fuse> -- Hydraulic Pump Fuse --
			hydp
			<hydr> -- Hydraulically Actuated --
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Hydraulic Pump Fuse -
			<unId> - unit id -
			hydp
			<hwId> - hardware type -
			FUSE
		<endo>
		<subs> - Subsystem Entry -
		grwn
		<bgno> - Gear Warning -
			<eBus> -- Bus Circuit --
			PS1_
			<_tla> -- Throttle Lever Limit --
			0.27
			<flap> -- Flap Angle Limit (deg) --
			15
			<_ias> -- Indicated Airspeed Limit (kias) --
			150
			<_odd> -- Gear Position and Lever Agreement --
			<fWAV> -- sound fx --
			gearwarn.wav
		<endo>
		<subs> - Subsystem entry -
		brak
		<bgno> - Brake Control -
		<endo>
		//////////////////////////////////////////////////////
		//
		//	Fuel Switches
		//
		//////////////////////////////////////////////////////
		<subs> - Subsystem entry -
		swst
		<bgno> - Left Engine Computer Switch Set -
			<unId> - unit id -
			ecLS
			<dflt> -- Default Switch Position --
			2
			<smsg> -- Message Data (pos 1, Overspeed) --
			<bgno>
				<grou>
				ecLO
				<user>
				HARDWARE,STATE
			<endo>
			<smsg> -- Message Data (pos2, Off) --
			<bgno>
				<grou>
				ecLF
				<user>
				HARDWARE,STATE
			<endo>
			<smsg> -- Message Data (pos3, Auto) --
			<bgno>
				<grou>
				ecLA
				<user>
				HARDWARE,STATE
			<endo>
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Left Engine Computer State (Pos 1) -
			<unId> - unit id -
			ecLO
			<hwId> - hardware type -
			STATE
			<eBus> -- Bus Circuit --
			PS1A
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Left Engine Computer State (Pos 2) -
			<unId> - unit id -
			ecLF
			<hwId> - hardware type -
			STATE
			<eBus> -- Bus Circuit --
			PS1A
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Left Engine Computer State (Pos 3) -
			<unId> - unit id -
			ecLA
			<hwId> - hardware type -
			STATE
			<eBus> -- Bus Circuit --
			PS1A
		<endo>
		<subs> - Subsystem entry -
		swst
		<bgno> - Right Engine Computer Switch Set -
			<unId> - unit id -
			ecRS
			<dflt> -- Default Switch Position --
			2
			<smsg> -- Message Data (pos 1, Overspeed) --
			<bgno>
				<grou>
				ecRO
				<user>
				HARDWARE,STATE
			<endo>
			<smsg> -- Message Data (pos2, Off) --
			<bgno>
				<grou>
				ecRF
				<user>
				HARDWARE,STATE
			<endo>
			<smsg> -- Message Data (pos3, Auto) --
			<bgno>
				<grou>
				ecRA
				<user>
				HARDWARE,STATE
			<endo>
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Right Engine Computer State (Pos 1) -
			<unId> - unit id -
			ecRO
			<hwId> - hardware type -
			STATE
			<eBus> -- Bus Circuit --
			PS2A
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Right Engine Computer State (Pos 2) -
			<unId> - unit id -
			ecRF
			<hwId> - hardware type -
			STATE
			<eBus> -- Bus Circuit --
			PS2A
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Right Engine Computer State (Pos 3) -
			<unId> - unit id -
			ecRA
			<hwId> - hardware type -
			STATE
			<eBus> -- Bus Circuit --
			PS2A
		<endo>
		<subs> - Subsystem entry -
		swst
		<bgno> - Engine Sync Switch Set -
			<unId> - unit id -
			esSW
			<dflt> -- Default Switch Position --
			1
			<smsg> -- Message Data (pos 1, Off) --
			<bgno>
				<grou>
				esOF
				<user>
				HARDWARE,STATE
			<endo>
			<smsg> -- Message Data (pos2, N2) --
			<bgno>
				<grou>
				esN2
				<user>
				HARDWARE,STATE
			<endo>
			<smsg> -- Message Data (pos3, N1) --
			<bgno>
				<grou>
				esN1
				<user>
				HARDWARE,STATE
			<endo>
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Engine Sync State (Pos 1) -
			<unId> - unit id -
			esOF
			<hwId> - hardware type -
			STATE
			<eBus> -- Bus Circuit --
			PS1A
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Engine Sync State (Pos 2) -
			<unId> - unit id -
			esN2
			<hwId> - hardware type -
			STATE
			<eBus> -- Bus Circuit --
			PS1A
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Engine Sync State (Pos 3) -
			<unId> - unit id -
			esN1
			<hwId> - hardware type -
			STATE
			<eBus> -- Bus Circuit --
			PS1A
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Cabin Flood -
			<unId> - unit id -
			cbFl
			<hwId> - hardware type -
			SWITCH
			<eBus> -- Bus Circuit --
			PS2_
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Cabin Fan -
			<unId> - unit id -
			cbFn
			<hwId> - hardware type -
			SWITCH
			<eBus> -- Bus Circuit --
			PS2_
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Pressure Override -
			<unId> - unit id -
			prOv
			<hwId> - hardware type -
			SWITCH
			<eBus> -- Bus Circuit --
			PEbs
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Pressure Override -
			<unId> - unit id -
			fdkV
			<hwId> - hardware type -
			SWITCH
			<eBus> -- Bus Circuit --
			PEbs
		<endo>
		<subs> - Subsystem entry -
		swst
		<bgno> - Main Air Valve L Switch Set -
			<unId> - unit id -
			mavL
			<dflt> -- Default Switch Position --
			1
			<smsg> -- Message Data (pos 1, Close) --
			<bgno>
				<grou>
				mvl1
				<user>
				HARDWARE,STATE
			<endo>
			<smsg> -- Message Data (pos2, LP On) --
			<bgno>
				<grou>
				mvl2
				<user>
				HARDWARE,STATE
			<endo>
			<smsg> -- Message Data (pos3, Open) --
			<bgno>
				<grou>
				mvl3
				<user>
				HARDWARE,STATE
			<endo>
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Main Air Valve L State (Pos 1) -
			<unId> - unit id -
			mvl1
			<hwId> - hardware type -
			STATE
			<eBus> -- Bus Circuit --
			PEbs
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Main Air Valve L State (Pos 2) -
			<unId> - unit id -
			mvl2
			<hwId> - hardware type -
			STATE
			<eBus> -- Bus Circuit --
			PEbs
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Main Air Valve L State (Pos 3) -
			<unId> - unit id -
			mvl3
			<hwId> - hardware type -
			STATE
			<eBus> -- Bus Circuit --
			PEbs
		<endo>
		<subs> - Subsystem entry -
		swst
		<bgno> - Main Air Valve R Switch Set -
			<unId> - unit id -
			mavR
			<dflt> -- Default Switch Position --
			1
			<smsg> -- Message Data (pos 1, Close) --
			<bgno>
				<grou>
				mvr1
				<user>
				HARDWARE,STATE
			<endo>
			<smsg> -- Message Data (pos2, LP On) --
			<bgno>
				<grou>
				mvr2
				<user>
				HARDWARE,STATE
			<endo>
			<smsg> -- Message Data (pos3, Open) --
			<bgno>
				<grou>
				mvr3
				<user>
				HARDWARE,STATE
			<endo>
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Main Air Valve R State (Pos 1) -
			<unId> - unit id -
			mvr1
			<hwId> - hardware type -
			STATE
			<eBus> -- Bus Circuit --
			PEbs
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Main Air Valve R State (Pos 2) -
			<unId> - unit id -
			mvr2
			<hwId> - hardware type -
			STATE
			<eBus> -- Bus Circuit --
			PEbs
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Main Air Valve R State (Pos 3) -
			<unId> - unit id -
			mvr3
			<hwId> - hardware type -
			STATE
			<eBus> -- Bus Circuit --
			PEbs
		<endo>
		//////////////////////////////////////////////////////
		//
		//	AC Bus Switch Set
		//
		//////////////////////////////////////////////////////
		<subs> - Subsystem entry -
		inds
		<bgno> - AC Bus Switch Set -
			<unId> - unit id -
			acSS
			<dflt> -- Default Switch Position --
			2
			<timK> -- Indication Lag --
			3.0
			<smsg> -- Message Data (pos 1, XS1) --
			<bgno>
				<grou>
				acX1
				<user>
				HARDWARE,GAUGE
			<endo>
			<smsg> -- Message Data (pos2, XE) --
			<bgno>
				<grou>
				acXE
				<user>
				HARDWARE,GAUGE
			<endo>
			<smsg> -- Message Data (pos3, XS2) --
			<bgno>
				<grou>
				acX2
				<user>
				HARDWARE,GAUGE
			<endo>
		<endo>
		<subs> - Subsystem entry -
		volt
		<bgno> - AC Bus Switch Set (Pos 1) -
			<unId> - unit id -
			acX1
			<mMon> -- Monitored System --
			<bgno>
				<grou>
				XS1_
				<user>
				HARDWARE,BUS
			<endo>
		<endo>
		<subs> - Subsystem entry -
		volt
		<bgno> - AC Bus Switch Set (Pos 2) -
			<unId> - unit id -
			acXE
			<mMon> -- Monitored System --
			<bgno>
				<grou>
				XEbs
				<user>
				HARDWARE,BUS
			<endo>
		<endo>
		<subs> - Subsystem entry -
		volt
		<bgno> - AC Bus Switch Set (Pos 3) -
			<unId> - unit id -
			acX2
			<mMon> -- Monitored System --
			<bgno>
				<grou>
				XS2_
				<user>
				HARDWARE,BUS
			<endo>
		<endo>
		//////////////////////////////////////////////////////
		//
		//	Exterior Lighting
		//
		//////////////////////////////////////////////////////
		<subs> - Subsystem entry -
		swst
		<bgno> - Keyboard Landing Light Switch -
			<unId> 
			LAND
			<smsg> -- Message Data --
			<bgno>
				<grou>
				lll3
				<user>
				HARDWARE,SWITCH
			<endo>
			<smsg> -- Message Data --
			<bgno>
				<grou>
				rll3
				<user>
				HARDWARE,SWITCH
			<endo>
			<LAND> -- Handled by LAND Key --
			<sync> -- sync all switches --
		<endo>
		<subs> - Subsystem entry -
		swst
		<bgno> - Keyboard Nav Light Switch -
			<unId> 
			NAVI
			<smsg> -- Message Data --
			<bgno>
				<grou>
				navi
				<user>
				HARDWARE,SWITCH
			<endo>
			<smsg> -- Message Data --
			<bgno>
				<grou>
				becn
				<user>
				HARDWARE,SWITCH
			<endo>
			<smsg> -- Message Data --
			<bgno>
				<grou>
				strb
				<user>
				HARDWARE,SWITCH
			<endo>
			<NAVI> -- Handled by NAVI Key --
			<sync> -- sync all switches --
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Light Switch -
			<unId> - Unique Id (Left Landing Light Switch)-
			lll3
			<hwId>
			SWITCH
			<fuse> - circuit dependency (fuse) -
			llnd
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Light Switch -
			<unId> - Unique Id (Left Land/Taxi Light Neutral)-
			lll2
			<hwId>
			SWITCH
			<fuse> - circuit dependency (fuse) -
			taxi
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Light Switch -
			<unId> - Unique Id (Left Taxi Light Switch)-
			lll1
			<hwId>
			SWITCH
			<fuse> - circuit dependency (fuse) -
			taxi
		<endo>
		<subs> - Subsystem entry -
		swst
		<bgno> - Left Landing Light Switch Set -
			<unId> - unit id -
			llnd
			<dflt> -- Default Switch Position --
			1
			<smsg> -- Message Data (pos1, OFF) --
			<bgno>
				<grou>
				lll1
				<user>
				HARDWARE,SWITCH
			<endo>
			<smsg> -- Message Data (pos 2, TAXI) --
			<bgno>
				<grou>
				lll2
				<user>
				HARDWARE,SWITCH
			<endo>
			<smsg> -- Message Data (pos3, LANDING) --
			<bgno>
				<grou>
				lll3
				<user>
				HARDWARE,SWITCH
			<endo>
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Light Switch -
			<unId> - Unique Id (Right Landing Light Switch)-
			rll3
			<hwId>
			SWITCH
			<fuse> - circuit dependency (fuse) -
			rlnd
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Light Switch -
			<unId> - Unique Id (Right Taxi Light Neutral)-
			rll2
			<hwId>
			SWITCH
			<fuse> - circuit dependency (fuse) -
			taxi
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Light Switch -
			<unId> - Unique Id (Right Taxi Light Switch)-
			rll1
			<hwId>
			SWITCH
			<fuse> - circuit dependency (fuse) -
			taxi
		<endo>
		<subs> - Subsystem entry -
		swst
		<bgno> - Right Landing Light Switch Set -
			<unId> - unit id -
			rlnd
			<dflt> -- Default Switch Position --
			1
			<smsg> -- Message Data (pos 1, OFF) --
			<bgno>
				<grou>
				rll1
				<user>
				HARDWARE,SWITCH
			<endo>
			<smsg> -- Message Data (pos2, TAXI) --
			<bgno>
				<grou>
				rll2
				<user>
				HARDWARE,SWITCH
			<endo>
			<smsg> -- Message Data (pos3, LANDING) --
			<bgno>
				<grou>
				rll3
				<user>
				HARDWARE,SWITCH
			<endo>
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Light Switch -
			<unId> - Unique Id (Navigation Light Switch)-
			navi
			<hwId>
			SWITCH
			<fuse> - circuit dependency (fuse) -
			navi
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Light Switch -
			<unId> - Unique Id (Beacon Light Switch)-
			becn
			<hwId>
			SWITCH
			<fuse> - circuit dependency (fuse) -
			becn
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Light Switch -
			<unId> - Unique Id (Strobe Light Switch)-
			strb
			<hwId>
			SWITCH
			<fuse> - circuit dependency (fuse) -
			strb
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Light Switch -
			<unId> - Unique Id (Ice Light Switch)-
			ils3
			<hwId>
			SWITCH
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Light Switch -
			<unId> - Unique Id (Ice/Logo Light Off Switch)-
			ils2
			<hwId>
			SWITCH
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Light Switch -
			<unId> - Unique Id (Logo Light Switch)-
			ils1
			<hwId>
			SWITCH
		<endo>
		<subs> - Subsystem entry -
		swst
		<bgno> - Ice/Logo Light Switch Set -
			<unId> - unit id -
			ilsw
			<dflt> -- Default Switch Position --
			2
			<smsg> -- Message Data (pos 1, LOGO) --
			<bgno>
				<grou>
				ils1
				<user>
				HARDWARE,SWITCH
			<endo>
			<smsg> -- Message Data (pos2, OFF) --
			<bgno>
				<grou>
				ils2
				<user>
				HARDWARE,SWITCH
			<endo>
			<smsg> -- Message Data (pos3, ICE) --
			<bgno>
				<grou>
				ils3
				<user>
				HARDWARE,SWITCH
			<endo>
		<endo>
		<subs> - Subsystem entry -
		bulb
		<bgno> - Light Bulb -
			<LMid> - right nav light -
			rnvl
			<swch> - circuit dependency (switch) -
			navi
			<load> - circuit load (amps) -
			1.85
		<endo>
		<subs> - Subsystem entry -
		bulb
		<bgno> - Light Bulb -
			<LMid> -  left nav light -
			lnvl
			<swch> - circuit dependency (switch) -
			navi
			<load> - circuit load (amps) -
			1.85
		<endo>
		<subs> - Subsystem entry -
		bulb
		<bgno> - left strobe light -
			<LMid> - Light Manager Bulb Id -
			lslt
			<swch> - circuit dependency (switch) -
			strb
			<load> - circuit load (amps) -
			2.6
		<endo>
		<subs> - Subsystem entry -
		bulb
		<bgno> - Right strobe light -
			<LMid> - Light Manager Bulb Id -
			rslt
			<swch> - circuit dependency (switch) -
			strb
			<load> - circuit load (amps) -
			2.6
		<endo>
		<subs> - Subsystem entry -
		bulb
		<bgno> - Landing light 1 -
			<LMid> - right wing landing light -
			lnd1
			<swch> - circuit dependency (switch) -
			rll3
			<load> - circuit load (amps) -
			8.9
		<endo>
		<subs> - Subsystem entry -
		bulb
		<bgno> - taxi light 1-
			<LMid> - right wing taxi light -
			tax1
			<swch> - circuit dependency (switch) -
			rll2
			<load> - circuit load (amps) -
			8.9
		<endo>
		<subs> - Subsystem entry -
		bulb
		<bgno> - taxi light 2 -
			<LMid> - right nose taxi light -
			tax2
			<swch> - circuit dependency (switch) -
			rll2
			<load> - circuit load (amps) -
			8.9
		<endo>
		<subs> - Subsystem entry -
		bulb
		<bgno> - taxi light 3 -
			<LMid> - left nose taxi light -
			tax3
			<swch> - circuit dependency (switch) -
			lll2
			<load> - circuit load (amps) -
			8.9
		<endo>
		<subs> - Subsystem entry -
		bulb
		<bgno> - taxi light 4 -
			<LMid> - left wing taxi light -
			tax4
			<swch> - circuit dependency (switch) -
			lll2
			<load> - circuit load (amps) -
			8.9
		<endo>
		<subs> - Subsystem entry -
		bulb
		<bgno> - land light 2 -
			<LMid> - landing light -
			lnd2
			<swch> - circuit dependency (switch) -
			lll3
			<load> - circuit load (amps) -
			8.9
		<endo>
		<subs> - Subsystem entry -
		bulb
		<bgno> - tail light -
			<LMid> - landing light -
			tail
			<swch> - circuit dependency (switch) -
			becn
			<load> - circuit load (amps) -
			1.85
		<endo>
		<subs> - Subsystem entry -
		bulb
		<bgno> - belly light -
			<LMid> - landing light -
			blly
			<swch> - circuit dependency (switch) -
			becn
			<load> - circuit load (amps) -
			1.85
		<endo>
		<subs> - Subsystem entry -
		bulb
		<bgno> - ice light -
			<LMid> - landing light -
			ice_
			<swch> - circuit dependency (switch) -
			ils1
			<load> - circuit load (amps) -
			0.5
		<endo>
		<subs> - Subsystem entry -
		bulb
		<bgno> - ice light -
			<LMid> - landing light -
			ice1_
			<swch> - circuit dependency (switch) -
			ils1
			<load> - circuit load (amps) -
			0.5
		<endo>

		<subs> - Subsystem entry -
		dpnd
		<bgno> - Nav Lt Circuit Breaker -
			<unId> - unit id -
			navi
			<hwId> - hardware type -
			FUSE
			<eBus> -- Bus Circuit --
			PS2_
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Strobe Lt Circuit Breaker -
			<unId> - unit id -
			strb
			<hwId> - hardware type -
			FUSE
			<eBus> -- Bus Circuit --
			PS1_
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Beacon Lt Circuit Breaker -
			<unId> - unit id -
			becn
			<hwId> - hardware type -
			FUSE
			<eBus> -- Bus Circuit --
			PS1_
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Left Landing Lt Circuit Breaker -
			<unId> - unit id -
			llnd
			<hwId> - hardware type -
			FUSE
			<eBus> -- Bus Circuit --
			PS1_
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Right Landing Lt Circuit Breaker -
			<unId> - unit id -
			rlnd
			<hwId> - hardware type -
			FUSE
			<eBus> -- Bus Circuit --
			PS2_
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Taxi Lt Circuit Breaker -
			<unId> - unit id -
			taxi
			<hwId> - hardware type -
			FUSE
			<eBus> -- Bus Circuit --
			PS2_
		<endo>
		//////////////////////////////////////
		//
		//	Pitot Heat Switches
		//
		//////////////////////////////////////
		<subs>
		phsw
		<bgno> - Pilot Pitot Heat Switch -
			<unId> - ID -
			iphl
			<aray> - Port Number Array -
			1
			1
			<load> - circuit load (amps)
			7.10
			<eBus> -- Bus Circuit --
			PS1_
		<endo>
		<subs> - Subsystem entry -
		amps
		<bgno> - Left Pitot Ammeter -
			<unId> - unit id -
			Lpam
			<lodm> - Load meter -
			<timK>
			5.0
			<mMon> -- Monitored System --
			<bgno>
				<grou>
				iphl
				<user>
				HARDWARE,SWITCH
			<endo>
		<endo>
		<subs>
		phsw
		<bgno> - Copilot Pitot Heat Switch -
			<unId> - ID -
			iphr
			<aray> - Port Number Array -
			1
			2
			<load> - circuit load (amps)
			7.10
			<eBus> -- Bus Circuit --
			PS2_
		<endo>
		<subs> - Subsystem entry -
		amps
		<bgno> - Right Pitot Ammeter -
			<unId> - unit id -
			Rpam
			<lodm> - Load meter -
			<timK>
			5.0
			<mMon> -- Monitored System --
			<bgno>
				<grou>
				iphr
				<user>
				HARDWARE,SWITCH
			<endo>
		<endo>
		<subs> - Subsystem entry -
		inds
		<bgno> - Pitot Amps Indicator Set -
			<unId> - unit id -
			paIS
			<eBus> -- Bus Circuit --
			PEbs
			<andx> -- Default Switch Position --
			1
			<timK>
			3.0
			<smsg> -- Left Pitot Ammeter --
			<bgno>
				<grou>
				Lpam
				<user>
				HARDWARE,GAUGE
			<endo>
			<smsg> -- Right Pitot Ammeter --
			<bgno>
				<grou>
				Rpam
				<user>
				HARDWARE,GAUGE
			<endo>
		<endo>
		//////////////////////////////////////
		//
		//	Ice Protection Switches
		//
		//////////////////////////////////////
		<subs>
		dpnd
		<bgno> - Ice Detection Switch -
			<unId>
			idet
			<hwId>
			SWITCH
		<endo>
		<subs>
		dpnd
		<bgno> - Screen Heat Left Switch -
			<unId>
			ishl
			<hwId>
			SWITCH
		<endo>
		<subs>
		dpnd
		<bgno> - Screen Heat Right Switch -
			<unId>
			ishr
			<hwId>
			SWITCH
		<endo>
		<subs>
		dpnd
		<bgno> - Eng AntiIce L Switch -
			<unId>
			ieal
			<hwId>
			SWITCH
			<eBus>
			PEbs
		<endo>
		<subs>
		dpnd
		<bgno> - Eng AntiIce R Switch -
			<unId>
			iear
			<hwId>
			SWITCH
			<eBus>
			PEbs
		<endo>
		<subs>
		dpnd
		<bgno> - Eng Ignition L Switch -
			<unId>
			ieil
			<hwId>
			SWITCH
			<eBus>
			PEbs
		<endo>
		<subs>
		dpnd
		<bgno> - Eng Ignition R Switch -
			<unId>
			ieir
			<hwId>
			SWITCH
			<eBus>
			PEbs
		<endo>
		////////////////////////////////////////////////////////
		//
		//	Interior Lighting
		//
		////////////////////////////////////////////////////////
		<subs>
		dpnd
		<bgno> - Master Light Switch -
			<unId>
			mlsw
			<hwId>
			SWITCH
			<eBus>
			PEbs
		<endo>
		<subs>
		lsst
		<bgno> - Pilot Pad Lights -
			<unId>
			plpd
			<stat> - light ON -
			<levl>
			0.5
			<swch>
			mlsw
		<endo>
		<subs>
		lsst
		<bgno> - Pilot Panel Lights -
			<unId>
			plpn
			<stat> - light ON -
			<levl>
			0.5
			<swch>
			mlsw
		<endo>
		<subs>
		lsst
		<bgno> - Pilot Mode Lights -
			<unId>
			plmd
			<stat> - light ON -
			<swch>
			mlsw
		<endo>
		<subs>
		lsst
		<bgno> - Pilot Alt Lights -
			<unId>
			plal
			<stat> - light ON -
			<swch>
			mlsw
		<endo>
		<subs>
		lsst
		<bgno> - Pilot Flt Lights -
			<unId>
			plfl
			<stat> - light ON -
			<swch>
			mlsw
		<endo>
		<subs>
		lsst
		<bgno> - Pilot EFD Lights -
			<unId>
			plef
			<stat> - light ON -
		<endo>
		<subs>
		lsst
		<bgno> - Center Panel Lights -
			<unId>
			plcp
			<stat> - light ON -
			<swch>
			mlsw
		<endo>
		<subs>
		lsst
		<bgno> - Pilot Flood Lights -
			<unId>
			plfd
			<stat> - light ON -
			<swch>
			mlsw
		<endo>
		<subs>
		lsst
		<bgno> - Copilot Pad Lights -
			<unId>
			clpd
			<stat> - light ON -
			<levl>
			0.5
			<swch>
			mlsw
		<endo>
		<subs>
		lsst
		<bgno> - Copilot Panel Lights -
			<unId>
			clpn
			<stat> - light ON -
			<levl>
			0.5
			<swch>
			mlsw
		<endo>
		<subs>
		lsst
		<bgno> - Copilot Mode Lights -
			<unId>
			clmd
			<stat> - light ON -
			<swch>
			mlsw
		<endo>
		<subs>
		lsst
		<bgno> - Copilot Alt Lights -
			<unId>
			clal
			<stat> - light ON -
			<swch>
			mlsw
		<endo>
		<subs>
		lsst
		<bgno> - Copilot Flt Lights -
			<unId>
			clfl
			<stat> - light ON -
			<swch>
			mlsw
		<endo>
		<subs>
		lsst
		<bgno> - Copilot EFD Lights -
			<unId>
			clef
			<stat> - light ON -
		<endo>
		<subs>
		lsst
		<bgno> - Copilot Flood Lights -
			<unId>
			clfd
			<stat> - light ON -
			<swch>
			mlsw
		<endo>
		<subs>
		lsst
		<bgno> - Avionics Lights (Upper) -
			<unId>
			alup
			<stat> - light ON -
			<swch>
			mlsw
		<endo>
		<subs>
		lsst
		<bgno> - Avionics Lights (Lower) -
			<unId>
			allw
			<stat> - light ON -
			<swch>
			mlsw
		<endo>
		<subs>
		lsst
		<bgno> - Avionics Digits -
			<unId>
			aldg
			<stat> - light ON -
			<swch>
			mlsw
		<endo>
		<subs>
		lsst
		<bgno> - Overhead instrument -
			<unId>
			olig
			<stat> - light ON -
			<swch>
			mlsw
		<endo>
		<subs>
		lsst
		<bgno> - Overhead panel -
			<unId>
			olpn
			<stat> - light ON -
			<levl>
			0.5
			<swch>
			mlsw
		<endo>
		<subs>
		lsst
		<bgno> - Fixed annunciator lights -
			<unId>
			anlt
			<stat> - light ON -
			<eBus>
			PEbs
		<endo>
		<subs>
		lsst
		<bgno> - Cabin + Lav lights -
			<unId>
			cllt
			<levl>
			0.85
			<eBus>
			PEbs
		<endo>
		////////////////////////////////////////////////////////
		//
		//	Engine Starters
		//
		////////////////////////////////////////////////////////
		<subs> - Subsystem entry -
		strt
		<bgno> - Engine 1 Starter Switch -
			<unId> - unit id -
			Lstr
			<eNum> - Engine Number -
			1
			<hwId> - hardware type -
			SWITCH
			<eBus> - Starter Buss -
			strB
		<endo>
		<subs> - Subsystem entry -
		strt
		<bgno> - Engine 2 Starter Switch -
			<unId> - unit id -
			Rstr
			<eNum> - Engine Number -
			2
			<hwId> - hardware type -
			SWITCH
			<eBus> - Starter Buss -
			strB
		<endo>
		///////////////////////////////////////////////
		//
		//	Electrical System Meters
		//
		///////////////////////////////////////////////

		<subs> - Subsystem entry -
		swst
		<bgno> - DC Ammeter Mode Switch Set ( 1 switch sets 2 indicator sets) -
			<unId> - unit id -
			AmSS
			<dflt> -- Default Switch Position --
			0
			<zero> -- Zero Based Index --
			<sync> -- switch all simultaneously --
			<smsg> -- Message Data (Left DC Ammeter) --
			<bgno>
				<grou>
				LgAm
				<user>
				HARDWARE,GAUGE
				<user>
				DATATAG,'indx'
			<endo>
			<smsg> -- Message Data (Right DC Ammeter) --
			<bgno>
				<grou>
				RgAm
				<user>
				HARDWARE,GAUGE
				<user>
				DATATAG,'indx'
			<endo>
		<endo>
		<subs> - Subsystem entry -
		inds
		<bgno> - Left Generator Ammeter Indicator Set -
			<unId> - unit id -
			LgAm
			<dflt> -- Default Switch Position --
			0
			<zero> -- Zero Based Index --
			<timK> -- Indication Lag --
			2.0
			<smsg> -- Message Data (pos 1, Load) --
			<bgno>
				<grou>
				Lamp
				<user>
				HARDWARE,GAUGE
			<endo>
			<smsg> -- Message Data (pos2, Charge) --
			<bgno>
				<grou>
				Lcrg
				<user>
				HARDWARE,GAUGE
			<endo>
		<endo>
		<subs> - Subsystem entry -
		amps
		<bgno> - Left Generator Load Ammeter -
			<unId> - unit id -
			Lamp
			<lodm> - Load meter -
			<timK>
			5.0
			<mMon> -- Monitored System --
			<bgno>
				<grou>
				Lgen
				<user>
				HARDWARE,GENERATOR
			<endo>
		<endo>
		<subs> - Subsystem entry -
		amps
		<bgno> - Left Generator Charge Ammeter -
			<unId> - unit id -
			Lcrg
			<chrg> - Charge meter -
			<timK>
			5.0
			<mMon> -- Monitored System --
			<bgno>
				<grou>
				batt
				<user>
				HARDWARE,BATTERY
			<endo>
		<endo>

		<subs> - Subsystem entry -
		inds
		<bgno> - Right Generator Ammeter Indicator Set -
			<unId> - unit id -
			RgAm
			<dflt> -- Default Switch Position --
			0
			<zero> -- Zero Based Index --
			<timK> -- Indication Lag --
			2.0
			<smsg> -- Message Data (pos 1, Load) --
			<bgno>
				<grou>
				Ramp
				<user>
				HARDWARE,GAUGE
			<endo>
			<smsg> -- Message Data (pos2, Charge) --
			<bgno>
				<grou>
				Rcrg
				<user>
				HARDWARE,GAUGE
			<endo>
		<endo>
		<subs> - Subsystem entry -
		amps
		<bgno> - Ammeter -
			<unId> - unit id -
			Ramp
			<lodm> - Load meter -
			<timK>
			5.0
			<mMon> -- Monitored System --
			<bgno>
				<grou>
				Rgen
				<user>
				HARDWARE,GENERATOR
			<endo>
		<endo>
		<subs> - Subsystem entry -
		amps
		<bgno> - Ammeter -
			<unId> - unit id -
			Rcrg
			<chrg> - Charge meter -
			<timK>
			5.0
			<mMon> -- Monitored System --
			<bgno>
				<grou>
				batt
				<user>
				HARDWARE,BATTERY
			<endo>
		<endo>

		<subs> - Subsystem entry -
		inds
		<bgno> - Voltmeter Indicator Set -
			<unId> - unit id -
			Volt
			<dflt> -- Default Switch Position --
			3
			<timK> -- indication lag tc --
			1.0
			<smsg> -- Message Data (B1 Bus Volts) --
			<bgno>
				<grou>
				B1_V
				<user>
				HARDWARE,GAUGE
			<endo>
			<smsg> -- Message Data (PS1 Bus Volts) --
			<bgno>
				<grou>
				PS1V
				<user>
				HARDWARE,GAUGE
			<endo>
			<smsg> -- Message Data (PE Bus Volts) --
			<bgno>
				<grou>
				PE_V
				<user>
				HARDWARE,GAUGE
			<endo>
			<smsg> -- Message Data (PS2 Bus Volts) --
			<bgno>
				<grou>
				PS2V
				<user>
				HARDWARE,GAUGE
			<endo>
			<smsg> -- Message Data (B2 Bus Volts) --
			<bgno>
				<grou>
				B2_V
				<user>
				HARDWARE,GAUGE
			<endo>
		<endo>
		<subs> - Subsystem entry -
		volt
		<bgno> - PE Bus Voltmeter -
			<unId> - unit id -
			PE_V
			<timK>
			5.0
			<mMon> -- Monitored System --
			<bgno>
				<grou>
				PEbs
				<user>
				HARDWARE,BUS
			<endo>
		<endo>
		<subs> - Subsystem entry -
		volt
		<bgno> - PS2 Bus Voltmeter -
			<unId> - unit id -
			PS2V
			<timK>
			5.0
			<mMon> -- Monitored System --
			<bgno>
				<grou>
				PS2_
				<user>
				HARDWARE,BUS
			<endo>
		<endo>
		<subs> - Subsystem entry -
		volt
		<bgno> - Battery 2 Bus Voltmeter -
			<unId> - unit id -
			B2_V
			<timK>
			5.0
			<mMon> -- Monitored System --
			<bgno>
				<grou>
				batt
				<user>
				HARDWARE,BATTERY
			<endo>
		<endo>
		<subs> - Subsystem entry -
		volt
		<bgno> - Battery 1 Bus Voltmeter -
			<unId> - unit id -
			B1_V
			<timK>
			5.0
			<mMon> -- Monitored System --
			<bgno>
				<grou>
				batt
				<user>
				HARDWARE,BATTERY
			<endo>
		<endo>
		<subs> - Subsystem entry -
		volt
		<bgno> - PS1 Bus Voltmeter -
			<unId> - unit id -
			PS1V
			<timK>
			5.0
			<mMon> -- Monitored System --
			<bgno>
				<grou>
				PS1_
				<user>
				HARDWARE,BUS
			<endo>
		<endo>

		///////////////////////////////////////////////
		//
		//	Primary Electrical System
		//
		///////////////////////////////////////////////
		<subs> - Subsystem entry -
		batt
		<bgno> - Battery -
			<life> - amp-hour rating -
			34
			<volt>
			24.0
		<endo>
		<subs> - Subsystem entry -
		cntr
		<bgno> - Left Emergency Battery Contactor -
			<unId> - unit id -
			Lebc
			<batt> - Left Battery -
			batt
			<clos>
			<bgno>
				<grou>
				LecC
				<user>
				HARDWARE,STATE
			<endo>
			<open>
			<bgno>
				<grou>
				LecO
				<user>
				HARDWARE,STATE
			<endo>
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Left Emergency Battery Contactor Logic (Close) -
			<unId>
			LecC
			<hwId>
			STATE
			<bool> -- Battery Switch (emergency position)
			emg1
			<bool> -- Battery Switch (On position)
			emg2
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Left Emergency Battery Contactor Logic (Open) -
			<unId>
			LecO
			<hwId>
			STATE
			<bool> -- Battery Switch (Off position)
			emg3
		<endo>
		<subs> - Subsystem entry -
		cntr
		<bgno> - Right Emergency Battery Contactor -
			<unId> - unit id -
			Rebc
			<batt> - Right Battery -
			batt
			<clos>
			<bgno>
				<grou>
				RecC
				<user>
				HARDWARE,STATE
			<endo>
			<open>
			<bgno>
				<grou>
				RecO
				<user>
				HARDWARE,STATE
			<endo>
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Right Emergency Battery Contactor Logic (Close) -
			<unId>
			RecC
			<hwId>
			STATE
			<bool> -- Battery Switch (emergency position)
			emg1
			<bool> -- Battery Switch (On position)
			emg2
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Right Emergency Battery Contactor Logic (Open) -
			<unId>
			RecO
			<hwId>
			STATE
			<bool> -- Battery Switch (Off position)
			emg3
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - PE Bus -
			<unId> - unit id -
			PEbs
			<hwId> - hardware type -
			BUS
			<eBus> - PS1 Busbar -
			PS1_
			<eBus> - PS2 Busbar -
			PS2_
			<cntr> - Batt 1 Emergency Contactor -
			Lebc
			<cntr> - Batt 2 Emergency Contactor -
			Rebc
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Start Enable Switch (Power On / Push to Abort)-
			<unId> - unit id -
			pwer
			<hwId> - hardware type -
			SWITCH
			<batt> - Right Battery -
			batt
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Starter Bus -
			<unId> - unit id -
			strB
			<hwId> - hardware type -
			BUS
			<swch> - Switch Circuit -
			pwer
		<endo>
		<subs> - Subsystem entry -
		genr
		<bgno> - Engine 1 Generator -
			<unId> - unit id -
			Lgen
			<eNum> - Engine Number -
			1
			<mxld> - max capacity (amps)
			250
			<loRg> - least RPM regulatable -
			40
			<volt> - voltage -
			28
			<batt> -- Battery (dont ask) --
			:batt
			<cntr> -- Left Generator Contactor --
			Lgen
		<endo>
		<subs> - Subsystem entry -
		genr
		<bgno> - Engine 2 Generator -
			<unId> - unit id -
			Rgen
			<eNum> - Engine Number -
			2
			<mxld> - max capacity (amps)
			250
			<loRg> - least RPM regulatable -
			40
			<volt> - voltage -
			28
			<batt> -- Battery (dont ask) --
			:batt
			<cntr> -- Right Generator Contactor --
			Rgen
		<endo>
		<subs> - Subsystem entry -
		ests
		<bgno> - Engine 1 Status -
			<unId> - unit id -
			eng1
			<eNum> - Engine Number -
			1
			<mode> -- Engine State Monitor --
			RUNNING
		<endo>
		<subs> - Subsystem entry -
		ests
		<bgno> - Engine 2 Status -
			<unId> - unit id -
			eng2
			<eNum> - Engine Number -
			2
			<mode> -- Engine State Monitor --
			RUNNING
		<endo>
		<subs> - Subsystem entry -
		cntr
		<bgno> - Generator 1 Contactor -
			<unId> - unit id -
			Lgen
			<genr> - Left engine generator -
			Lgen
			<clos> - Close Logic Subsystem -
			<bgno>
				<grou>
				LgnC
				<user>
				HARDWARE,STATE
			<endo>
			<open> - Open Logic Subsystem -
			<bgno>
				<grou>
				LgnO
				<user>
				HARDWARE,STATE
			<endo>
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Left Generator Contactor Logic (Close) -
			<unId> -- Unit Id --
			LgnC
			<hwId>
			STATE
			<bool> -- Left Generator is turning --
			eng1
			<bool> -- Left Gen Switch (pos 1, CLOSE)
			Lgp1
			<_AND> -- AND Gate Logic --
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Left Generator Contactor Logic (Open) -
			<unId> -- Unit Id --
			LgnO
			<hwId>
			STATE
			<bool> -- not Left Generator turning --
			~eng1
			<bool> -- Left Gen Switch (pos 3, TRIP)
			Lgp3
		<endo>
		<subs> - Subsystem entry -
		swst
		<bgno> - Left Generator Switch Set -
			<unId> - unit id -
			LgSS
			<dflt> -- Default Switch Position --
			2
			<smsg> -- Message Data (pos 1, CLOSE) --
			<bgno>
				<grou>
				Lgp1
				<user>
				HARDWARE,STATE
			<endo>
			<smsg> -- Message Data (pos2, no name) --
			<bgno>
				<grou>
				Lgp2
				<user>
				HARDWARE,STATE
			<endo>
			<smsg> -- Message Data (pos3, TRIP) --
			<bgno>
				<grou>
				Lgp3
				<user>
				HARDWARE,STATE
			<endo>
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Left Switch State (Pos 1) -
			<unId> - unit id -
			Lgp1
			<hwId> - hardware type -
			STATE
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Left Switch State (Pos 2) -
			<unId> - unit id -
			Lgp2
			<hwId> - hardware type -
			STATE
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Left Switch State (Pos 3) -
			<unId> - unit id -
			Lgp3
			<hwId> - hardware type -
			STATE
		<endo>
		<subs> - Subsystem entry -
		cntr
		<bgno> - Generator 2 Contactor -
			<unId> - unit id -
			Rgen
			<genr> - Right Generator -
			Rgen
			<clos> - Close Logic Subsystem -
			<bgno>
				<grou>
				RgnC
				<user>
				HARDWARE,STATE
			<endo>
			<open> - Open Logic Subsystem -
			<bgno>
				<grou>
				RgnO
				<user>
				HARDWARE,STATE
			<endo>
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Right Generator Contactor Logic (Close) -
			<unId> -- Unit Id --
			RgnC
			<hwId>
			STATE
			<bool> -- Right Generator turning --
			eng2
			<bool> -- Right Gen Switch (pos 1, CLOSE)
			Rgp1
			<_AND> -- AND Gate Logic --
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Right Generator Contactor Logic (Open) -
			<unId> -- Unit Id --
			RgnO
			<hwId>
			STATE
			<bool> -- not Right Generator turning --
			~eng2
			<bool> -- Right Gen Switch (pos 3, TRIP)
			Rgp3
		<endo>
		<subs> - Subsystem entry -
		swst
		<bgno> - Right Generator Switch Set -
			<unId> - unit id -
			RgSS
			<dflt> -- Default Switch Position --
			2
			<smsg> -- Message Data (pos 1, CLOSE) --
			<bgno>
				<grou>
				Rgp1
				<user>
				HARDWARE,STATE
			<endo>
			<smsg> -- Message Data (pos2, no name) --
			<bgno>
				<grou>
				Rgp2
				<user>
				HARDWARE,STATE
			<endo>
			<smsg> -- Message Data (pos3, TRIP) --
			<bgno>
				<grou>
				Rgp3
				<user>
				HARDWARE,STATE
			<endo>
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Right Switch State (Pos 1) -
			<unId> - unit id -
			Rgp1
			<hwId> - hardware type -
			STATE
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Right Switch State (Pos 2) -
			<unId> - unit id -
			Rgp2
			<hwId> - hardware type -
			STATE
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Right Switch State (Pos 3) -
			<unId> - unit id -
			Rgp3
			<hwId> - hardware type -
			STATE
		<endo>
		/////////////////////////////////////////
		//
		//	Bus Tie 
		//
		/////////////////////////////////////////
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Bus Tie 1 -
			<unId> - unit id -
			tieL
			<hwId> - hardware type -
			STATE
			<eBus> - ps1 busbar -
			ps1_
			<cntr> -- Buse Tie Contactor --
			bTie
			<_AND>
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Bus Tie 2 -
			<unId> - unit id -
			tieR
			<hwId> - hardware type -
			STATE
			<eBus> - ps1 busbar -
			ps2_
			<cntr> -- Buse Tie Contactor --
			bTie
			<_AND>
		<endo>
		<subs> - Subsystem entry -
		swst
		<bgno> - Bus Tie Switch Set -
			<unId> - unit id -
			bTie
			<smsg> -- tie Bus Tie (Close) --
			<bgno>
				<grou>
				tieC
				<user>
				HARDWARE,STATE
			<endo>
			<smsg> -- nothing Bus Tie (Neutral) --
			<bgno>
				<grou>
				tieN
				<user>
				HARDWARE,STATE
			<endo>
			<smsg> -- un-tie Bus Tie (Open) --
			<bgno>
				<grou>
				tieO
				<user>
				HARDWARE,STATE
			<endo>
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Bus Tie Open -
			<unId> - unit id -
			tieO
			<hwId> - hardware type -
			STATE
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Bus Tie Nuetral -
			<unId> - unit id -
			tieN
			<hwId> - hardware type -
			STATE
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Bus Tie Close -
			<unId> - unit id -
			tieC
			<hwId> - hardware type -
			STATE
		<endo>
		<subs> - Subsystem entry -
		cntr
		<bgno> - Bus Tie Contactor -
			<unId> - unit id -
			bTie
			<clos> - Close Logic Subsystem -
			<bgno>
				<grou>
				tieC
				<user>
				HARDWARE,STATE
			<endo>
			<open> - Open Logic Subsystem -
			<bgno>
				<grou>
				tieO
				<user>
				HARDWARE,STATE
			<endo>
		<endo>
		///////////////////////////////////////////////
		///////////////////////////////////////////////
		<subs> - Subsystem entry -
		dpnd
		<bgno> - PS1 Busbar -
			<unId> - unit id -
			PS1_
			<hwId> - hardware type -
			BUS
			<eBus> - ps1 busbar -
			ps1_
			<bool> - Bus Tie 2 -
			tieR
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - PS2 Busbar -
			<unId> - unit id -
			PS2_
			<hwId> - hardware type -
			BUS
			<eBus> - ps2 busbar -
			ps2_
			<cntr> - APU Generator Contactor -
			Agen
			<bool> - Bus Tie 1 -
			tieL
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - PS1A Busbar -
			<unId> - unit id -
			PS1A
			<hwId> - hardware type -
			BUS
			<eBus> - PS1 busbar -
			PS1_
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - PS1B Busbar -
			<unId> - unit id -
			PS1B
			<hwId> - hardware type -
			BUS
			<eBus> - PS1 busbar -
			PS1_
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - PS2A Busbar -
			<unId> - unit id -
			PS2A
			<hwId> - hardware type -
			BUS
			<eBus> - PS1 busbar -
			PS2_
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - PS2B Busbar -
			<unId> - unit id -
			PS2B
			<hwId> - hardware type -
			BUS
			<eBus> - PS1 busbar -
			PS2_
		<endo>
		<subs> - Subsystem entry -
		swst
		<bgno> - Battery Switch Set (3 position) -
			<unId> - unit id -
			mBat
			<dflt> -- Default Switch Position --
			3
			<smsg> - Batt Emerg (pos 1)
			<bgno>
				<grou>
				emg1
				<user>
				HARDWARE,STATE
			<endo>
			<smsg> - On (pos 2)
			<bgno>
				<grou>
				emg2
				<user>
				HARDWARE,STATE
			<endo>
			<smsg> - Off (pos 3)
			<bgno>
				<grou>
				emg3
				<user>
				HARDWARE,STATE
			<endo>
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Emergnecy Battery Switch (pos 1, Emerg) -
			<unId> -- Unit Id --
			emg1
			<hwId> -- hardware Id --
			STATE
			<st8t>
			0
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Emergnecy Battery Switch (pos 2, On) -
			<unId> -- Unit Id --
			emg2
			<hwId> -- hardware Id --
			STATE
			<eBus> -- Not PS1 Busbar Active --
			~PS1_
			<eBus> -- Not PS2 Busbar Active --
			~PS2_
			<_AND> -- AND Gate Logic --
			<st8t>
			0
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Emergnecy Battery Switch (pos 3, Off) -
			<unId> -- Unit Id --
			emg3
			<hwId> -- hardware Id --
			STATE
			<st8t>
			1
		<endo>
		<subs> - Subsystem entry -
		cntr
		<bgno> - Left Battery Contactor -
			<unId> - unit id -
			Lbc_
			<batt> - Battery -
			batt
			<clos>
			<bgno>
				<grou>
				LisC
				<user>
				HARDWARE,STATE
			<endo>
			<open>
			<bgno>
				<grou>
				LisO
				<user>
				HARDWARE,STATE
			<endo>
		<endo>
		<subs> - Subsystem Entry -
		dpnd
		<bgno> - Left Battery Isolate Logic (Close)
			<unId>
			LisC
			<hwId>
			STATE
			<eBus> -- PS1 Busbar --
			PS1_
			<bool> -- Battery Isolate Switch (pos2, Normal)
			norm
			<_AND> -- And Gate Logic --
		<endo>
		<subs> - Subsystem Entry -
		dpnd
		<bgno> - Left Battery Isolate Logic (Open)
			<unId>
			LisO
			<hwId>
			STATE
			<bool> -- Battery Isolate Switch (pos1, Batt 1)
			bat1
			<bool> -- Battery Switch not Off --
			~emg3
			<_AND>
		<endo>
		<subs> - Subsystem entry -
		cntr
		<bgno> - Right Battery Contactor -
			<unId> - unit id -
			Rbc_
			<batt> - Battery -
			batt
			<clos>
			<bgno>
				<grou>
				RisC
				<user>
				HARDWARE,STATE
			<endo>
			<open>
			<bgno>
				<grou>
				RisO
				<user>
				HARDWARE,STATE
			<endo>
		<endo>
		<subs> - Subsystem Entry -
		dpnd
		<bgno> - Right Battery Isolate Logic (Close)
			<unId>
			RisC
			<hwId>
			STATE
			<eBus> -- PS1 Busbar --
			PS2_
			<bool> -- Battery Isolate Switch (pos2, Normal)
			norm
			<_AND> -- And Gate Logic --
		<endo>
		<subs> - Subsystem Entry -
		dpnd
		<bgno> - Right Battery Isolate Logic (Open)
			<unId>
			RisO
			<hwId>
			STATE
			<bool> -- Battery Isolate Switch (pos1, Batt 2)
			bat2
			<bool> -- Battery Switch not Off --
			~emg3
			<_AND>
		<endo>
		<subs> - Subsystem entry -
		swst
		<bgno> - Battery Isolate Switch Set (3 position) -
			<unId> - unit id -
			isol
			<dflt> -- Default Switch Position --
			2
			<smsg> - Batt 1 Contactor Off (pos 1)
			<bgno>
				<grou>
				bat1				
				<user>
				HARDWARE,STATE
			<endo>
			<smsg> - Batt 1 & 2 Contactor On (pos 2)
			<bgno>
				<grou>
				norm
				<user>
				HARDWARE,STATE
			<endo>
			<smsg> - Batt 2 Contactor Off (pos 2)
			<bgno>
				<grou>
				bat2
				<user>
				HARDWARE,STATE
			<endo>
		<endo>
		<subs> - Subsystem Entry -
		dpnd
		<bgno> - Battery Isolate Switch (pos 1, Batt 1)
			<unId>
			bat1
			<hwId>
			STATE
		<endo>
		<subs> - Subsystem Entry -
		dpnd
		<bgno> - Battery Isolate Switch (pos 2, NORM)
			<unId>
			norm
			<hwId>
			STATE
		<endo>
		<subs> - Subsystem Entry -
		dpnd
		<bgno> - Battery Isolate Switch (pos 3, Batt 2)
			<unId>
			bat2
			<hwId>
			STATE
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Ext Battery Charge -
			<unId> -- Unit Id --
			chrg
			<hwId> -- hardware Id --
			SWITCH
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Ext Power -
			<unId> -- Unit Id --
			epwr
			<hwId> -- hardware Id --
			SWITCH
		<endo>
		//
		//	AC Control
		//
		<subs> - Subsystem entry -
		nvrt
		<bgno> - Standby Inverter -
			<unId> - unit id -
			xe_I
			<FreQ> -- AC Frequency --
			400
			<volt> -- AC Voltage --
			115
			<swch> - Standby Inverter Switch -
			sinv
		<endo>
		<subs> - Subsystem entry -
		nvrt
		<bgno> - Left Inverter -
			<unId> - unit id -
			xs1I
			<FreQ> -- AC Frequency --
			400
			<volt> -- AC Voltage --
			115
			<cntr> - XS 1 Contactor -
			XS1_
		<endo>
		<subs> - Subsystem entry -
		nvrt
		<bgno> - Right Inverter -
			<unId> - unit id -
			xs2I
			<FreQ> -- AC Frequency --
			400
			<volt> -- AC Voltage --
			115
			<cntr> - XS 2 Contactor -
			XS2_
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - XE Bus -
			<unId> - unit id -
			XEbs
			<hwId> - hardware type -
			BUS
			<FreQ> -- AC Frequency --
			400
			<nvrt> - Standby Inverter -
			xe_I
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - XS1 Busbar -
			<unId> - unit id -
			XS1_
			<hwId> - hardware type -
			BUS
			<FreQ> -- AC Frequency --
			400
			<nvrt> - XS 1 Inverter -
			xs1I
			<eBus>
			XEbs
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - XS2 Busbar -
			<unId> - unit id -
			XS2_
			<hwId> - hardware type -
			BUS
			<FreQ> -- AC Frequency --
			400
			<nvrt> - XS 2 Inverter -
			xs2I
			<eBus>
			XEbs
		<endo>
		<subs> - Subsystem entry -
		cntr
		<bgno> - Inverter 1 Contactor -
			<unId> - unit id -
			XS1_
			<eBus> -- PS 1 Busbar --
			PS1_
			<clos> - Close Logic Subsystem -
			<bgno>
				<grou>
				xs1C
				<user>
				HARDWARE,STATE
			<endo>
			<open> - Open Logic Subsystem -
			<bgno>
				<grou>
				xs1O
				<user>
				HARDWARE,STATE
			<endo>
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - XS 1 Contactor (Close Logic) -
			<unId> - Unit Id -
			xs1C
			<hwId> - hardware type -
			STATE
			<_AND> -- AND Gate --
			<eBus> -- PS 1 Busbar --
			PS1_
			<swch> -- Inverter 1 Switch (close pos) -- 
			i1On
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - XS 1 Contactor (Open Logic) -
			<unId> - Unit Id -
			xs1O
			<hwId> - hardware type -
			STATE
			<eBus> -- not PS 1 Busbar --
			~PS1_
			<swch> -- Inverter 1 Switch (open pos) -- 
			i1Of
		<endo>
		<subs> - Subsystem entry -
		cntr
		<bgno> - Inverter 2 Contactor -
			<unId> - unit id -
			XS2_
			<eBus> -- PS 2 Busbar --
			PS2_
			<clos> - Close Logic Subsystem -
			<bgno>
				<grou>
				xs2C
				<user>
				HARDWARE,STATE
			<endo>
			<open> - Open Logic Subsystem -
			<bgno>
				<grou>
				xs2O
				<user>
				HARDWARE,STATE
			<endo>
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - XS 2 Contactor (Close Logic) -
			<unId> - Unit Id -
			xs2C
			<hwId> - hardware type -
			STATE
			<_AND> -- AND Gate --
			<eBus> -- PS 2 Busbar --
			PS2_
			<swch> -- Inverter 2 Switch (close pos) --
			i2On
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - XS 2 Contactor (Open Logic) -
			<unId> - Unit Id -
			xs2O
			<hwId> - hardware type -
			STATE
			<eBus> -- not PS 2 Busbar --
			~PS2_
			<swch> -- Inverter 2 Switch (open pos) --
			i2Of
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Left Alternator Switch -
			<unId> - Unit Id -
			alt1
			<hwId> - hardware type -
			SWITCH
			<load>
			4.00
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Right Alternator Switch -
			<unId> - Unit Id -
			alt2
			<hwId> - hardware type -
			SWITCH
			<load>
			4.00
		<endo>
		<subs> - Subsystem entry -
		natr
		<bgno> - Left Alternator -
			<unId> - unit id -
			altL
			<swch> - circuit -
			alt1
			<mxld> - max capacity (amps)
			250
			<loRg> - least RPM regulatable -
			50
			<volt> - max Voltage -
			208.0
			<uNum> -- Unit Number
			1
			<_AC_> -- A.C. Power Source --
			<rpmO> -- RPM option --
			1
		<endo>
		<subs> - Subsystem entry -
		natr
		<bgno> - Right Alternator -
			<unId> - unit id -
			altR
			<swch> - circuit -
			alt2
			<mxld> - max capacity (amps)
			250
			<loRg> - least RPM regulatable -
			50
			<volt> - max Voltage -
			208.0
			<uNum> -- Unit Number
			2
			<_AC_> -- A.C. Power Source --
			<rpmO> -- RPM option --
			1
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Inverter 1 On -
			<unId> - unit id -
			i1On
			<hwId> - hardware type -
			SWITCH
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Inverter 1 Neutral -
			<unId> - unit id -
			i1Ne
			<hwId> - hardware type -
			SWITCH
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Inverter 1 Off -
			<unId> - unit id -
			i1Of
			<hwId> - hardware type -
			SWITCH
		<endo>
		<subs> - Subsystem entry -
		swst
		<bgno> - Inverter 1 Switch Set -
			<unId> - unit id -
			inv1
			<dflt> -- Default Switch Position --
			2
			<smsg> -- Off --
			<bgno>
				<grou>
				i1Of
				<user>
				HARDWARE,SWITCH
			<endo>
			<smsg> -- Neutral --
			<bgno>
				<grou>
				i1Ne
				<user>
				HARDWARE,SWITCH
			<endo>
			<smsg> -- On --
			<bgno>
				<grou>
				i1On
				<user>
				HARDWARE,SWITCH
			<endo>
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Inverter 2 On -
			<unId> - unit id -
			i2On
			<hwId> - hardware type -
			SWITCH
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Inverter 2 Neutral -
			<unId> - unit id -
			i2Ne
			<hwId> - hardware type -
			SWITCH
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Inverter 2 Off -
			<unId> - unit id -
			i2Of
			<hwId> - hardware type -
			SWITCH
		<endo>
		<subs> - Subsystem entry -
		swst
		<bgno> - Inverter 2 Switch Set -
			<unId> - unit id -
			inv2
			<dflt> -- Default Switch Position --
			2
			<smsg> -- Off --
			<bgno>
				<grou>
				i2Of
				<user>
				HARDWARE,SWITCH
			<endo>
			<smsg> -- Neutral --
			<bgno>
				<grou>
				i2Ne
				<user>
				HARDWARE,SWITCH
			<endo>
			<smsg> -- On --
			<bgno>
				<grou>
				i2On
				<user>
				HARDWARE,SWITCH
			<endo>
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Standby Inverter Switch -
			<unId> - unit id -
			sinv
			<hwId> - hardware type -
			SWITCH
			<eBus> -- PE Busbar --
			PEbs
		<endo>
		//////////////////////////////////////
		//
		//	MWS System (glareshield)
		//
		//////////////////////////////////////
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- Left MWS Acknowledge Switch --
			<unId> - unit id -
			Lmws
			<hwId> - harware type --
			SWITCH
			<eBus> -- PE Busbar --
			PEbs
		<endo> -- end Subsystem --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- Right MWS Acknowledge Switch --
			<unId> - unit id -
			Rmws
			<hwId> - harware type --
			SWITCH
			<eBus> -- PE Busbar --
			PEbs
		<endo> -- end Subsystem --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- MWS Acknowledge Switches (do not use) --
			<unId> - unit id -
			mwsa
			<hwId>
			STATE
			<swch> - Left MWS Switch -
			Lmws
			<swch> - Right MWS Switch -
			Rmws
			<bool> -- Problem goes away --
			~mwsO
		<endo> -- end Subsystem --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- MWS Test Switch --
			<unId> - unit id -
			mwsT
			<hwId> - Hardware Type -
			SWITCH
			<eBus> -- PE Busbar --
			PEbs
		<endo> -- end Subsystem --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- Latched OR Problem --
			<unId> - unit id -
			Mwss
			<hwId> - Hardware Type -
			STATE
			<cntr> -- MWS Latch --
			mwsL
			<bool> -- MSW Problem --
			mwsO
		<endo> -- end Subsystem --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- Not Latched OR Test --
			<unId> - unit id -
			Mwsn
			<hwId> - Hardware Type -
			STATE
			<cntr> -- MWS Latch --
			~mwsL
			<swch> -- MSW Test --
			mwsT
		<endo> -- end Subsystem --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- Left MWS Light (built into MWS switch) --
			<unId> - unit id -
			Lmwl
			<hwId> - Hardware Type -
			LIGHT
			<eBus> -- PE Busbar --
			PEbs
			<flsh> -- MWS Flasher --
			mwsF
			<cntr> -- MWS Latched --
			mwsL
			<_AND> -- AND Logic --
		<endo> -- end Subsystem --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- Right MWS Light (built into MWS switch) --
			<unId> - unit id -
			Rmwl
			<hwId> - Hardware Type -
			LIGHT
			<eBus> -- PE Busbar --
			PEbs
			<flsh> -- Not MWS Flasher --
			~mwsF
			<cntr> -- MWS LAtched OR Test --
			mwsL
			<_AND> -- And Logic --
		<endo> -- end Subsystem --
		<subs> - Subsystem Entry -
		flsh
		<bgno> -- MWS Flasher --
			<unId> - unit id -
			mwsF
			<bool> - Problem --
			mwsO
			<time> -- flash rate --
			0.5
		<endo> -- end Subsystem --
		<subs> - Subsystem Entry -
		cntr
		<bgno> -- MWS Latch --
			<unId> - unit id -
			mwsL
			<rset> -- Message Data (Reset) --
			<bgno>
				<grou> -- MWS Reset Logic --
				mwsR
				<user>
				HARDWARE,STATE
			<endo>
			<clos> -- Message Data (Close) --
			<bgno>
				<grou> -- MWS On Logic --
				mwsO
				<user>
				HARDWARE,STATE
			<endo>
			<open> -- Message Data (Open) --
			<bgno>
				<grou> -- MWS Acknowledge Switches --
				mwsa
				<user>
				HARDWARE,STATE
			<endo>
		<endo> -- end Subsystem --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- MWS State Logic --
			<unId> - unit id -
			mwsO
			<hwId> - hardware type -
			STATE
			<bool> -- Electrical System Problem --
			Elec
			<bool> -- Ice Protection System Problem --
			Prot
			<bool> -- Fuel System Problem --
			Fool
			<bool> -- Duct System Problem --
			Duct
			<bool> -- Transfer System Problem --
			Xfrd
			<swch> -- MWS test Switch --
			mwsT
			<annr> -- Engine 1 Fire (red) --
			e1fr
			<annr> -- Engine 2 Fire (red) --
			e2fr
			<lite> - HP Air 1 Ovht (red) -
			hpa1
			<lite> - HP Air 2 Ovht (red) -
			hpa2
			<annr> - Oil 1 Lo Press (red) -
			o1lp
			<annr> - Oil 2 Lo Press (red) -
			o2lp
			<lite> - Rear Bay Ovht (red) -
			rboh
			<annr> - Cabin Alt (red) -
			cAlt
			<lite> - Batt 1 Ovht (red) -
			LbtO
			<lite> - Batt 2 Ovht (red) -
			RbtO
			<lite> - XE Fail (red) -
			XEfl
			<lite> - APU Fire (red) -
			APUF
			<lite> - MWS Dim Fail (red) -
			MWSf
		<endo> -- end Subsystem --
		<subs> - Subsystem Entry -
		hist
		<bgno> -- MWS Reset Logic --
			<unId> - unit id -
			mwsR
			<hwId> - hardware type -
			STATE
			<bool> -- Electrical System Problem --
			Elec
			<bool> -- Ice Protection System Problem --
			Prot
			<bool> -- Fuel System Problem --
			Fool
			<bool> -- Duct System Problem --
			Duct
			<bool> -- Transfer System Problem --
			Xfrd
			<swch> -- MWS test Switch --
			mwsT
			<annr> -- Engine 1 Fire (red) --
			e1fr
			<annr> -- Engine 2 Fire (red) --
			e2fr
			<lite> - HP Air 1 Ovht (red) -
			hpa1
			<lite> - HP Air 2 Ovht (red) -
			hpa2
			<annr> - Oil 1 Lo Press (red) -
			o1lp
			<annr> - Oil 2 Lo Press (red) -
			o2lp
			<lite> - Rear Bay Ovht (red) -
			rboh
			<annr> - Cabin Alt (red) -
			cAlt
			<lite> - Batt 1 Ovht (red) -
			LbtO
			<lite> - Batt 2 Ovht (red) -
			RbtO
			<lite> - XE Fail (red) -
			XEfl
			<lite> - APU Fire (red) -
			APUF
			<lite> - MWS Dim Fail (red) -
			MWSf
		<endo> -- end Subsystem --
		//////////////////////////////////////
		//
		//	Main MWS Panel (front)
		//
		//////////////////////////////////////
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - Reverser (amber) -
			rvsr
			<hwId>
			LIGHT
			<annr> -- Reverser Ann --
			rvsr
			<swch> -- MWS Test Switch --
			mwsT
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		annr
		<bgno> -- begin annunciator --
			<unId> - Reverser (amber) -
			rvsr
			<eBus> -- PE Busbar --
			PEbs
			<info> -- Announcer Info Entry --
			<bgno> -- begin Announcer Info --
				<anId> -- Unique Annunciator Id --
				revr
				<bgno> -- Home of Announcing System --
					<grou>
					trev
					<user>
					UNIT,1
					<user>
					ENGINE,1
				<endo>
			<endo> -- end Announcer Info --
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - Mach Trim Fail (amber) -
			mach
			<hwId>
			LIGHT
			<swch> -- MWS Test Switch --
			mwsT
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - HP Air 1 Ovht (red) -
			hpa1
			<hwId>
			LIGHT
			<swch> -- MWS Test Switch --
			mwsT
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - HP Air 2 Ovht (red) -
			hpa2
			<hwId>
			LIGHT
			<swch> -- MWS Test Switch --
			mwsT
		<endo> -- end annunciator --
		/////////////////////////////////////////////////
		/////////////////////////////////////////////////
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - Oil 1 Lo Press (red) -
			o1lp
			<hwId>
			LIGHT
			<annr> -- PE Busbar --
			o1lp
			<swch> -- MWS Test Switch --
			mwsT
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		annr
		<bgno> -- begin annunciator --
			<unId> - Oil 1 Lo Press (red) -
			o1lp
			<eBus> -- PE Busbar --
			PEbs
			<info> -- Announcer Info Entry --
			<bgno> -- begin Announcer Info --
				<anId> -- Unique Annunciator Id --
				loOP
				<bgno> -- Home of Announcing System --
					<grou>
					oilP
					<user>
					UNIT,1
					<user>
					HARDWARE,GAUGE
					<user>
					ENGINE,1
				<endo>
			<endo> -- end Announcer Info --
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - Oil 2 Lo Press (red) -
			o2lp
			<hwId>
			LIGHT
			<annr>
			o2lp
			<swch> -- MWS Test Switch --
			mwsT
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		annr
		<bgno> -- begin annunciator --
			<unId> - Oil 2 Lo Press (red) -
			o2lp
			<eBus> -- PE Busbar --
			PEbs
			<info> -- Announcer Info Entry --
			<bgno> -- begin Announcer Info --
				<anId> -- Unique Annunciator Id --
				loOP
				<bgno> -- Home of Announcing System --
					<grou>
					oilP
					<user>
					UNIT,1
					<user>
					HARDWARE,GAUGE
					<user>
					ENGINE,2
				<endo>
			<endo> -- end Announcer Info --
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - Hyd 1 Lo Press (amber) -
			h1lp
			<hwId>
			LIGHT
			<swch> -- MWS Test Switch --
			mwsT
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - Hyd 2 Lo Press (amber) -
			h2lp
			<hwId>
			LIGHT
			<swch> -- MWS Test Switch --
			mwsT
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - Main Air Valve 1 (amber) -
			mav1
			<hwId>
			LIGHT
			<swch> -- MWS Test Switch --
			mwsT
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - Main Air Valve 2 (amber) -
			mav2
			<hwId>
			LIGHT
			<swch> -- MWS Test Switch --
			mwsT
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - Eng 1 Cmptr (amber) -
			cmp1
			<hwId>
			LIGHT
			<swch> -- MWS Test Switch --
			mwsT
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - Eng 2 Cmptr (amber) -
			cmp2
			<hwId>
			LIGHT
			<swch> -- MWS Test Switch --
			mwsT
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - Eng 1 A/Ice (amber) -
			ice1
			<hwId>
			LIGHT
			<eBus> -- PE Busbar --
			PEbs
			<bool> -- Logic --
			ice1
			<_AND>
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - Eng 1 A/Ice Logic -
			ice1
			<hwId>
			STATE
			<swch> -- MWS Test Switch --
			mwsT
			<swch> -- Eng 1 A Ice --
			ieal
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - Eng 2 A/Ice (amber) -
			ice2
			<hwId>
			LIGHT
			<eBus> -- PE Busbar --
			PEbs
			<bool> -- Logic --
			ice2
			<_AND>
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - Eng 2 A/Ice Logic -
			ice2
			<hwId>
			STATE
			<swch> -- MWS Test Switch --
			mwsT
			<swch> -- Eng 2 A Ice --
			iear
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - Rear Bay Ovht (red) -
			rboh
			<hwId>
			LIGHT
			<swch> -- MWS Test Switch --
			mwsT
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - Cabin Alt (red) -
			cAlt
			<hwId>
			LIGHT
			<annr> -- Annoubcer --
			cAlt
			<swch> -- MWS Test Switch --
			mwsT
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		annr
		<bgno> -- begin annunciator --
			<unId> - Cabin Alt (red) -
			cAlt
			<eBus> -- PE Busbar --
			PEbs
			<info>
			<bgno> -- begin Announcer Info --
				<anId> -- Unique Id of Announcing System --
				hcaw
				<bgno>
					<grou>
					pzat
					<user>
					HARDWARE,OTHER
					<user>
					UNIT,1
					<user>
					ENGINE,1
				<endo>
			<endo> -- end Announcer Info --
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - Elev/Ail Trim (amber) -
			eaTm
			<hwId>
			LIGHT
			<swch> -- MWS Test Switch --
			mwsT
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - Hyd Ovht (amber) -
			hydO
			<hwId>
			LIGHT
			<swch> -- MWS Test Switch --
			mwsT
		<endo> -- end annunciator --
		//
		//	Aux Hydraulic
		//
		<subs> ---- subsystem entry ----
		dpnd
		<bgno> ---- begin ----
			<unId> --- unit ---
			aHyd
			<hwId> --- hardware ---
			SWITCH
		<endo> ---- end ----
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - Aux Hyd Lo Level (amber) -
			aHyd
			<hwId>
			LIGHT
			<swch> -- MWS Test Switch --
			mwsT
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - Emer Brake Lo Press (amber) -
			eblp
			<hwId>
			LIGHT
			<swch> -- MWS Test Switch --
			mwsT
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - Ent Door Unlocked (amber) -
			door
			<hwId>
			LIGHT
			<swch> -- MWS Test Switch --
			mwsT
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - Rudder Bias (amber) -
			rdrb
			<hwId>
			LIGHT
			<annr>
			rdrb
			<swch> -- MWS Test Switch --
			mwsT
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		annr
		<bgno> -- begin annunciator --
			<unId> - Rudder Bias (amber) -
			rdrb
			<eBus> -- PE Busbar --
			PEbs
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - Stall Ident (amber) -
			stl1
			<hwId>
			LIGHT
			<annr>
			stl1
			<swch> -- MWS Test Switch --
			mwsT
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - Stall Ident 2 (amber) -
			stl2
			<hwId>
			LIGHT
			<annr>
			stl2
			<swch> -- MWS Test Switch --
			mwsT
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - Stall Ident 3 (amber) -
			stl3
			<hwId>
			LIGHT
			<annr>
			stl3
			<swch> -- MWS Test Switch --
			mwsT
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		annr
		<bgno> -- begin annunciator --
			<unId> - Stall Ident 1 (amber) -
			stl1
			<eBus> -- PE Busbar --
			PEbs
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		annr
		<bgno> -- begin annunciator --
			<unId> - Stall Ident 2 (amber) -
			stl2
			<eBus> -- PE Busbar --
			PEbs
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		annr
		<bgno> -- begin annunciator --
			<unId> - Stall Ident 3 (amber) -
			stl3
			<eBus> -- PE Busbar --
			PEbs
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - Stall Valve A Open (red) -
			svAo
			<hwId>
			LIGHT
			<swch> -- MWS Test Switch --
			mwsT
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - Stall Valve B Open (red) -
			svBo
			<hwId>
			LIGHT
			<swch> -- MWS Test Switch --
			mwsT
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - SSU Flap (amber) -
			ssuF
			<hwId>
			LIGHT
			<swch> -- MWS Test Switch --
			mwsT
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - Cat II (green) -
			ct2g
			<hwId>
			LIGHT
			<swch> -- MWS Test Switch --
			mwsT
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - Cat II (white) -
			ct2w
			<hwId>
			LIGHT
			<swch> -- MWS Test Switch --
			mwsT
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - Cat II (red) -
			ct2r
			<hwId>
			LIGHT
			<swch> -- MWS Test Switch --
			mwsT
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - Glideslope (amber) -
			gswI
			<hwId>
			LIGHT
			<swch> -- MWS Test Switch --
			mwsT
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - Pull Up (red) -
			pull
			<hwId>
			LIGHT
			<swch> -- MWS Test Switch --
			mwsT
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - Windshear Fail (amber) -
			wdsF
			<hwId>
			LIGHT
			<swch> -- MWS Test Switch --
			mwsT
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - GPWS Fail (amber) -
			gpwF
			<hwId>
			LIGHT
			<swch> -- MWS Test Switch --
			mwsT
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - Windshear Warning (red) -
			wdsW
			<hwId>
			LIGHT
			<swch> -- MWS Test Switch --
			mwsT
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - Windshear Caution (red) -
			wdsC
			<hwId>
			LIGHT
			<swch> -- MWS Test Switch --
			mwsT
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - G/S Cancel (amber) -
			gscC
			<hwId>
			LIGHT
			<swch> -- MWS Test Switch --
			mwsT
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - Autopilot (red) -
			apEg
			<hwId>
			LIGHT
			<swch> -- MWS Test Switch --
			mwsT
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - Yaw Damper (amber) -
			ydEg
			<hwId>
			LIGHT
			<swch> -- MWS Test Switch --
			mwsT
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - Trim Fail (red) -
			trmF
			<hwId>
			LIGHT
			<swch> -- MWS Test Switch --
			mwsT
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - Mistrim (amber) -
			misT
			<hwId>
			LIGHT
			<swch> -- MWS Test Switch --
			mwsT
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - FMS 1 Wpt (amber) -
			f1wp
			<hwId>
			LIGHT
			<swch> -- MWS Test Switch --
			mwsT
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - FMS 1 Msg (amber) -
			f1ms
			<hwId>
			LIGHT
			<swch> -- MWS Test Switch --
			mwsT
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - FMS 2 Wpt (amber) -
			f1wp
			<hwId>
			LIGHT
			<swch> -- MWS Test Switch --
			mwsT
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - FMS 2 Msg (amber) -
			f2ms
			<hwId>
			LIGHT
			<swch> -- MWS Test Switch --
			mwsT
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - GPWS Flap Override (amber) -
			gpwO
			<hwId>
			LIGHT
			<swch> -- MWS Test Switch --
			mwsT
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - Computer Monitor (red) -
			cmpM
			<hwId>
			LIGHT
			<swch> -- MWS Test Switch --
			mwsT
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - EFIS Fan (amber) -
			efsF
			<hwId>
			LIGHT
			<swch> -- MWS Test Switch --
			mwsT
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - EFIS Hot (amber) -
			efsH
			<hwId>
			LIGHT
			<swch> -- MWS Test Switch --
			mwsT
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - FMS 1 Appr (amber) -
			f1ap
			<hwId>
			LIGHT
			<swch> -- MWS Test Switch --
			mwsT
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - FMS 2 Appr (amber) -
			f2ap
			<hwId>
			LIGHT
			<swch> -- MWS Test Switch --
			mwsT
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - ADC2 Fail (red) -
			adcF
			<hwId>
			LIGHT
			<swch> -- MWS Test Switch --
			mwsT
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - ADC2 (amber) -
			adc2
			<hwId>
			LIGHT
			<swch> -- MWS Test Switch --
			mwsT
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - FMS1 SX (amber) -
			f1sx
			<hwId>
			LIGHT
			<swch> -- MWS Test Switch --
			mwsT
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - FMS 2 SX (amber) -
			f2sx
			<hwId>
			LIGHT
			<swch> -- MWS Test Switch --
			mwsT
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - FMS1 Hdg (amber) -
			f1hg
			<hwId>
			LIGHT
			<swch> -- MWS Test Switch --
			mwsT
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - FMS 2 Hdg (amber) -
			f2hg
			<hwId>
			LIGHT
			<swch> -- MWS Test Switch --
			mwsT
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - GPS 1 Integ (amber) -
			gp1i
			<hwId>
			LIGHT
			<swch> -- MWS Test Switch --
			mwsT
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - GPS 2 Integ (amber) -
			gp2i
			<hwId>
			LIGHT
			<swch> -- MWS Test Switch --
			mwsT
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - Approach Arm (amber) -
			aprA
			<hwId>
			LIGHT
			<swch> -- MWS Test Switch --
			mwsT
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - Approach Override (green) -
			aprO
			<hwId>
			LIGHT
			<swch> -- MWS Test Switch --
			mwsT
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - Emerg Lts Not Slct (amber) -
			elns
			<hwId>
			LIGHT
			<swch> -- MWS Test Switch --
			mwsT
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - APU Mstr Sw On (white) -
			amso
			<eBus> -- PE Busbar --
			PEbs
			<bool> -- APU Master Sw On Logic --
			amso
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - APU Mstr Sw On (white) -
			amso
			<hwId>
			STATE
			<swch> -- MWS Test Switch --
			mwsT
			<swch> -- APU MAster Switch --
			Amas
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - Ice Prot Selected (white) -
			IPSd
			<hwId>
			LIGHT
			<annr>
			IPSd
			<swch> -- MWS Test Switch --
			mwsT
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		annr
		<bgno> -- begin annunciator --
			<unId> - Ice Prot Selected (white) -
			IPSd
			<eBus> -- PE Busbar --
			PEbs
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		annr
		<bgno> -- begin annunciator --
			<unId> - Air brake (white) -
			airB
			<eBus> -- PE Busbar --
			PEbs
			<swch> -- MWS Test Switch --
			mwsT
		<endo> -- end annunciator --
		////////////////////////////////////////////////
		//
		//	Engine 1 Fire Repeater
		//
		////////////////////////////////////////////////
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- Eng 1 Fire Light (front) --
			<unId> - Eng 1 Fire ^ (red) -
			e1fr
			<hwId>
			LIGHT
			<eBus> -- PE Busbar --
			PEbs
			<bool> -- Flasher OR problem -
			fir1
			<_AND>
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- Flasher OR (problem AND ~latched) --
			<unId> - unit id -
			fir1
			<hwId>
			STATE
			<flsh> -- Eng 1 Flasher --
			e1fr
			<bool> -- Eng 1 Fire Logic -
			e1fr
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		flsh
		<bgno> -- Eng 1 Fire Flasher --
			<unId> - unit id -
			e1fr
			<annr> -- Engine 1 Fire Annunciator (roof)
			e1fr
			<swch> -- MWS Test Switch --
			mwsT
			<time> -- flash rate --
			0.5
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- problem AND ~latched --
			<unId> - unit id -
			e1fr
			<hwId>
			STATE
			<annr> -- Engine 1 Fire Annunciator (roof)
			e1fr
			<cntr> -- Not MWS Latch --
			~mwsL
			<_AND>
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		annr
		<bgno> -- problem --
			<unId> - Eng 1 Fire (red) -
			e1fr
			<eBus> -- PE Busbar --
			PEbs
			<info>
			<bgno> -- begin Announcer Info --
				<anId> -- Unique Id of Announcing System --
				fire
				<bgno>
					<grou>
					fire
					<user>
					HARDWARE,OTHER
					<user>
					UNIT,1
					<user>
					ENGINE,1
				<endo>
			<endo> -- end Announcer Info --
		<endo> -- end annunciator --
		////////////////////////////////////////////////
		//
		//	Engine 2 Fire Repeater
		//
		////////////////////////////////////////////////
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- Eng 2 Fire Light (front) --
			<unId> - Eng 2 Fire ^ (red) -
			e2fr
			<hwId>
			LIGHT
			<eBus> -- PE Busbar --
			PEbs
			<bool> -- Flasher OR (problem AND ~Latched) -
			fir2
			<_AND>
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- Flasher OR (problem AND ~Latched) --
			<unId> - unit id -
			fir2
			<hwId>
			STATE
			<flsh> -- Eng 2 Flasher --
			e2fr
			<bool> -- Eng 2 Fire Logic -
			e2fr
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		flsh
		<bgno> -- Eng 2 Fire Flasher --
			<unId> - unit id -
			e2fr
			<annr> -- Engine 2 Fire Annunciator (roof)
			e2fr
			<swch> -- MWS Test Switch --
			mwsT
			<time> -- flash rate --
			0.5
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- problem AND ~latched --
			<unId> - unit id -
			e2fr
			<hwId>
			STATE
			<annr> -- Engine 2 Fire Annunciator (roof)
			e2fr
			<cntr> -- Not MWS Latch --
			~mwsL
			<_AND>
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		annr
		<bgno> -- begin annunciator --
			<unId> - Eng 2 Fire (red) -
			e2fr
			<eBus> -- PE Busbar --
			PEbs
			<info>
			<bgno> -- begin Announcer Info --
				<anId> -- Unique Id of Announcing System --
				fire
				<bgno>
					<grou>
					fire
					<user>
					HARDWARE,OTHER
					<user>
					UNIT,1
					<user>
					ENGINE,2
				<endo>
			<endo> -- end Announcer Info --
		<endo> -- end annunciator --
		////////////////////////////////////////////////
		//
		//	Ice Protection Repeater
		//
		////////////////////////////////////////////////
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - Ice Prot ^ (amber) -
			prot
			<hwId>
			LIGHT
			<eBus> -- PE Busbar --
			PEbs
			<bool> -- Flasher OR (problem AND ~latched) --
			PROT
			<_AND>
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- Flasher OR (problem AND ~Latched) --
			<unId> - unit id -
			PROT
			<hwId>
			STATE
			<flsh> -- Ice Prot Flasher --
			prot
			<bool> - problem AND ~latched
			prot
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- Problem and ~Latched --
			<unId> - unit id -
			prot
			<hwId>
			STATE
			<bool> -- Ice Prot Problem --
			Prot
			<cntr> -- Not MWS Latch --
			~mwsL
			<_AND>
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		flsh
		<bgno> -- flasher --
			<unId> - unit id -
			prot
			<bool> -- Ice Prot Problem --
			Prot
			<time> -- flash rate --
			0.5
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- Ice Prot Problem --
			<unId> - unit id -
			Prot
			<hwId>
			STATE
			<lite> -- L Screen Ovht --
			LsOh
			<lite> -- R Screen Ovht --
			RsOh
			<lite> -- L Vane Htr Fail --
			Lvhf
			<lite> -- R Vane Htr Fail --
			Rvhf
			<lite> -- Altr 1 Fail --
			At1f
			<lite> -- Altr 2 Fail
			At2f
			<lite> -- Pitot Heater Fail --
			ptht
			<lite> -- Antice Lo Press --
			AiLo
			<lite> -- Side Screen Ovht --
			SSov
			<lite> -- Antice Lo Qty --
			AiLQ
			<lite> -- Ignition On --
			ignO
			<swch> -- MWS Test Switch --
			mwsT
		<endo> -- end annunciator --
		////////////////////////////////////////////////
		//
		//	Electrical System Repeater
		//
		////////////////////////////////////////////////
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- ELEC Repeater Light --
			<unId> - Elec ^ (amber) -
			elec
			<hwId>
			LIGHT
			<eBus> -- PE Busbar --
			PEbs
			<bool> -- Flasher OR (problem AND ~latched) --
			elec
			<_AND>
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- Flasher OR (problem AND ~latched) --
			<unId> - unit id -
			elec
			<hwId>
			STATE
			<flsh> -- Flasher --
			elec
			<bool> -- problem AND ~latched --
			ELEC
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- problem AND ~latched --
			<unId> - unit id -
			ELEC
			<hwId>
			STATE
			<bool> -- Electrical System Problem --
			Elec
			<cntr> -- not MWS Latched --
			~mwsL
			<_AND>
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		flsh
		<bgno> -- ELEC flasher --
			<unId> - unit id -
			elec
			<bool> -- Electrical System Problem --
			Elec
			<time> -- flash rate --
			0.5
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- Electrical System Problem --
			<unId> - unit id -
			Elec
			<hwId>
			STATE
			<swch> -- MWS Test Switch --
			mwsT
			<lite> -- Gen 1 Fail --
			LgnF
			<lite> -- Gen 2 Fail --
			RgnF
			<lite> -- Batt 1 Contactor --
			B1cr
			<lite> -- Batt 2 Contactor --
			B2cr
			<lite> -- Batt 1 Ovht --
			LbtO
			<lite> -- Batt 2 Ovht --
			RbtO
			<lite> -- Batt 1 Hot --
			LbtH
			<lite> -- Batt 2 Hot --
			RbtH
		<endo> -- end annunciator --
		////////////////////////////////////////////////
		//
		//	Fuel System Repeater
		//
		////////////////////////////////////////////////
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - Fuel ^ (amber) -
			fool
			<hwId>
			LIGHT
			<eBus> -- PE Busbar --
			PEbs
			<bool> -- Flasher OR (problem AND ~latched) --
			fool
			<_AND>
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- Flasher OR (problem AND ~latched) --
			<unId> - unit id -
			fool
			<hwId>
			STATE
			<flsh> -- flasher --
			fool
			<bool> -- problem AND ~latched --
			FOOL
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- problem AND ~latched --
			<unId> - unit id -
			FOOL
			<hwId>
			STATE
			<bool> -- problem --
			Fool
			<cntr> -- not MWS Latched --
			~mwsL
			<_AND>
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		flsh
		<bgno> -- Flasher --
			<unId> - unit id -
			fool
			<bool> -- problem --
			Fool
			<time> -- flash rate --
			0.5
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- Fuel System Problem --
			<unId> - unit id -
			Fool
			<hwId>
			STATE
			<swch> -- MWS Test Switch --
			mwsT
			<annr> -- Eng 1 Fuel --
			LEgF
			<annr> -- Eng 2 Fuel --
			REgF
			<annr> -- Eng 1 Lo Pres --
			LfLo
			<annr> -- Eng 2 Lo Pres --
			RfLo
			<lite> -- Refuel --
			refl
			<annr> -- Aux Fuel Transfer --
			auxT
			<lite> -- Crossfeed --
			XFed
		<endo> -- end annunciator --
		////////////////////////////////////////////////
		//
		//	Duct System Repeater
		//
		////////////////////////////////////////////////
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - Duct Ovht ^ (amber) -
			duct
			<hwId>
			LIGHT
			<eBus> -- PE Busbar --
			PEbs
			<bool> -- Flasher OR (problem AND ~latched) --
			duct
			<_AND>
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- Flasher OR (problem AND ~latched) --
			<unId> - unit id -
			duct
			<hwId>
			STATE
			<flsh> -- Flasher --
			duct
			<bool> -- problem AND ~latched --
			DUCT
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- problem AND ~latched --
			<unId> - unit id -
			DUCT
			<hwId>
			STATE
			<bool> -- problem --
			Duct
			<cntr> -- not MWS LAtched --
			~mwsL
			<_AND>
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		flsh
		<bgno> -- flasher --
			<unId> - unit id -
			duct
			<bool> -- problem --
			Duct
			<time> -- flash rate --
			0.5
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- problem --
			<unId> - unit id -
			Duct
			<hwId>
			STATE
			<swch> -- MWS Test --
			mwsT
		<endo> -- end annunciator --
		////////////////////////////////////////////////
		//
		//	Fuel Crossfeed/Transfer Repeater
		//
		////////////////////////////////////////////////
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - Fuel XFD/TFR ^ (white) -
			xfrd
			<hwId>
			LIGHT
			<eBus> -- PE Busbar --
			PEbs
			<bool> -- Flasher OR (problem AND ~latched) --
			xfrd
			<_AND>
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- Flasher OR (problem AND ~latched) --
			<unId> - unit id -
			xfrd
			<hwId>
			STATE
			<flsh> -- Flasher --
			xfrd
			<bool> -- (problem AND ~latched) --
			XFRD
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- (problem AND ~latched) --
			<unId> - unit id -
			XFRD
			<hwId>
			STATE
			<bool> -- (problem) --
			Xfrd
			<cntr> -- not MWS Latched --
			~mwsL
			<_AND>
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		flsh
		<bgno> -- Fuel XFD/TFR Flasher --
			<unId> - unit id -
			xfrd
			<bool> -- problem --
			Xfrd
			<time> -- flash rate --
			0.5
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- Fuel XFD/TFR Logic --
			<unId> - unit id -
			Xfrd
			<hwId>
			STATE
			<swch> -- MWS Test Switch --
			mwsT
		<endo> -- end annunciator --
		///////////////////////////////////////
		//
		//	Ice Protection Annunciators (roof)
		//
		///////////////////////////////////////
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - L Screen OVHT (amber) -
			LsOh
			<hwId>
			LIGHT
			<eBus> -- PE Busbar --
			PEbs
			<swch> -- MWS Test Switch --
			mwsT
			<_AND>
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - R Screen OVHT (amber) -
			RsOh
			<hwId>
			LIGHT
			<eBus> -- PE Busbar --
			PEbs
			<swch> -- MWS Test Switch --
			mwsT
			<_AND>
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - L Vane Htr Fail (amber) -
			Lvhf
			<hwId>
			LIGHT
			<eBus> -- PE Busbar --
			PEbs
			<swch> -- MWS Test Switch --
			mwsT
			<_AND>
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - R Vane Htr Fail (amber) -
			Rvhf
			<hwId>
			LIGHT
			<eBus> -- PE Busbar --
			PEbs
			<swch> -- MWS Test Switch --
			mwsT
			<_AND>
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - Altr 1 Fail (amber) -
			At1f
			<hwId>
			LIGHT
			<eBus> -- PE Busbar --
			PEbs
			<swch> -- MWS Test Switch --
			mwsT
			<_AND>
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - Altr 2 Fail (amber) -
			At2f
			<hwId>
			LIGHT
			<eBus> -- PE Busbar --
			PEbs
			<swch> -- MWS Test Switch --
			mwsT
			<_AND>
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - Pitot Heater Fail (amber) -
			ptht
			<hwId>
			LIGHT
			<eBus> -- PE Busbar --
			PEbs
			<swch> -- MWS Test Switch --
			mwsT
			<_AND>
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - Antice Lo Press (amber) -
			AiLo
			<hwId>
			LIGHT
			<eBus> -- PE Busbar --
			PEbs
			<swch> -- MWS Test Switch --
			mwsT
			<_AND>
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - Side Screen Ovht (amber) -
			SSov
			<hwId>
			LIGHT
			<eBus> -- PE Busbar --
			PEbs
			<swch> -- MWS Test Switch --
			mwsT
			<_AND>
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - Antice Lo Qty (amber) -
			AiLQ
			<hwId>
			LIGHT
			<eBus> -- PE Busbar --
			PEbs
			<swch> -- MWS Test Switch --
			mwsT
			<_AND>
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - Ignition On (white) -
			ignO
			<hwId>
			LIGHT
			<bool> -- Logic --
			ignO
			<eBus> -- PE Busbar --
			PEbs
			<_AND>
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - Ignition On Logic -
			ignO
			<hwId>
			STATE
			<swch> -- MWS Test Switch --
			mwsT
			<swch> -- Left Igniter --
			ieil
			<swch> -- Right Igniter --
			ieir
		<endo> -- end annunciator --
		///////////////////////////////////////
		//
		//	Fuel Annunciators (roof)
		//
		///////////////////////////////////////
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- Eng 1 Fuel Light --
			<unId> - unit id -
			LEgF
			<hwId>
			LIGHT
			<eBus> -- PE Busbar --
			PEbs
			<bool> -- Logic --
			LEgF
			<_AND>
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- Eng 1 Fuel Logic --
			<unId> - unit id -
			LEgF
			<hwId> -- hardware type --
			STATE
			<annr> -- annunciator --
			LEgF
			<swch> -- MWS Test Switch --
			mwsT
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		annr
		<bgno> -- begin annunciator --
			<unId> - Eng 1 Fuel (amber) -
			LEgF
			<info>
			<bgno> -- begin Announcer Info --
				<anId> -- Unique Id of Announcing System --
				lowQ
				<bgno>
					<grou>
					fgag
					<user>
					HARDWARE,GAUGE
					<user>
					UNIT,1
					<user>
					ENGINE,1
					<user>
					TANK,1
				<endo>
			<endo> -- end Announcer Info --
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - Eng 2 Fuel (amber) -
			REgF
			<hwId>
			LIGHT
			<eBus> -- PE Busbar --
			PEbs
			<bool>
			REgF
			<_AND>
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - Eng 2 Fuel (amber) -
			REgF
			<hwId>
			STATE
			<swch> -- MWS Test Switch --
			mwsT
			<annr> -- annunciator --
			REgF
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		annr
		<bgno> -- begin annunciator --
			<unId> - Eng 2 Fuel (amber) -
			REgF
			<info>
			<bgno> -- begin Announcer Info --
				<anId> -- Unique Id of Announcing System --
				lowQ
				<bgno>
					<grou>
					fgag
					<user>
					HARDWARE,GAUGE
					<user>
					UNIT,1
					<user>
					ENGINE,2
					<user>
					TANK,1
				<endo>
			<endo> -- end Announcer Info --
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - Fuel 1 Lo Press (amber) -
			LfLo
			<hwId>
			LIGHT
			<eBus> -- PE Busbar --
			PEbs
			<bool> -- State --
			LfLo
			<_AND>
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - Fuel 1 Lo Press (amber) -
			LfLo
			<hwId>
			STATE
			<annr>
			LfLo
			<swch> -- MWS Test Switch --
			mwsT
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		annr
		<bgno> -- begin annunciator --
			<unId> - Fuel 1 Lo Press (amber) -
			LfLo
			<eBus> -- PE Busbar --
			PEbs
			<info>
			<bgno> -- begin Announcer Info --
				<anId> -- Unique Id of Announcing System --
				loPs
				<bgno>
					<grou>
					fprs
					<user>
					HARDWARE,GAUGE
					<user>
					UNIT,1
					<user>
					ENGINE,1
				<endo>
			<endo> -- end Announcer Info --
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - Fuel 2 Lo Press (amber) -
			RfLo
			<hwId>
			LIGHT
			<eBus> -- PE Busbar --
			PEbs
			<bool> -- State --
			RfLo
			<_AND>
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - Fuel 2 Lo Press (amber) -
			RfLo
			<hwId>
			STATE
			<annr>
			RfLo
			<swch> -- MWS Test Switch --
			mwsT
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		annr
		<bgno> -- begin annunciator --
			<unId> - Fuel 2 Lo Press (amber) -
			RfLo
			<eBus> -- PE Busbar --
			PEbs
			<info>
			<bgno> -- begin Announcer Info --
				<anId> -- Unique Id of Announcing System --
				loPs
				<bgno>
					<grou>
					fprs
					<user>
					HARDWARE,GAUGE
					<user>
					UNIT,1
					<user>
					ENGINE,2
				<endo>
			<endo> -- end Announcer Info --
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - Refuel On (amber) -
			refl
			<hwId>
			LIGHT
			<eBus> -- PE Busbar --
			PEbs
			<swch> -- MWS Test Switch --
			mwsT
			<_AND>
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- Aux Fuel Transfer --
			<unId> - unit id -
			auxT
			<hwId>
			SWITCH
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- Aux Fuel Transfer --
			<unId> - unit id -
			auxT
			<hwId>
			LIGHT
			<annr> -- Annubciator --
			auxT
			<swch> -- MWS Test Switch --
			mwsT
			<swch> -- transfer --
			auxT
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		annr
		<bgno> -- begin annunciator --
			<unId> - Aux Fuel Transfer (white) -
			auxT
			<eBus> -- PE Busbar --
			PEbs
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - Wing Fuel XFD/TRF (white) -
			XFed
			<hwId>
			LIGHT
			<eBus> -- PE Busbar --
			PEbs
			<bool> -- Wing Fuel XFD/TRF Logic --
			XFed
			<_AND>
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - Wing Fuel XFD/TRF Logic -
			XFed
			<hwId>
			STATE
			<swch> -- MWS Test Switch --
			mwsT
			<annr> -- Xfed Announcer --
			XFed
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		annr
		<bgno> -- begin annunciator --
			<unId> - Wing Fuel XFD -
			XFed
			<info>
			<bgno> -- begin Announcer Info --
				<anId> -- Unique Id of Announcing System --
				xfed
				<bgno>
					<grou>
					xfed
					<user>
					UNIT,1
					<user>
					HARDWARE,SWITCH
				<endo>
			<endo> -- end Announcer Info --
		<endo> -- end annunciator --
		/////////////////////////////////////
		//
		//	Electrical Annunciators (roof)
		//
		/////////////////////////////////////
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - Batt 1 Ovht (red) -
			LbtO
			<hwId>
			LIGHT
			<eBus> -- PE Busbar --
			PEbs
			<swch> -- MWS Test Switch --
			mwsT
			<_AND>
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - Batt 2 Ovht (red) -
			RbtO
			<hwId>
			LIGHT
			<eBus> -- PE Busbar --
			PEbs
			<swch> -- MWS Test Switch --
			mwsT
			<_AND>
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - Batt 1 Hot (amber) -
			LbtH
			<hwId>
			LIGHT
			<eBus> -- PE Busbar --
			PEbs
			<swch> -- MWS Test Switch --
			mwsT
			<_AND>
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - Batt 2 Hot (amber) -
			RbtH
			<hwId>
			LIGHT
			<eBus> -- PE Busbar --
			PEbs
			<swch> -- MWS Test Switch --
			mwsT
			<_AND>
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - Gen 1 Fail (amber) -
			LgnF
			<hwId>
			LIGHT
			<eBus> -- PE Busbar --
			PEbs
			<bool> -- Gen 1 Fail Logic --
			LgnF
			<_AND>
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> --  Gen 1 Fail Logic --
			<unId> - unit id -
			LgnF
			<hwId>
			STATE
			<cntr> -- Gen 1 Contactor --
			~Lgen
			<swch> -- MWS Test Switch --
			mwsT
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - Gen 2 Fail (amber) -
			RgnF
			<hwId>
			LIGHT
			<eBus> -- PE Busbar --
			PEbs
			<bool> -- Gen 2 Fail Logic --
			RgnF
			<_AND>
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- Gen 2 Fail Logic --
			<unId> - unit id -
			RgnF
			<hwId>
			STATE
			<cntr> Gen 2 Contactor --
			~Rgen
			<swch> -- MWS Test Switch --
			mwsT
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - Batt 1 contactor (amber) -
			B1cr
			<hwId>
			LIGHT
			<eBus> -- PE Busbar --
			PEbs
			<bool> -- Batt 1 Contactor Logic --
			B1cr
			<_AND>
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - Batt 1 contactor (amber) -
			B1cr
			<hwId>
			STATE
			<cntr> -- Batt 1 Contactor --
			~Lbc_
			<bool> -- Battery Emergency --
			emg1
			<swch> -- MWS Test Switch --
			mwsT
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - Batt 2 contactor (amber) -
			B2cr
			<hwId>
			LIGHT
			<eBus> -- PE Busbar --
			PEbs
			<bool> -- Batt 2 Contactor Logic --
			B2cr
			<_AND>
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - Batt 2 contactor Logic -
			B2cr
			<hwId>
			STATE
			<cntr> -- Batt 2 Contactor --
			~Rbc_
			<bool> -- Battery Emergency --
			emg1
			<swch> -- MWS Test Switch --
			mwsT
		<endo> -- end annunciator --
		///////////////////////////////////
		//
		//	AC Power Annunciators (roof)
		//
		///////////////////////////////////
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - XS 1 Fail (amber) -
			XS1F
			<hwId>
			LIGHT
			<eBus> -- PE Busbar --
			PEbs
			<bool> -- XS 1 fial logic --
			XS1F
			<_AND> -- AND Gate --
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - XS 1 Fail Logic -
			XS1F
			<hwId>
			STATE
			<swch> -- MWS Test Switch --
			mwsT
			<eBus> -- PS 1 Busbar --
			~PS1_
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - XE Fail (red) -
			XEfl
			<hwId>
			LIGHT
			<eBus> -- PE Busbar --
			PEbs
			<bool> -- XE fial logic --
			XEfl
			<_AND> -- AND Gate --
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - XE Fail logic -
			XEfl
			<hwId>
			STATE
			<swch> -- MWS Test Switch --
			mwsT
			<eBus> -- PE Busbar --
			~PEbs
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - XS 2 Fail (amber) -
			XS2F
			<hwId>
			LIGHT
			<eBus> -- PE Busbar --
			PEbs
			<bool> -- XS 2 fial logic --
			XS2F
			<_AND> -- AND Gate --
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - XS 2 Fail logic -
			XS2F
			<hwId>
			STATE
			<swch> -- MWS Test Switch --
			mwsT
			<eBus> -- PS 2 Busbar --
			~PS2_
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - INV 1 Fail (amber) -
			IN1f
			<hwId>
			LIGHT
			<eBus> -- PE Busbar -- --
			PEbs
			<bool> -- Invert 1 Fail logic --
			IN1f
			<_AND> -- AND Gate --
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - Invert 1 Fail logic -
			IN1f
			<hwId>
			STATE
			<swch> -- MWS Test Switch --
			mwsT
			<eBus> -- not Inverter 1 Busbar --
			~XS1_
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - INV 2 Fail (amber) -
			IN2f
			<hwId>
			LIGHT
			<eBus> -- PE Busbar -- --
			PEbs
			<bool> -- Invert 2 Fail logic --
			IN2f
			<_AND> -- AND Gate --
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - Invert 2 Fail logic -
			IN2f
			<hwId>
			STATE
			<swch> -- MWS Test Switch --
			mwsT
			<eBus> -- not Inverter 2 Busbar --
			~XS2_
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - Stby Inv ON (white) -
			Sivo
			<hwId>
			LIGHT
			<eBus> -- PE Bus --
			PEbs
			<bool> -- Stby Inv Logic --
			Sivo
			<_AND> -- AND Gate --
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - Stby Inv Logic -
			Sivo
			<hwId>
			STATE
			<swch> -- MWS Test Switch --
			mwsT
			<swch> -- Inverter switch --
			sinv
		<endo> -- end annunciator --
		///////////////////////////
		//
		//	Misc. Annunciators
		//
		///////////////////////////
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - AP Trim (amber) -
			APtm
			<hwId>
			LIGHT
			<swch> -- MWS Test Switch --
			mwsT
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - EL Fail (amber) -
			ELfl
			<hwId>
			LIGHT
			<swch> -- MWS Test Switch --
			mwsT
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - EFIS Fail PTR (amber) -
			FISf
			<hwId>
			LIGHT
			<swch> -- MWS Test Switch --
			mwsT
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - EFIS Ovht (amber) -
			FISo
			<hwId>
			LIGHT
			<swch> -- MWS Test Switch --
			mwsT
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - MWS Dim Fail (red) -
			MWSf
			<hwId>
			LIGHT
			<swch> -- MWS Test Switch --
			mwsT
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin --
			<unId> - Autopilot Fuse -
			auto
			<hwId>
			FUSE
			<eBus> -- PS2A Busbar --
			PS2A
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		grlt
		<bgno> -- Nose Gear Unlocked (RED) annunciator --
			<unId> -- Unit Id --
			gTrN
			<gNum> -- Gear Number --
			1
			<mode> -- Monitor Mode (0=EXTENDED 1=RETRACTED 2=TRANSIT) --
			2
			<eBus>
			PEbs
		<endo> -- end Gear Unlocked --
		<subs> - Subsystem Entry -
		grlt
		<bgno> -- Left Gear Unlocked (RED) annunciator --
			<unId> -- Unit Id --
			gTrL
			<gNum> -- Gear Number --
			2
			<mode> -- Monitor Mode (0=EXTENDED 1=RETRACTED 2=TRANSIT) --
			2
			<eBus>
			PEbs
		<endo> -- end Gear Unlocked --
		<subs> - Subsystem Entry -
		grlt
		<bgno> -- Right Gear Unlocked (RED) annunciator --
			<unId> -- Unit Id --
			gTrR
			<gNum> -- Gear Number --
			3
			<mode> -- Monitor Mode (0=EXTENDED 1=RETRACTED 2=TRANSIT) --
			2
			<eBus>
			PEbs
		<endo> -- end Gear Unlocked --
		<subs> - Subsystem Entry -
		grlt
		<bgno> -- Nose Gear Down and Locked (GREEN) annunciator --
			<unId> -- Unit Id --
			gLtN
			<gNum> -- Gear Number --
			1
			<mode> -- Monitor Mode (0=EXTENDED 1=RETRACTED 2=TRANSIT) --
			0
			<eBus>
			PEbs
		<endo> -- end Gear Unlocked --
		<subs> - Subsystem Entry -
		grlt
		<bgno> -- Left Gear Down and Locked (GREEN) annunciator --
			<unId> -- Unit Id --
			gLtL
			<gNum> -- Gear Number --
			2
			<mode> -- Monitor Mode (0=EXTENDED 1=RETRACTED 2=TRANSIT) --
			0
			<eBus>
			PEbs
		<endo> -- end Gear Unlocked --
		<subs> - Subsystem Entry -
		grlt
		<bgno> -- Right Gear Down and Locked (GREEN) annunciator --
			<unId> -- Unit Id --
			gLtR
			<gNum> -- Gear Number --
			3
			<mode> -- Monitor Mode (0=EXTENDED 1=RETRACTED 2=TRANSIT) --
			0
			<eBus>
			PEbs
		<endo> -- end Gear Unlocked --
		///////////////////////////
		//
		//	Misc. Switches
		//
		///////////////////////////
		<subs> - Subsystem entry -
		dpnd
		<bgno> - No Smoking Switch -
			<unId> - unit id -
			smok
			<hwId> - hardware type -
			SWITCH
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Seat Belts Switch -
			<unId> - unit id -
			belt
			<hwId> - hardware type -
			SWITCH
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Stall Ident 1 Test -
			<unId> - unit id -
			si1T
			<hwId> - hardware type -
			SWITCH
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Stall Ident 2 Test -
			<unId> - unit id -
			si2T
			<hwId> - hardware type -
			SWITCH
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Stall Ident 3 Test -
			<unId> - unit id -
			si3T
			<hwId> - hardware type -
			SWITCH
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Eng Fire 1 Test -
			<unId> - unit id -
			ef1T
			<hwId> - hardware type -
			SWITCH
			<pxy1> -- Proxy Message (leading edge) --
			<bgno>
				<grou> -- Eng 1 Fire System --
				fire
				<user>
				HARDWARE,OTHER
				<user>
				ENGINE,1
				<user>
				DATATAG,'test'
				<type>
				INT,1
			<endo>
			<pxy0> -- Proxy Message (tailing edge) --
			<bgno>
				<grou> -- Eng 1 Fire System --
				fire
				<user>
				HARDWARE,OTHER
				<user>
				ENGINE,1
				<user>
				DATATAG,'test'
				<type>
				INT,0
			<endo>
			<fWAV> - sfx -
			firebell.wav
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Eng Fire 2 Test -
			<unId> - unit id -
			ef2T
			<hwId> - hardware type -
			SWITCH
			<pxy1> -- Proxy Message (leading edge) --
			<bgno>
				<grou> -- Eng 2 Fire System --
				fire
				<user>
				HARDWARE,OTHER
				<user>
				ENGINE,2
				<user>
				DATATAG,'test'
				<type>
				INT,1
			<endo>
			<pxy0> -- Proxy Message (tailing edge) --
			<bgno>
				<grou> -- Eng 2 Fire System --
				fire
				<user>
				HARDWARE,OTHER
				<user>
				ENGINE,2
				<user>
				DATATAG,'test'
				<type>
				INT,0
			<endo>
			<fWAV> - sfx -
			firebell.wav
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - EFIS 1 Test -
			<unId> - unit id -
			es1T
			<hwId> - hardware type -
			SWITCH
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - EFIS 2 Test -
			<unId> - unit id -
			es2T
			<hwId> - hardware type -
			SWITCH
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - HP Air Ovht Test -
			<unId> - unit id -
			hpoT
			<hwId> - hardware type -
			SWITCH
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Ice Det Test -
			<unId> - unit id -
			icdT
			<hwId> - hardware type -
			SWITCH
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Cabin Alt Test -
			<unId> - unit id -
			calT
			<hwId> - hardware type -
			SWITCH
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - ADS 1 Test -
			<unId> - unit id -
			ad1T
			<hwId> - hardware type -
			SWITCH
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - ADS 2 Test -
			<unId> - unit id -
			ad2T
			<hwId> - hardware type -
			SWITCH
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - VMO MMO 1 Test -
			<unId> - unit id -
			vm1T
			<hwId> - hardware type -
			SWITCH
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - VMO MMO 2 Test -
			<unId> - unit id -
			vm2T
			<hwId> - hardware type -
			SWITCH
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - LO VMO 1 Test -
			<unId> - unit id -
			lo1T
			<hwId> - hardware type -
			SWITCH
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - LO VMO 2 Test -
			<unId> - unit id -
			lo2T
			<hwId> - hardware type -
			SWITCH
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - AOA Test -
			<unId> - unit id -
			aoaT
			<hwId> - hardware type -
			SWITCH
		<endo>
		///////////////////////////
		//
		//	Misc. Systems
		//
		///////////////////////////
		<subs> - Subsystem entry -
		oxyg
		<bgno> - Primary Oxygen System -
			<uNum> -- Unit Number --
			1
		<endo>
		<subs> - Subsystem entry -
		oxyg
		<bgno> - Passenger Emergency Oxygen System -
			<uNum> -- Unit Number --
			2
		<endo>
		<subs> - Subsystem entry -
		gyro
		<bgno> - Pilot Directional Gyro -
			<uNum> -- Unit Number --
			1
			<regd> -- Pressure Regulated --
			<step> - heading bug -
			1.0
			<nErr> - auto align -
			1
			<eBus>
			PS1_
		<endo>
		<subs> - Subsystem entry -
		gyro
		<bgno> - Co-Pilot Directional Gyro -
			<uNum> -- unit number --
			2
			<regd> -- Pressure Regulated --
			<step> - heading bug -
			1.0
			<nErr> - auto align -
			1
			<eBus>
			PS2_
		<endo>
		<subs> - Subsystem entry -
		doat
		<bgno> - Chronometer -
			<unId> -- unit ID --
			pdcg
		<endo>
		<subs> - Subsystem entry -
		doat
		<bgno> - Chronometer -
			<unId> -- unit ID --
			cdcg
		<endo>
		<subs> - Subsystem entry -
		temp
		<bgno> - Temperature control -
			<targ> --- target temp ----
			77.0
		<endo>
		<subs> - Subsystem entry -
		tasd
		<bgno> - SAT/TAT/TAS display -
			<mSPD> - airspeed message -
			<bgno> - begin -
				<grou>
				sped
				<user>
				HARDWARE,GAUGE
			<endo> - end -
			<eBus>
			PEbs
		<endo>
		<subs> - Subsystem entry -
		sdic
		<bgno> - Surface Deice System -
			<cycT> -- cycle time secs --
			600.0
			<drip> -- Drip System (not pneumatic) --
		<endo>
		<subs> - Subsystem entry -
		mcmp
		<bgno> - magnetic compass -
		<endo>
		<subs> - Subsystem entry -
		navg
		<bgno> - Navigation gauge -
			<unId> - nav gauge id -
			nav1
			<eBus> - circuit connection -
			PS1_
		<endo>
		<subs> - Subsystem entry -
		navg
		<bgno> - Navigation gauge -
			<unId> - nav gauge id -
			mno1
			<eBus> - circuit connection -
			PS1_
		<endo>
		<subs> - Subsystem entry -
		navg
		<bgno> - Navigation gauge -
			<unId> - nav gauge id -
			nav2
			<eBus>
			PS2_
		<endo>
		<subs> - Subsystem entry -
		navg
		<bgno> - Navigation gauge -
			<unId> - nav gauge id -
			mno2
			<eBus>
			PS2_
		<endo>
		<subs> - Subsystem entry -
		turn
		<bgno> - Pilot Turn Coordinater -
			<timK>
			0.5
			<tilt>
			0.5
			<uNum> -- unit number --
			1
		<endo>
		<subs> - Subsystem entry -
		turn
		<bgno> - Copilot Turn Coordinater -
			<timK>
			0.5
			<tilt>
			0.5
			<uNum> -- unit number --
			2
		<endo>
		<subs> ---- subsystem entry ----
		dmep
		<bgno> ---- BEGIN OBJECT ----
			<unId> ---- unit id ----
			dme1
			<eBus>
			PS1_
			<hold>
		<endo>
		<subs> ---- subsystem entry ----
		dmep
		<bgno> ---- BEGIN OBJECT ----
			<unId> ---- unit id ----
			dme2
			<eBus>
			PS2_
			<hold>
		<endo>
		///////////////////////////////////////////////////////////
		//
		//	Collins Autopilot Master Panel (APP-85,MSP-85)
		//
		///////////////////////////////////////////////////////////
		<subs> -- Subsystem entry -
		MrAp
		<bgno> -- Autopilot Master --
			<fuse> - circuit connection -
			auto
			<mAP1> -- Pilot Autopilot Panel Message --
			<bgno>
				<grou>
				'pilo'
				<user>
				HARDWARE,OTHER
			<endo>
			<mAP2> -- Copilot Autopilot Panel Message --
			<bgno>
				<grou>
				'copi'
				<user>
				HARDWARE,OTHER
			<endo>
		<endo> -- End Autopilot Master --
		///////////////////////////////////////////////////////////
		//
		//	Collins Autopilot Panel (APP-85,MSP-85)
		//	Pilot Systems
		//
		///////////////////////////////////////////////////////////
		<subs> - Subsystem entry -
		C085
		<bgno> - Autopilot -
			<unId> - unit ID -
			pilo
			<atop> -- autopilot specification --
			<bgno>
				<fcsf> -- Autopilot File --
				MD83.fcs
			<endo>
			<fuse> - circuit connection -
			auto
			<load> - circuit load (amps)
			2
			<upLm>
			4000
			<dnLm>
			-3000
			<mDG_> -- Directional Gyro System --
			<bgno>
				<grou>
				'gyro'
				<user>
				HARDWARE,GAUGE
			<endo>
			<mAlt> -- Altimeter System --
			<bgno>
				<grou>
				'alti'
				<user>
				HARDWARE,GAUGE
				<user>
				UNIT,1
			<endo>
			<nav1> -- Navigation Gage System --
			<bgno>
				<grou>
				'nav1'
				<user>
				HARDWARE,GAUGE
			<endo>
		<endo>
		///////////////////////////////////////////////////////////
		//
		//	Collins Autopilot Panel (APP-85,MSP-85)
		//	Copilot Systems
		//
		///////////////////////////////////////////////////////////
		<subs> - Subsystem entry -
		C085
		<bgno> - Autopilot -
			<unId> - unit ID -
			copi
			<atop> -- autopilot specification --
			<bgno>
				<fcsf> -- Autopilot File --
				MD83.fcs
			<endo>
			<fuse> - circuit connection -
			auto
			<load> - circuit load (amps)
			2
			<mDG_> -- Directional Gyro System --
			<bgno>
				<grou>
				'gyro'
				<user>
				HARDWARE,GAUGE
			<endo>
			<mAlt> -- Altimeter System --
			<bgno>
				<grou>
				'alti'
				<user>
				HARDWARE,GAUGE
				<user>
				UNIT,2
			<endo>
			<nav1> -- Navigation Gage System --
			<bgno>
				<grou>
				'nav1'
				<user>
				HARDWARE,GAUGE
			<endo>
		<endo>
		///////////////////////////////////////////////////
		//
		//	EFIS #1 (Pilot)
		//
		///////////////////////////////////////////////////
		<subs> - Subsystem entry -
		dpnd
		<bgno> - EFIS On switch -
			<unId>
			e1s+
			<hwId>
			SWITCH
			<eBus>
			PS1A
		<endo> - end -
		<subs> - Subsystem entry -
		dpnd
		<bgno> - EFIS On Light -
			<unId>
			e1l+
			<hwId>
			LIGHT
			<swch>
			e1s+
		<endo> - end -
		<subs> - Subsystem entry -
		dpnd
		<bgno> - EFIS Off switch -
			<unId>
			e1s-
			<hwId>
			SWITCH
			<eBus>
			PS1A
		<endo> - end -
		<subs> - Subsystem entry -
		dpnd
		<bgno> - EFIS Off Light -
			<unId>
			e1l-
			<hwId>
			LIGHT
			<swch>
			e1s-
		<endo> - end -
		<subs> - Subsystem entry -
		swst
		<bgno> - EFIS 1 Power switch set -
			<unId> - unit id -
			efs1
			<dflt> -- Default Switch Position --
			2
			<smsg> -- Message Data (pos 1, ON) --
			<bgno>
				<grou>
				e1s+
				<user>
				HARDWARE,SWITCH
			<endo>
			<smsg> -- Message Data (pos2, OFF) --
			<bgno>
				<grou>
				e1s-
				<user>
				HARDWARE,SWITCH
			<endo>
		<endo>
		<subs> - Subsystem entry -
		cpfd
		<bgno> - Pilot PFD Display -
			<unId>
			ppfd
			<swch>
			e1s+
			<aspd> - airspeed gauge -
			<bgno> - begin -
				<conn> ---- info tag ----
				sped
				<user> ---- hardware ----
				HARDWARE,GAUGE
			<endo> - end - 
			<alti> - altimeter gauge -
			<bgno> - begin -
				<conn> ---- info tag ----
				alti
				<user> ---- hardware ----
				HARDWARE,GAUGE
			<endo> - end - 
			<aoaI> - AOA gauge -
			<bgno> - begin -
				<conn> ---- info tag ----
				stal
				<user> ---- hardware ----
				HARDWARE,GAUGE
				<user> ---- data tag ----
				DATATAG,'spdR'
			<endo> - end - 
			<alt1> - altimeter #1 -
			<bgno> - begin -
				<grou>
				alti
				<user>
				HARDWARE,GAUGE
				<user>
				UNIT,1
			<endo> - end -
			<alt2> - altimeter #2 -
			<bgno> - begin -
				<grou>
				alti
				<user>
				HARDWARE,GAUGE
				<user>
				UNIT,2
			<endo> - end -
			<cnvd> - nav display -
			<bgno> - begin -
				<grou>
				pnvd
				<user>
				HARDWARE,OTHER
				<user>
				UNIT,1
			<endo> - end -
			<ap1_> - autopilot #1 -
			<bgno> - begin -
				<conn> ---- data tag ----
				pilo
				<user> ---- user data ----
				HARDWARE,OTHER
				<user> ---- user data ----
				UNIT,1
			<endo> - end -
			<ap2_> - autopilot #2 -
			<bgno> - begin -
				<conn> ---- data tag ----
				copi
				<user> ---- user data ----
				HARDWARE,OTHER
				<user> ---- user data ----
				UNIT,1
			<endo> - end -
		<endo>
		<subs> - Subsystem entry -
		cnvd
		<bgno> - Pilot Nav Display -
			<unId>
			pnvd
			<swch>
			e1s+
			<wrdr> - radar -
			<bgno> - begin -
				<conn> ---- data tag ----
				wrdr
				<user> ---- user data ----
				HARDWARE,OTHER
				<user> ---- user data ----
				UNIT,1
			<endo> - end -
			<gyro> - dg -
			<bgno> - begin -
				<conn> ---- data tag ----
				gyro
				<user> ---- user data ----
				HARDWARE,GAUGE
				<user> ---- user data ----
				UNIT,1
			<endo> - end -
			<obs_> - obs -
			<bgno> - begin -
				<conn> ---- data tag ----
				nav1
				<user> ---- user data ----
				HARDWARE,GAUGE
				<user> ---- user data ----
				UNIT,1
				<user> ---- datatag ----
				DATATAG,'obs_'
			<endo> - end -
			<ap__> - autopilot -
			<bgno> - begin -
				<grou>
				pilo
				<user>
				HARDWARE,OTHER
				<user>
				UNIT,1
			<endo> - end -
		<endo>
		<subs> - Subsystem entry -
		cadd
		<bgno> - Pilot Air Data Display -
			<unId>
			padd
			<swch>
			e1s+
			<ap__> - autopilot #1 -
			<bgno> - begin -
				<conn> ---- data tag ----
				pilo
				<user> ---- user data ----
				HARDWARE,OTHER
				<user> ---- user data ----
				UNIT,1
			<endo> - end -
			<aspd> - airspeed gauge -
			<bgno> - begin -
				<conn> ---- info tag ----
				sped
				<user> ---- hardware ----
				HARDWARE,GAUGE
			<endo> - end - 
			<alti> - altimeter gauge -
			<bgno> - begin -
				<conn> ---- info tag ----
				alti
				<user> ---- hardware ----
				HARDWARE,GAUGE
			<endo> - end - 
		<endo>
		<subs> - Subsystem entry -
		cmnd
		<bgno> - Pilot Multi Nav Display -
			<unId>
			pmnd
			<swch>
			e1s+
			<gyro> - dg -
			<bgno> - begin -
				<conn> ---- data tag ----
				gyro
				<user> ---- user data ----
				HARDWARE,GAUGE
				<user> ---- user data ----
				UNIT,1
			<endo> - end -
			<obs_> - obs -
			<bgno> - begin -
				<conn> ---- data tag ----
				mno1
				<user> ---- user data ----
				HARDWARE,GAUGE
				<user> ---- user data ----
				UNIT,1
				<user> ---- datatag ----
				DATATAG,'obs_'
			<endo> - end -
			<ap__> - autopilot -
			<bgno> - begin -
				<grou>
				pilo
				<user>
				HARDWARE,OTHER
				<user>
				UNIT,1
			<endo> - end -
		<endo>
		///////////////////////////////////////////////////
		//
		//	EFIS #2 (Copilot)
		//
		///////////////////////////////////////////////////
		<subs> - Subsystem entry -
		dpnd
		<bgno> - EFIS On switch -
			<unId>
			e2s+
			<hwId>
			SWITCH
			<eBus>
			PS2A
		<endo> - end -
		<subs> - Subsystem entry -
		dpnd
		<bgno> - EFIS On Light -
			<unId>
			e2l+
			<hwId>
			LIGHT
			<swch>
			e2s+
		<endo> - end -
		<subs> - Subsystem entry -
		dpnd
		<bgno> - EFIS Off switch -
			<unId>
			e2s-
			<hwId>
			SWITCH
			<eBus>
			PS2A
		<endo> - end -
		<subs> - Subsystem entry -
		dpnd
		<bgno> - EFIS Off Light -
			<unId>
			e2l-
			<hwId>
			LIGHT
			<swch>
			e2s-
		<endo> - end -
		<subs> - Subsystem entry -
		swst
		<bgno> - EFIS 2 Power switch set -
			<unId> - unit id -
			efs2
			<dflt> -- Default Switch Position --
			2
			<smsg> -- Message Data (pos 1, ON) --
			<bgno>
				<grou>
				e2s+
				<user>
				HARDWARE,SWITCH
			<endo>
			<smsg> -- Message Data (pos2, OFF) --
			<bgno>
				<grou>
				e2s-
				<user>
				HARDWARE,SWITCH
			<endo>
		<endo>
		<subs> - Subsystem entry -
		cpfd
		<bgno> - Copilot PFD Display -
			<unId>
			cpfd
			<swch>
			e2s+
			<aspd> - airspeed gauge -
			<bgno> - begin -
				<conn> ---- info tag ----
				sped
				<user> ---- hardware ----
				HARDWARE,GAUGE
			<endo> - end - 
			<alti> - altimeter gauge -
			<bgno> - begin -
				<conn> ---- info tag ----
				alti
				<user> ---- hardware ----
				HARDWARE,GAUGE
			<endo> - end - 
			<aoaI> - AOA gauge -
			<bgno> - begin -
				<conn> ---- info tag ----
				stal
				<user> ---- hardware ----
				HARDWARE,GAUGE
				<user> ---- data tag ----
				DATATAG,'spdR'
			<endo> - end - 
			<alt2> - altimeter #2 -
			<bgno> - begin -
				<grou>
				alti
				<user>
				HARDWARE,GAUGE
				<user>
				UNIT,1
			<endo> - end -
			<alt1> - altimeter #1 -
			<bgno> - begin -
				<grou>
				alti
				<user>
				HARDWARE,GAUGE
				<user>
				UNIT,2
			<endo> - end -
			<cnvd> - nav display -
			<bgno> - begin -
				<grou>
				cnvd
				<user>
				HARDWARE,OTHER
				<user>
				UNIT,1
			<endo> - end -
			<ap1_> - autopilot #1 -
			<bgno> - begin -
				<conn> ---- data tag ----
				pilo
				<user> ---- user data ----
				HARDWARE,OTHER
				<user> ---- user data ----
				UNIT,1
			<endo> - end -
			<ap2_> - autopilot #2 -
			<bgno> - begin -
				<conn> ---- data tag ----
				copi
				<user> ---- user data ----
				HARDWARE,OTHER
				<user> ---- user data ----
				UNIT,1
			<endo> - end -
		<endo>
		<subs> - Subsystem entry -
		cnvd
		<bgno> - Copilot Nav Display -
			<unId>
			cnvd
			<swch>
			e2s+
			<wrdr> - radar -
			<bgno> - begin -
				<conn> ---- data tag ----
				wrdr
				<user> ---- user data ----
				HARDWARE,OTHER
				<user> ---- user data ----
				UNIT,2
			<endo> - end -
			<gyro> - dg -
			<bgno> - begin -
				<conn> ---- data tag ----
				gyro
				<user> ---- user data ----
				HARDWARE,GAUGE
				<user> ---- user data ----
				UNIT,2
			<endo> - end -
			<obs_> - obs -
			<bgno> - begin -
				<conn> ---- data tag ----
				nav2
				<user> ---- user data ----
				HARDWARE,GAUGE
				<user> ---- user data ----
				UNIT,1
				<user> ---- datatag ----
				DATATAG,'obs_'
			<endo> - end -
			<ap__> - autopilot -
			<bgno> - begin -
				<grou>
				copi
				<user>
				HARDWARE,OTHER
				<user>
				UNIT,1
			<endo> - end -
		<endo>
		<subs> - Subsystem entry -
		cadd
		<bgno> - Copilot Air Data Display -
			<unId>
			cadd
			<swch>
			e2s+
			<ap__> - autopilot #1 -
			<bgno> - begin -
				<conn> ---- data tag ----
				copi
				<user> ---- user data ----
				HARDWARE,OTHER
				<user> ---- user data ----
				UNIT,1
			<endo> - end -
			<aspd> - airspeed gauge -
			<bgno> - begin -
				<conn> ---- info tag ----
				sped
				<user> ---- hardware ----
				HARDWARE,GAUGE
			<endo> - end - 
			<alti> - altimeter gauge -
			<bgno> - begin -
				<conn> ---- info tag ----
				alti
				<user> ---- hardware ----
				HARDWARE,GAUGE
			<endo> - end - 
		<endo>
		<subs> - Subsystem entry -
		cmnd
		<bgno> - Copilot Multi Nav Display -
			<unId>
			cmnd
			<swch>
			e2s+
			<gyro> - dg -
			<bgno> - begin -
				<conn> ---- data tag ----
				gyro
				<user> ---- user data ----
				HARDWARE,GAUGE
				<user> ---- user data ----
				UNIT,1
			<endo> - end -
			<obs_> - obs -
			<bgno> - begin -
				<conn> ---- data tag ----
				mno2
				<user> ---- user data ----
				HARDWARE,GAUGE
				<user> ---- user data ----
				UNIT,1
				<user> ---- datatag ----
				DATATAG,'obs_'
			<endo> - end -
			<ap__> - autopilot -
			<bgno> - begin -
				<grou>
				pilo
				<user>
				HARDWARE,OTHER
				<user>
				UNIT,1
			<endo> - end -
		<endo>
		///////////////////////////////////////////////////
		//
		//	Radio stack
		//
		///////////////////////////////////////////////////
		<subs> ---- subsystem entry ----
		comm
		<bgno> ---- BEGIN OBJECT ----
			<unId> ---- unit id ----
			comm
			<uNum> ---- unit number ----
			1
			<load> - circuit load (amps) -
			0.5
			<eBus>
			PS1_
		<endo> ---- END OBJECT ----
		<subs> ---- subsystem entry ----
		comm
		<bgno> ---- BEGIN OBJECT ----
			<unId> ---- unit id ----
			comm
			<uNum> ---- unit number ----
			2
			<load> - circuit load (amps) -
			0.5
			<eBus>
			PS2_
		<endo> ---- END OBJECT ----
		<subs> ---- subsystem entry ----
		navi
		<bgno> ---- BEGIN OBJECT ----
			<unId> ---- unit id ----
			navi
			<uNum> ---- unit number ----
			1
			<load> - circuit load (amps) -
			0.5
			<eBus>
			PS1_
		<endo> ---- END OBJECT ----
		<subs> ---- subsystem entry ----
		navi
		<bgno> ---- BEGIN OBJECT ----
			<unId> ---- unit id ----
			navi
			<uNum> ---- unit number ----
			2
			<load> - circuit load (amps) -
			0.5
			<eBus>
			PS2_
		<endo> ---- END OBJECT ----
		<subs> ---- subsystem entry ----
		xpdr
		<bgno> ---- BEGIN OBJECT ----
			<unId> ---- unit id ----
			xpdr
			<uNum> ---- unit number ----
			1
			<load> - circuit load (amps) -
			0.5
			<eBus>
			PEbs
			<smod> - default mode -
			5
		<endo> ---- END OBJECT ----
		<subs> ---- subsystem entry ----
		xpdr
		<bgno> ---- BEGIN OBJECT ----
			<unId> ---- unit id ----
			xpdr
			<uNum> ---- unit number ----
			2
			<load> - circuit load (amps) -
			0.5
			<eBus>
			PS2_
			<smod> - default mode -
			3
		<endo> ---- END OBJECT ----
		<subs> - Subsystem entry -
		wrdr
		<bgno> - Weather radar -
			<unId> ---- unit id ----
			wrdr
			<uNum> ---- number ----
			1
			<eBus>
			PS1_
		<endo> 
		<subs> - Subsystem entry -
		wrdr
		<bgno> - Weather radar -
			<unId> ---- unit id ----
			wrdr
			<uNum> ---- number ----
			2
			<eBus>
			PS2_
		<endo> 
		<subs> - Subsystem entry -
		wrdr
		<bgno> - Weather radar -
			<unId> ---- unit id ----
			wrdr
			<uNum> ---- number ----
			3
			<eBus>
			PS1_
		<endo> 
		<subs> ---- subsystem entry ----
		adio
		<bgno> ---- BEGIN OBJECT ----
			<unId> ---- unit id ----
			adio
			<uNum> ---- unit number ----
			1
			<load> - circuit load (amps) -
			0.5
			<eBus>
			PEbs
		<endo> ---- END OBJECT ----
		<subs> ---- subsystem entry ----
		adio
		<bgno> ---- BEGIN OBJECT ----
			<unId> ---- unit id ----
			adio
			<uNum> ---- unit number ----
			2
			<load> - circuit load (amps) -
			0.5
			<eBus>
			PS2_
		<endo> ---- END OBJECT ----
		<subs> ---- subsystem entry ----
		adfr
		<bgno> ---- BEGIN OBJECT ----
			<unId> ---- unit id ----
			adfr
			<uNum> ---- unit number ----
			1
			<load> - circuit load (amps) -
			0.5
			<frct> - fractional tuning -
			<eBus>
			PEbs
		<endo> ---- END OBJECT ----
		<subs> ---- subsystem entry ----
		adfr
		<bgno> ---- BEGIN OBJECT ----
			<unId> ---- unit id ----
			adfr
			<uNum> ---- unit number ----
			2
			<load> - circuit load (amps) -
			0.5
			<frct> - fractional tuning -
			<eBus>
			PS2_
		<endo> ---- END OBJECT ----
		<subs> ---- subsystem entry ----
		hifr
		<bgno> ---- BEGIN OBJECT ----
			<unId> ---- unit id ----
			hifr
			<uNum> ---- unit number ----
			1
			<load> - circuit load (amps) -
			0.5
			<eBus>
			PEbs
		<endo> ---- END OBJECT ----
		<subs> ---- subsystem entry ----
		hifr
		<bgno> ---- BEGIN OBJECT ----
			<unId> ---- unit id ----
			hifr
			<uNum> ---- unit number ----
			2
			<load> - circuit load (amps) -
			0.5
			<eBus>
			PS2_
		<endo> ---- END OBJECT ----
		<subs> ---- subsystem entry ----
		vgps
		<bgno> ---- Virtual GPS Radio ----
			<unId> ---- unit id ----
			vgps
			<uNum> ---- unit number ----
			1
		<endo> ---- END OBJECT ----
		///////////////////////////////////////////////////
		//
		//	Radio Tuning Units (RTU)
		//
		///////////////////////////////////////////////////
		<subs> - Subsystem entry -
		dpnd
		<bgno> - RTU On switch -
			<unId>
			r1s+
			<hwId>
			SWITCH
			<eBus>
			PS1_
		<endo> - end -
		<subs> - Subsystem entry -
		dpnd
		<bgno> - RTU On Light -
			<unId>
			r1l+
			<hwId>
			LIGHT
			<swch>
			r1s+
		<endo> - end -
		<subs> - Subsystem entry -
		dpnd
		<bgno> - RTU Off switch -
			<unId>
			r1s-
			<hwId>
			SWITCH
			<eBus>
			PS1_
		<endo> - end -
		<subs> - Subsystem entry -
		dpnd
		<bgno> - RTU Off Light -
			<unId>
			r1l-
			<hwId>
			LIGHT
			<swch>
			r1s-
		<endo> - end -
		<subs> - Subsystem entry -
		swst
		<bgno> - RTU 1 Power switch set -
			<unId> - unit id -
			rtu1
			<dflt> -- Default Switch Position --
			2
			<smsg> -- Message Data (pos 1, ON) --
			<bgno>
				<grou>
				r1s+
				<user>
				HARDWARE,SWITCH
			<endo>
			<smsg> -- Message Data (pos2, OFF) --
			<bgno>
				<grou>
				r1s-
				<user>
				HARDWARE,SWITCH
			<endo>
		<endo>
		<subs> ---- subsystem entry ----
		crtu
		<bgno> ---- begin ----
			<unId>
			crtu
			<uNum>
			1
			<swch>
			r1s+
			<brgt>
			0.8
		<endo> ---- end ----
		<subs> - Subsystem entry -
		dpnd
		<bgno> - RTU On switch -
			<unId>
			r2s+
			<hwId>
			SWITCH
			<eBus>
			PS2_
		<endo> - end -
		<subs> - Subsystem entry -
		dpnd
		<bgno> - RTU On Light -
			<unId>
			r2l+
			<hwId>
			LIGHT
			<swch>
			r2s+
		<endo> - end -
		<subs> - Subsystem entry -
		dpnd
		<bgno> - RTU Off switch -
			<unId>
			r2s-
			<hwId>
			SWITCH
			<eBus>
			PS2_
		<endo> - end -
		<subs> - Subsystem entry -
		dpnd
		<bgno> - RTU Off Light -
			<unId>
			r2l-
			<hwId>
			LIGHT
			<swch>
			r2s-
		<endo> - end -
		<subs> - Subsystem entry -
		swst
		<bgno> - RTU 2 Power switch set -
			<unId> - unit id -
			rtu2
			<dflt> -- Default Switch Position --
			2
			<smsg> -- Message Data (pos 1, ON) --
			<bgno>
				<grou>
				r2s+
				<user>
				HARDWARE,SWITCH
			<endo>
			<smsg> -- Message Data (pos2, OFF) --
			<bgno>
				<grou>
				r2s-
				<user>
				HARDWARE,SWITCH
			<endo>
		<endo>
		<subs> ---- subsystem entry ----
		crtu
		<bgno> ---- begin ----
			<unId> 
			crtu
			<uNum> 
			2
			<swch> 
			r2s+
			<brgt> 
			0.8
		<endo> ---- end ----
		//
		//	Twin Engine Monitors
		//
		<subs> ---- subsystem entry ----
		aprs
		<bgno> ---- Automatic Performance Reserve ----
			<rpmO> -- RPM Option (0=rpm, 1=N1, 2=N2)
			1
			<rpmL> -- RPM Limit --
			10
			<lEng> -- Left Engine Number --
			1
			<rEng> -- Right Engine Number --
			2
		<endo> ---- end ----
		<subs> ---- subsystem entry ----
		rbia
		<bgno> ---- Rudder Bias ----
			<rpmO> -- RPM Option (0=rpm, 1=N1, 2=N2)
			1
			<rpmL> -- RPM Limit --
			10
			<lEng> -- Left Engine Number --
			1
			<rEng> -- Right Engine Number --
			2
			<bool>
			rbst
		<endo> ---- end ----
		<subs> ---- subsystem entry ----
		dpnd
		<bgno> ---- begin
			<unId>
			rbst
			<hwId>
			STATE
			<swch>
			rbs1
			<swch>
			rbs2
		<endo> ---- end 
		<subs> ---- subsystem entry ----
		dpnd
		<bgno> ---- begin
			<unId>
			rbs1
			<hwId>
			SWITCH
		<endo> ---- end 
		<subs> ---- subsystem entry ----
		dpnd
		<bgno> ---- begin
			<unId>
			rbs2
			<hwId>
			SWITCH
		<endo> ---- end 
		//
		//	Stall Ident (stick Push and Shake
		//
		<subs> ---- subsystem entry ----
		stlI
		<bgno> ---- Stall Ident ----
			<wing> -- Wing Section Name -
			Right w/Flap
		<endo> ---- end ----
		//
		//	Fast/Slow Meter
		//
		<subs> ---- subsystem entry ----
		fosm
		<bgno> ---- begin ----
			<wing> -- Wing Section Name -
			Right w/Flap
			<eBus>
			PEbs
		<endo> ---- end ----
		///////////////////////////////////////////////////
		//
		//	SELCAL
		//
		///////////////////////////////////////////////////
		<subs> - Subsystem entry -
		swst
		<bgno> - SELCAL Switch Set -
			<unId> - unit id -
			scSS
			<dflt> -- Default Switch Position --
			1
			<smsg> -- Message Data (pos 1, SELCAL 1) --
			<bgno>
				<grou>
				scl1
				<user>
				HARDWARE,SWITCH
			<endo>
			<smsg> -- Message Data (pos2, SELCAL 2) --
			<bgno>
				<grou>
				scl2
				<user>
				HARDWARE,SWITCH
			<endo>
			<eBus> -- Bus Circuit --
			PS1A
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - SELCAL 1 State (Pos 1) -
			<unId> - unit id -
			scl1
			<hwId> - hardware type -
			SWITCH
			<eBus> -- Bus Circuit --
			PS1A
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - SELCAL 2 State (Pos 2) -
			<unId> - unit id -
			scl2
			<hwId> - hardware type -
			SWITCH
			<eBus> -- Bus Circuit --
			PS1A
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - Phone Lav/Cabin switch -
			<unId> - unit id -
			phon
			<hwId> - hardware type -
			SWITCH
			<eBus> -- Bus Circuit --
			PS1A
		<endo>
		<subs> - Subsystem entry -
		dpnd
		<bgno> - FMS 1 Tuning Disable switch -
			<unId> - unit id -
			f1td
			<hwId> - hardware type -
			SWITCH
			<eBus> -- Bus Circuit --
			PS1A
		<endo>
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - FMS 1 Tuning Disable (amber) -
			f1ti
			<hwId>
			LIGHT
			<swch> -- MWS Test Switch --
			mwsT
			<swch> -- FMS 1 disable --
			f1td
		<endo> -- end annunciator --
		<subs> - Subsystem entry -
		dpnd
		<bgno> - FMS 2 Tuning Disable switch -
			<unId> - unit id -
			f2td
			<hwId> - hardware type -
			SWITCH
			<eBus> -- Bus Circuit --
			PS2A
		<endo>
		<subs> - Subsystem Entry -
		dpnd
		<bgno> -- begin annunciator --
			<unId> - FMS 2 Tuning Disable (amber) -
			f2ti
			<hwId>
			LIGHT
			<swch> -- MWS Test Switch --
			mwsT
			<swch> -- FMS 2 disable --
			f2td
		<endo> -- end annunciator --
		///////////////////////////////////////////////////
		//
		//	Flight Management Systems
		//
		///////////////////////////////////////////////////
		<subs> ---- subsystem entry ----
		ufms
		<bgno> ---- BEGIN OBJECT ----
			<unId> ---- unit id ----
			ufms
			<uNum> ---- unit number ----
			1
		<endo> ---- END OBJECT ----
		<subs> ---- subsystem entry ----
		ufms
		<bgno> ---- BEGIN OBJECT ----
			<unId> ---- unit id ----
			ufms
			<uNum> ---- unit number ----
			2
		<endo> ---- END OBJECT ----
		///////////////////////////////////////////////////
		//
		//	Altitude Alert
		//
		///////////////////////////////////////////////////
		<subs> - Subsystem Entry -
		annr
		<bgno> -- Altitude Alert Sound Annunciator --
			<unId> - Unit Id -
			piAA
			<fWAV> -- Wave File --
			altipres.wav
			<info>
			<bgno> -- begin Announcer Info --
				<anId> -- Unique Id of Announcing System --
				altA
				<bgno>
					<grou> ---- group ----
					pilo
					<user> ---- user data ----
					HARDWARE,OTHER
					<user> ---- user data ----
					UNIT,1
				<endo>
			<endo> -- end Announcer Info --
		<endo> -- end annunciator --
		<subs> - Subsystem Entry -
		annr
		<bgno> -- Altitude Alert Sound Annunciator --
			<unId> - Unit Id -
			coAA
			<fWAV> -- Wave File --
			altipres.wav
			<info>
			<bgno> -- begin Announcer Info --
				<anId> -- Unique Id of Announcing System --
				altA
				<bgno>
					<grou> ---- group ----
					copi
					<user> ---- user data ----
					HARDWARE,OTHER
					<user> ---- user data ----
					UNIT,1
				<endo>
			<endo> -- end Announcer Info --
		<endo> -- end annunciator --
	<endo> -- end Systems --

	///////////////////////////////////////////////////
	//
	//	Radio Manager
	//
	///////////////////////////////////////////////////

	<rdmn> ---- radio manager ----
	<bgno> ---- BEGIN OBJECT ----
		<rdio> ---- radio entry ----
		comm
		1
		<rdio> ---- radio entry ----
		comm
		2
		<rdio> ---- radio entry ----
		navi
		1
		<rdio> ---- radio entry ----
		navi
		2
		<rdio> ---- radio entry ----
		xpdr
		1
		<rdio> ---- radio entry ----
		xpdr
		2
		<rdio> ---- radio entry ----
		adfr
		1
		<rdio> ---- radio entry ----
		adfr
		2
		<rdio> ---- radio entry ----
		adio
		1
		<rdio> ---- radio entry ----
		adio
		2
		<rdio> ---- radio entry ----
		hifr
		1
		<rdio> ---- radio entry ----
		hifr
		2
		<rdio> ---- radio entry ----
		vgps
		1
	<endo> ---- END OBJECT ----
<endo> ========== END CAirplane OBJECT ==========

