# SMF_import (C) Copyright 2007 by Didier RIGAULT - ROTW Team
# Import SMF files for Fly!II
#

# // .SMF file format pseudo code (model version 4, part version 1)
# // Copyright (C) 2000 Terminal Reality Inc.

#   C3DModel      // string   : object type name
#   4                     // integer : version
#   63                   //  integer : part count
#   0,50                //  integer,real : use automatic detail, detail pixel height
# // part list
# for (part count) {
#         Eglise                  // string : part name
#         1                           // integer : part status (on/off)
#         1                           // integer : version
#         2095,1,1633,0    // integer,integer,integer,integer : vertex count, frame count, face count, dummy value (not used)
#         v1                          // string : optionnal
#         1,0.5,0.545981,0,1,msm1n.BMP  // real,real,real,integer,integer,string : diffuse light component, specular light component, specular light power,
#                                                                 // use transparency, use environment mapping, texture name
#         ""                          // ?          : optionnal
#         // vertex list
#         for (vertex count * frame count) {
#                 // real,real,real,real,real,real,real,real : vertex x, y, z, normal x, normal y, normal z, u, v
#         }
#         // face list
#         for (face count) {
#                 // integer,integer,integer : vertex 1 index, vertex 2 index, vertex 3 index
#         }
# }

require 'sketchup.rb'

def importSMF
  @entities = Sketchup.active_model.entities
  @layers = Sketchup.active_model.layers
  @groups = {}
  @vertices = []
  @faces = []
  @normals = []
  @uv = []
  $FEET2INCH = 12
  
  print("\nImport SMF to SU\n")
  materials = Sketchup.active_model.materials

  filename = UI.openpanel "Import SMF object","","*.SMF"
  return unless filename
  mainGroupName = File.basename(filename)
    
  line_cnt = 0
  lines = IO.readlines(filename)
  
  # entte du fichier -------------------------------------------------------------------------------------------------------------------------------
  object_type_name = lines[line_cnt]
  line_cnt += 1
  object_version = lines[line_cnt].to_i
  line_cnt += 1
  object_part_count = lines[line_cnt].to_i
  line_cnt += 1
  object_notused = lines[line_cnt]
  line_cnt += 1
  
  error_num = 0
  # parcours les objets => Sketchup.group
  while object_part_count > 0
   
    # rinitialise la liste des points
    @vertices = [] 
    @uv = []
    @normals = []
    
    # lis l'entte de l'objet  ----------------------------------------------------------------------------------------------------------------------
    object_part_name = lines[line_cnt]          # part name
    line_cnt += 1
    object_part_status = lines[line_cnt]        # part status
    line_cnt += 1
    object_part_version = lines[line_cnt]       # part version
    line_cnt += 1
    values = lines[line_cnt].split(',')

    object_part_vertexcount = values[0].to_i    # part vertex count
                                                # frame count not used
    object_part_facecount = values[2].to_i      # part face count
                                                # dummy value not used
    line_cnt += 1
     
    values = lines[line_cnt].split(',')
    if values[0][0] == 118                      # v1
      line_cnt += 1
      values = lines[line_cnt].split(',')
    end
    object_texture = values[5].strip!           #  texture name
    line_cnt += 1
    if lines[line_cnt][0] == 34                 # ligne vide ""
      line_cnt += 1
    end
    
    print("Name : ",object_part_name,
      "   V = ", object_part_vertexcount,
      " - F = ",object_part_facecount,
      " - T = ",object_texture,"\n")
    
    # cre l'object dans sketchup -------------------------------------------------------------------------------------------------------------------
    gname = object_part_name
    if( @groups[gname].nil? )
      layer = @layers.add gname
      Sketchup.active_model.active_layer = layer
      @groups[gname] =  Sketchup.active_model.entities.add_group
      @groups[gname].name = gname
    end
    @entities = @groups[gname].entities
    
    # vrifie l'existence de la texture
    extension = object_texture.split('.')
    if extension[1] == "RAW"
      object_texture = sprintf("%s.BMP",File.basename(object_texture, ".RAW"))
    end
    
    exist = false
    materials.each do | material |
      if material.name == object_texture
        mat = material
        exist = true
      end
    end
    # nouvelle texture ?
    if not exist
      mat = materials.add object_texture
      mat.texture = File.dirname(filename) + "\\" + object_texture
    end
    
    # lis les sommets
    premligne = line_cnt
    while object_part_vertexcount > 0
      vert = []
      #print sprintf("ligne %d : point %s", line_cnt+1,lines[line_cnt])
      values = lines[line_cnt].split(',')
      vert[0] = values[0].to_f * $FEET2INCH  # rouge
      vert[2] = values[1].to_f * $FEET2INCH  # vert 
      vert[1] = values[2].to_f * $FEET2INCH  # bleu
      @vertices.push vert
      normal = []
      # le systme d'axe de Fly! est diffrent de celui de Sketchup : 
      normal[0] = values[3].to_f
      normal[2] = values[4].to_f
      normal[1] = values[5].to_f
      @normals.push normal
      uv2 = []
      # le systme d'axe de Fly! est diffrent de celui de Sketchup : 
      uv2[0] = values[6].to_f
      uv2[1] = -values[7].to_f
      @uv.push uv2
      
      line_cnt += 1
      object_part_vertexcount -= 1
    end
    
    # lis les sommets et cre les faces
    # les informations sur la texture sont ajoutes
    count = 1
    while object_part_facecount > 0
      pts = []
      values = []
      values = lines[line_cnt].split(',')
      pts[0] = @vertices[values[0].to_i]
      pts[2] = @vertices[values[1].to_i]
      pts[1] = @vertices[values[2].to_i]
      
      begin
        face = @entities.add_face pts 
        texpoint = []
        texpoint.push pts[0]
        texpoint.push @uv[values[0].to_i]
        texpoint.push pts[2]
        texpoint.push @uv[values[1].to_i]
        texpoint.push pts[1]
        texpoint.push @uv[values[2].to_i]
        face.position_material mat, texpoint, true
             
      rescue
        error_num += 1
        # les faces non textures ou errones sont colores en rouge si possible
        @entities.add_edges pts[0],pts[1],pts[2],pts[0]
        puts $!
        puts sprintf("Erreur n %d face : %s en ligne %d = %d, %d, %d (%d, %d, %d)\n   %12.6f,%12.6f,%12.6f - uv = %12.6f,%12.6f\n   %12.6f,%12.6f,%12.6f - uv = %12.6f,%12.6f\n   %12.6f,%12.6f,%12.6f - uv = %12.6f,%12.6f\n\n",
          error_num,$!,line_cnt+1,values[0],values[1],values[2],
          values[0].to_i+premligne+1, values[1].to_i+premligne+1, values[2].to_i+premligne+1,
          pts[0][0],pts[0][1],pts[0][2], @uv[values[0].to_i][0], @uv[values[0].to_i][1],
          pts[1][0],pts[1][1],pts[1][2], @uv[values[1].to_i][0], @uv[values[1].to_i][1],
          pts[2][0],pts[2][1],pts[2][2], @uv[values[2].to_i][0], @uv[values[2].to_i][1])
       end
       
      line_cnt += 1
      object_part_facecount -= 1
      count += 1
    end
    object_part_count -= 1  
  end
end

scriptname = File.basename(__FILE__)
unless( file_loaded?( scriptname ))
  menu = UI.menu("Plugins")
  menu.add_item("Import SMF") { importSMF }
  file_loaded(scriptname)
end