# SMF_export (C) Copyright 2007 by Didier RIGAULT - ROTW Team
# Export SMF files for Fly!II
#

# // .SMF file format pseudo code (model version 4, part version 1)
# // Copyright (C) 2000 Terminal Reality Inc.

#   C3DModel      // string   : object type name
#   4                     // integer : version
#   63                   //  integer : part count
#   0,50                //  integer,real : use automatic detail, detail pixel height
# // part list
# for (part count) {
#         Eglise                  // string : part name
#         1                           // integer : part status (on/off)
#         1                           // integer : version
#         2095,1,1633,0    // integer,integer,integer,integer : vertex count, frame count, face count, dummy value (not used)
#         v1                          // string : optionnal
#         1,0.5,0.545981,0,1,msm1n.BMP  // real,real,real,integer,integer,string : diffuse light component, specular light component, specular light power,
#                                                                 // use transparency, use environment mapping, texture name
#         ""                          // ?          : optionnal
#         // vertex list
#         for (vertex count * frame count) {
#                 // real,real,real,real,real,real,real,real : vertex x, y, z, normal x, normal y, normal z, u, v
#         }
#         // face list
#         for (face count) {
#                 // integer,integer,integer : vertex 1 index, vertex 2 index, vertex 3 index
#         }
# }


#---------------------------------------------------------------------------------
def export_model_to_smf

  #Init
  model = Sketchup.active_model
  ss = Sketchup.active_model.selection
  model.start_operation "Export to SMF"
  $header = []
  $groups_array = []
  $faces_array = []
  $vertice_list = []
  $face_index = -1
  $object_header = []
  $face_list = []
  $entities = model.entities
  $FEET2INCH = 12
  
  # Selection checking ------------------------------------------------------------------------------------------------------------------------------
  if ss.empty? 
    answer = UI.messagebox("Nothing selected. Export whole model ?", MB_YESNOCANCEL)
  else
    $entities = Sketchup.active_model.selection
  end

  # Export whole model ?
  if( answer == 6 )
    $entities = model.entities
    # i = 0
    # 0.upto($entities.length - 1) do |something|
      # status = ss.add(entities_to_export[i]) 
      # i = i + 1
    # end
  end

  # Open output file --------------------------------------------------------------------------------------------------------------------------------
  out_name = UI.openpanel( "Select file to export to", "" , "_test.smf" )
  return unless out_name
  export_file = File.new( out_name , "w" )

  # Export selected groups --------------------------------------------------------------------------------------------------------------------------
  others = 0
  i = 0
  0.upto($entities.length - 1) do |something|
    element = $entities[i]
    if( element.typename != "Group")
      others = others + 1
    else
      $groups_array.push element
    end
    i = i + 1
  end
  
  $group_count = $groups_array.length
  puts sprintf("Il y a %d 'group'  exporter", $group_count)
  
  # En tte du fichier SMF
  write_header export_file
  
  $groups_array.each do |group|
    $group_name = group.name
    puts sprintf("  'group' en cours : %s", $group_name)
    group.explode
    groupToFace 
    #export
    (faceToFile export_file)
    Sketchup.undo
  end
  # Close the export file:
  export_file.close
  
  #Report message
  UI.messagebox sprintf("Group %d exported\n", $group_count)
end 
 
def write_header export_file
  #File Header
  $header.push "C3DModel"
  $header.push "4"
  $header.push $group_count
  $header.push "0,50.0"
  export_file.puts $header
end
  
def groupToFace
  $faces_array = []
  # Error checking, put valid elements in $faces_array
  others = 0
  i = 0
  $entities = Sketchup.active_model.entities
  0.upto($entities.length - 1) do |something|
    element = $entities[i]
    if( element.typename != "Face")
      others = others + 1
    else
      $faces_array.push element
    end
    i = i + 1
  end  #of upto
  puts sprintf("  - Faces avant triangulation : %d",$faces_array.length)
  
  #Triangulation ------------------------------------------------------------------------------------------------------------------
  $faces_array.each do |face|
    if not face.nil?
      points = face.vertices
      # print(points.length," points dans la face ")
      if points.length > 3
        # triangulation
        i = 2
        2.upto(points.length-1) do |something|
          $entities.add_line points[0], points[i]
          i += 1
        end
      end
    end
  end
  # Fin triangulation -------------------------------------------------------------------------------------------------------------------------------
  
  $faces_array = []
  i = 0
  0.upto($entities.length - 1) do |something|
    element = $entities[i]
    # puts "Face ? ",element.typename
    if( element.typename == "Face")
      $faces_array.push element
    end
    i = i + 1
  end  #of upto
  puts sprintf("  - Faces aprs triangulation : %d",$faces_array.length)
  
end

def faceToFile( export_file )
  $vertice_list = []
  $face_list = []

  puts sprintf("  - Faces  exporter : %d",$faces_array.length)
  texname  = "UNKNOWN.BMP"
  f = 1
  $faces_array.each do |face|
    if face.material
      mat = face.material
      if mat
        texname = mat.display_name
      end
      (export_smf_face face, export_file, true)
    end
    if face.back_material
      mat = face.back_material
      if mat
        texname = mat.display_name
      end     
      (export_smf_face face, export_file, false)
    end
    f += 1
  end
  
  extension = texname.split('.')
  if extension[1] != ".TIF"
    texname = sprintf("%s.RAW",File.basename(texname, ".BMP"))
  end

  puts sprintf("  - Texture : %s", texname)

  $object_header = []
  $object_header.push $group_name
  $object_header.push "1"
  $object_header.push "1"
  $object_header.push sprintf("%d,1,%d,0",$vertice_list.length,$face_list.length)
  $object_header.push sprintf("1.000000,1.000000,0.800000,0,1,%s", texname)
  
  export_file.puts $object_header
  export_file.puts $vertice_list
  export_file.puts $face_list
end
  
def export_smf_face( f, export_file, side )
  texture_writer = Sketchup.create_texture_writer
  normal = f.normal
  vertices = f.vertices
  
  i = 0
  index = []
  0.upto(vertices.length - 1) do |that|
    
    if side
      uvHelp = f.get_UVHelper(true, false, texture_writer)
      uvq = uvHelp.get_front_UVQ(vertices[i].position)
    else
      uvHelp = f.get_UVHelper(false, true, texture_writer)
      uvq = uvHelp.get_back_UVQ(vertices[i].position)
    end
    
    line = sprintf("%.6f,%.6f,%.6f,", vertices[i].position.x / $FEET2INCH, vertices[i].position.z / $FEET2INCH, vertices[i].position.y / $FEET2INCH)
    line = sprintf("%s%.6f,%.6f,%.6f,", line,normal[0], normal[2], normal[1])
    line = sprintf("%s%.6f,%.6f",line,uvq.x,-uvq.y)
    index[i] = $vertice_list.index line
    if index[i].nil?
      $vertice_list.push line
      index[i] = $vertice_list.index line
    end
    i += 1
  end
  
  line = sprintf("%d,%d,%d",index[0],index[2],index[1])
  $face_index += 3
  $face_list.push line
end


#---------------------------------------------------------------------------------
# Menu items
scriptname = File.basename(__FILE__)
unless( file_loaded?( scriptname ))
  menu = UI.menu("Plugins")
  menu.add_item("Export SMF") { export_model_to_smf }
  file_loaded(scriptname)
end

