// Document modified at : Saturday, October 12, 2002 9:47:10 AM , by user : Mr CLAUDET , from computer : ADJHA

/*
 *	P51CarbT.CPP
 *
 *
 */



#include <stdio.h>
#include <stdlib.h>
#include <string.h>   // For strncpy()



#define	FOR_EXPORT
#include "FlyDll.h"

/*
 * GLOBALS
 *
 */



SMessage carbMessage;
void GetCarb()
{	
	carbMessage.id = MSG_GETDATA;
	carbMessage.group = 'chSw';
	carbMessage.dataType = TYPE_INT;
	carbMessage.user.u.hw = HW_SWITCH;
	APISendMessage(&carbMessage);
}

SMessage oatMessage; // 
void GetOAT()
{	
		oatMessage.id = MSG_GETDATA;// 
		oatMessage.group = 'doat';	// 
		oatMessage.user.u.datatag = 'oatC';
		APISendMessage(&oatMessage);
}

SMessage CarbTMessage; // 
void SetCarbT(double x)
{

		CarbTMessage.id = MSG_SETDATA;
		CarbTMessage.group = 'p51c';
		CarbTMessage.dataType = TYPE_REAL;
		CarbTMessage.realData = x;
		APISendMessage(&CarbTMessage);
}

SMessage rpmMessage;
void GetRpm()
{	
	rpmMessage.id = MSG_GETDATA;
	rpmMessage.group = 'tach';
	rpmMessage.dataType = TYPE_REAL;
	rpmMessage.user.u.hw = HW_GAUGE;
	rpmMessage.user.u.unit = 1;
	APISendMessage(&rpmMessage);
}

SMessage oilTMessage;
void GetOilT()
{	
	oilTMessage.id = MSG_GETDATA;
	oilTMessage.group = 'oilT';
	oilTMessage.dataType = TYPE_REAL;
	oilTMessage.user.u.hw = HW_GAUGE;
	oilTMessage.user.u.unit = 1;
	APISendMessage(&oilTMessage);
}

SMessage ECHMessage;
void GetECH()
{	
	ECHMessage.id = MSG_GETDATA;
	ECHMessage.group = 'cool';
	ECHMessage.dataType = TYPE_REAL;
	ECHMessage.user.u.unit = 1;
	APISendMessage(&ECHMessage);
}


SMessage killMessage;
void kill(int pp = 0)
{
	killMessage.id = MSG_SETDATA;
	killMessage.group = 'kdll';	//'fOff';
	killMessage.intData = 0;
	APISendMessage(&killMessage);
	if (pp) { killMessage.intData = 1; APISendMessage(&killMessage); }
}

SMessage osswMessage;
void GetOssw()
{	
	osswMessage.id = MSG_GETDATA;
	osswMessage.group = 'feu0';
	osswMessage.dataType = TYPE_INT;
	osswMessage.user.u.hw = HW_SWITCH;
	APISendMessage(&osswMessage);
}

SMessage csswMessage;
void GetCssw()
{	
	csswMessage.id = MSG_GETDATA;
	csswMessage.group = 'css0';
	csswMessage.dataType = TYPE_INT;
	csswMessage.user.u.hw = HW_SWITCH;
	APISendMessage(&csswMessage);
}
/*
 * Local Functions
 *
 */


/**************************************************************************************/




/*
 * DLLKeyCallback
 *
 * This function is called whenever any of the keys that we have bound in via the
 * function APIBindKeyCallback are pressed by the user.
 *
 */



void	DLLInstantiate(const long type, const long id, SDLLObject **object)
{
	if ((type == TYPE_DLL_SYSTEM) && (id == 'p51c'))
	{
		*object = APICreateDLLObject();
		(**object).dllObject = APIAllocMem(sizeof(SMessage));
	}
}

void DLLInitObject(SDLLObject *object)
{
	memset(&CarbTMessage, 0, sizeof(SMessage));
	memset(&oatMessage, 0, sizeof(SMessage));
	memset(&carbMessage, 0, sizeof(SMessage));
	memset(&rpmMessage, 0, sizeof(SMessage));
	memset(&oilTMessage, 0, sizeof(SMessage));
	memset(&ECHMessage, 0, sizeof(SMessage));
	memset(&killMessage, 0, sizeof(SMessage));
	memset(&osswMessage, 0, sizeof(SMessage));
	memset(&csswMessage, 0, sizeof(SMessage));
}

void DLLDestroyObject(SDLLObject *object)
{
	APIFreeMem(object->dllObject);
}
/*
void	DLLIdle(float deltaTime)
{
	if(flag)
	{
		GetTHR();
		SetTHR1(thrMessage.realData);
	}


//	}
}
*/
void DLLTimeSlice(SDLLObject *object, const float deltaTimeSecs)
{
	double CarbGauge;
	GetOAT(); GetCarb(); GetECH();	//GetRpm(); GetOilT();
	GetOssw(); GetCssw();
	
	if(carbMessage.intData) CarbGauge = oatMessage.realData + ECHMessage.realData / 2;// + (osswMessage.intData / 2 + csswMessage.intData / 2);
	else CarbGauge = oatMessage.realData;
	SetCarbT(CarbGauge);

	if(CarbGauge < -20.0 || CarbGauge > 60.0) {kill();}

}

int	DLLInit(DLLFunctionRegistry *dll, SDLLCopyright *copyright, SDLLRegisterTypeList **types)
{
	//
	//	populate copyright info
	//

	strcpy(copyright->product, "P51CarbT DLL ROTW");
	strcpy(copyright->company, "ROTW");
	strcpy(copyright->programmer, "Laurent Claudet");
	strcpy(copyright->dateTimeVersion, "02/10/2002 1.00");
	strcpy(copyright->email, "@fr");
	copyright->internalVersion = 100;

	//
	//	return function pointers of available DLL functions
	//

	dll->DLLInstantiate = DLLInstantiate;
	dll->DLLTimeSlice = DLLTimeSlice;
	dll->DLLDestroyObject = DLLDestroyObject;
	dll->DLLInitObject = DLLInitObject;

	//	Define list of object types we can create


	APIAddRegisteredType(types, TYPE_DLL_SYSTEM, 'p51c');
	//
	//	result code
	//

	return(1);
}

void	DLLKill(void)
{
	//
	//	nothing mandatory to do here
	//	except internal cleanup
	//
}

