// P51 g_meter : ROTW 30/08/2002
//	<p_gm>
//------------------------------

#include <stdio.h>
#include <stdlib.h>
#include <string.h>   // For strncpy()



#define	FOR_EXPORT
#include "FlyDll.h"

#define G2FPS 30.27777

/*
 * GLOBALS
 *
 */


SFlyObjectRef user;
SVector bAccel;

void GetUserAircraftData()
{
	APIGetUserObject(&user);
	APIGetObjectBodyAcceleration(&user, &bAccel);
}

SMessage PGMMessage; // 
void SetPGM(double x)
{	
	PGMMessage.id = MSG_SETDATA;
	PGMMessage.group = 'p_gm';
	PGMMessage.user.u.datatag = 'indn';
	PGMMessage.dataType = TYPE_REAL;
	PGMMessage.realData = x;
	APISendMessage(&PGMMessage);
}

/*
 * Local Functions
 *
 */


/**************************************************************************************/




void	DLLInstantiate(const long type, const long id, SDLLObject **object)
{
	if ((type == TYPE_DLL_SYSTEM) && (id == 'p_gm'))
	{
		*object = APICreateDLLObject();
		(**object).dllObject = APIAllocMem(sizeof(SMessage));
	}
}

void DLLInitObject(SDLLObject *object)
{
	memset(&PGMMessage, 0, sizeof(SMessage));
}

void DLLDestroyObject(SDLLObject *object)
{
	APIFreeMem(object->dllObject);
}

void	DLLTimeSlice(SDLLObject *object, const float deltaTimeSecs)
{
	GetUserAircraftData();

	SetPGM(bAccel.y / G2FPS);
	
	// ///////////////// remove later ////////////////////////////////
//	 char buffer[32];
	// GetTest(); 
	// sprintf(buffer, "%d %d", message->intData, PADFMessage.intData);
//	 sprintf(buffer, "%f", PGMMessage.realData);
//	 APIDrawNoticeToUser(buffer,10);
	// ///////////////// remove later ////////////////////////////////
}

int	DLLInit(DLLFunctionRegistry *dll, SDLLCopyright *copyright, SDLLRegisterTypeList **types)
{
	//
	//	populate copyright info
	//

	strcpy(copyright->product, "P51 g-meter DLL");
	strcpy(copyright->company, "ROTW");
	strcpy(copyright->programmer, "LC");
	strcpy(copyright->dateTimeVersion, "30/08/2002 1.00");
	strcpy(copyright->email, "??@??");
	copyright->internalVersion = 100;

	//
	//	return function pointers of available DLL functions
	//

	dll->DLLInstantiate = DLLInstantiate;
	dll->DLLTimeSlice = DLLTimeSlice;
	dll->DLLDestroyObject = DLLDestroyObject;
	dll->DLLInitObject = DLLInitObject;

	//	Define list of object types we can create


	APIAddRegisteredType(types, TYPE_DLL_SYSTEM, 'p_gm');

	//
	//	result code
	//

	return(1);
}

void	DLLKill(void)
{
	//
	//	nothing mandatory to do here
	//	except internal cleanup
	//
}

