
/*
 *	P51GAUGEADF.CPP
 *
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>   // For strncpy()



#define	FOR_EXPORT
#include "FlyDll.h"


/*
 * GLOBALS
 *
 */
int n1 = 0, n2 = 0, n3 = 0, n4 = 0;
static SBitmap bitmap;

SFlyObjectRef user;

float freqADF;

void GetUserAircraftData()
{
	APIGetUserObject(&user);
//	freqADF = APIGetTunedFreq(&user, RADIO_ADF, 1, FREQ_ACTIVE);
}

/*
 * Local Functions
 *
 */

typedef struct DLLStorage
{
	SMessage message;

}DLLStorage;

//SFont drawFont;


/**************************************************************************************/




/*
 * DLLKeyCallback
 *
 * This function is called whenever any of the keys that we have bound in via the
 * function APIBindKeyCallback are pressed by the user.
 *
 */



void	DLLInstantiate(const long type, const long id, SDLLObject **object)
{
	//  Instantiate the Chase camera when asked.  There is no instance-specific
	//  data, so just put the camera identifier 'chas' into the *object->dllObject
	//  member.
	//
	//  Note that cameras are typically only instantiated once, either when the
	//  aircraft SVH file is parsed (in particular, if there is an entry in the
	//  <cmgr> section for the camera) or in the case of this DLL, in the
	//  DLLStartSituation callback.  Rather than create those global variables
	//  above, it is usually better to allocate the required storage when the
	//  object is instantiated, and put a pointer to the storage in the dllObject
	//  member.

	if ((type == TYPE_DLL_GAUGE) && (id == 'gadf'))
	{
		*object = APICreateDLLObject();
		(**object).dllObject = APIAllocMem(sizeof(DLLStorage));
	}
}

void DLLDestroyObject(SDLLObject *object)
{
	APIFreeMem(object->dllObject);
}

EClickResult DLLMouseClick(SDLLObject *object, SSurface *surface, int mouseX, int mouseY, int mouseButtons)
{
	DLLStorage* storage = (DLLStorage*) object->dllObject;

	GetUserAircraftData();
	enum {digit1 = 0, digit2 = 1, digit3 = 2, digit4 =3};
	enum {Increment = 0, Decrement = 4};
	unsigned int mode = digit1 | Increment;
	
	int quarterWidth = surface->xSize / 4;
	if (mouseX > quarterWidth && mouseX < 2 * quarterWidth) {mode |= digit2;}
	if (mouseX > 2 * quarterWidth && mouseX < 3 * quarterWidth) {mode |= digit3;}
	if (mouseX > 3 * quarterWidth && mouseX) {mode |= digit4;}

	if(mouseButtons == MOUSE_BUTTON_RIGHT) {mode |= Decrement;}

	switch (mode)
	{
	case 0 :
		n1 += 1;
		if(n2 > 1 && n1 == 2) n1 = 0;
		else n1 -=1;
		break;
	case 1 :
		n2 += 1;
		if(n1 && n2 == 8) n2 = 0;
		else if(n2 == 10) n2 = 2;
		break;
	case 2 :
		n3 += 1;
		if(n3 == 10) n3 = 0;
		break;
	case 3 :
		n4 += 1;
		if(n4 == 10) n4 = 0;
		break;
	case 4 :
		n1 -= 1;
		if(n2 < 8 && n1 == -1) n1 = 1;
		else n1 += 1;
		break;
	case 5 :
		n2 -= 1;
		if(n1 && n2 == -1) n2 = 7;
		if(!n1 && n2 == 1) n2 = 9;
		break;
	case 6 :
		n3 -= 1;
		if(n3 == -1) n3 = 9;
		break;
	case 7 :
		n4 -= 1;
		if(n4 == -1) n4 = 9;
		break;
	}

	///////////////// remove later ////////////////////////////////
	// char buffer[16];
	// sprintf(buffer, "%d %d %d %d", n1, n2, n3, n4);
	// APIDrawNoticeToUser(buffer,10);
	///////////////// remove later ////////////////////////////////

	APITuneRadio(&user, RADIO_ADF, 1, n1 * 1000 + n2 * 100 + n3 * 10 + n4);

	return MOUSE_TRACKING_ON;
}

void DLLDraw(SDLLObject *ref, SSurface *surface)
{
	DLLStorage* storage = (DLLStorage*) ref->dllObject;

	APIEraseSurface(surface);
	APIDrawBitmap(surface, &bitmap, 0, 0, 0);
/*	char buffer[16];
	sprintf(buffer, "%d", 1256);
	APIDrawText(surface, &drawFont, 0, 0, APIMakeRGB(255, 0, 255), buffer);
*/
	APIBlitTransparent(surface, APIMakeRGB(0,0,0));	//	(SSurface *surface, unsigned int rgbTransparentColor); 
}

int	DLLInit(DLLFunctionRegistry *dll, SDLLCopyright *copyright, SDLLRegisterTypeList **types)
{
	//
	//	populate copyright info
	//

	strcpy(copyright->product, "P51GAUGEADF DLL");
	strcpy(copyright->company, "ROTW");
	strcpy(copyright->programmer, "LC");
	strcpy(copyright->dateTimeVersion, "16/08/2002 1.00");
	strcpy(copyright->email, "??@bad.e-mail");
	copyright->internalVersion = 100;

	//
	//	return function pointers of available DLL functions
	//

	dll->DLLInstantiate = DLLInstantiate;
	dll->DLLDraw = DLLDraw;
	dll->DLLDestroyObject = DLLDestroyObject;
	dll->DLLMouseClick = DLLMouseClick;


	strcpy(bitmap.bitmapName, "P51ADF.pbm");
	APILoadBitmap(&bitmap);
	
	//	Define list of object types we can create


	APIAddRegisteredType(types, TYPE_DLL_GAUGE, 'gadf');
	//
	//	result code
	//

	return(1);
}

void	DLLKill(void)
{
	//
	//	nothing mandatory to do here
	//	except internal cleanup
	//
	APIFreeBitmap(&bitmap);
}

