
/*
 *	P51GAUGECOM.CPP
 *
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>   // For strncpy()



#define	FOR_EXPORT
#include "FlyDll.h"


/*
 * GLOBALS
 *
 */
unsigned int cent = 118;
float diz = 0.0;
static SBitmap bitmap;

SFlyObjectRef user;

void GetUserAircraftData()
{
	APIGetUserObject(&user);
}			

/*
 * Local Functions
 *
 */

typedef struct DLLStorage
{
	SMessage message;

}DLLStorage;

/**************************************************************************************/

void	DLLInstantiate(const long type, const long id, SDLLObject **object)
{
	if ((type == TYPE_DLL_GAUGE) && (id == 'gcom'))
	{
		*object = APICreateDLLObject();
		(**object).dllObject = APIAllocMem(sizeof(DLLStorage));
	}
}

void DLLDestroyObject(SDLLObject *object)
{
	APIFreeMem(object->dllObject);
}

EClickResult DLLMouseClick(SDLLObject *object, SSurface *surface, int mouseX, int mouseY, int mouseButtons)
{
	DLLStorage* storage = (DLLStorage*) object->dllObject;

	GetUserAircraftData();

	if(mouseButtons == MOUSE_BUTTON_RIGHT) {diz += 2.5; if(diz > 99.9) diz = 0;}
	if(mouseButtons == MOUSE_BUTTON_LEFT) {cent += 1; if(cent > 136) cent = 118;}

	///////////////// remove later ////////////////////////////////
//	 char buffer[16];
//	 sprintf(buffer, "%d %f", cent, diz);
//	 APIDrawNoticeToUser(buffer,10);
	///////////////// remove later ////////////////////////////////

	APITuneRadio(&user, RADIO_COM, 1, (float)cent + diz / 100);
	return MOUSE_TRACKING_ON;
}

void DLLDraw(SDLLObject *ref, SSurface *surface)
{
	DLLStorage* storage = (DLLStorage*) ref->dllObject;

	APIEraseSurface(surface);

	APIDrawBitmap(surface, &bitmap, 0, 0, 0);
	APIBlitTransparent(surface, APIMakeRGB(0,0,0));
}

int	DLLInit(DLLFunctionRegistry *dll, SDLLCopyright *copyright, SDLLRegisterTypeList **types)
{
	//
	//	populate copyright info
	//

	strcpy(copyright->product, "P51GAUGECOM DLL");
	strcpy(copyright->company, "ROTW");
	strcpy(copyright->programmer, "LC");
	strcpy(copyright->dateTimeVersion, "21/08/2002 1.00");
	strcpy(copyright->email, "??@bad.e-mail");
	copyright->internalVersion = 100;

	//
	//	return function pointers of available DLL functions
	//

	dll->DLLInstantiate = DLLInstantiate;
	dll->DLLDraw = DLLDraw;
	dll->DLLDestroyObject = DLLDestroyObject;
	dll->DLLMouseClick = DLLMouseClick;

	strcpy(bitmap.bitmapName, "P51COM.pbm");
	APILoadBitmap(&bitmap);
	
	//	Define list of object types we can create


	APIAddRegisteredType(types, TYPE_DLL_GAUGE, 'gcom');
	//
	//	result code
	//

	return(1);
}

void	DLLKill(void)
{
	//
	//	nothing mandatory to do here
	//	except internal cleanup
	//
	APIFreeBitmap(&bitmap);
}

