
/*
 *	P51 Hydraulic System Operation.CPP
 *
 *
 */


#include <stdio.h>
#include <stdlib.h>
#include <string.h>   // For strncpy()
#include <time.h>

#define	FOR_EXPORT
#include "FlyDll.h"

/*
 * GLOBALS
 *
 */

time_t temps_actuel;
time_t temps_debut;
int flag = 1;

int HP = 800;
int old_flap;

SMessage suctMessage; //
void GetSuct()
{	
	suctMessage.id = MSG_GETDATA;
	suctMessage.group = 'suct';
	suctMessage.user.u.datatag = 'indn';
	APISendMessage(&suctMessage);
}

SMessage HysoMessage; //
void SetHyso(int x)
{	
	HysoMessage.id = MSG_SETDATA;
	HysoMessage.group = 'hyso';
	HysoMessage.user.u.datatag = 'indn';
	HysoMessage.dataType = TYPE_INT;
	HysoMessage.intData = x;
	APISendMessage(&HysoMessage);
}


/*
 * Local Functions
 *
 */


/**************************************************************************************/




/*
 * DLLKeyCallback
 *
 * This function is called whenever any of the keys that we have bound in via the
 * function APIBindKeyCallback are pressed by the user.
 *
 */



void	DLLInstantiate(const long type, const long id, SDLLObject **object)
{
	if ((type == TYPE_DLL_SYSTEM) && (id == 'hyso'))
	{
		*object = APICreateDLLObject();
		(**object).dllObject = APIAllocMem(sizeof(SMessage));
	}
}

void DLLInitObject(SDLLObject *object)
{
	memset(&HysoMessage, 0, sizeof(SMessage));
	memset(&suctMessage, 0, sizeof(SMessage));
}

void DLLDestroyObject(SDLLObject *object)
{
	APIFreeMem(object->dllObject);
}

void	DLLTimeSlice(SDLLObject *object, const float deltaTimeSecs)
{
	SMessage *message = (SMessage *) object->dllObject;
	APISendMessage(message);
	GetSuct();
	
	int flap = message->intData - old_flap;
	if(flap && flag) {time(&temps_debut); flag = 0;}

	if(suctMessage.realData < 0.75 && flap) {HP = 0; flag = 1;}
	if(suctMessage.realData > 2.0)
	{
		if(flap) 
		{
			HP = 850;
			time(&temps_actuel);
			if(difftime(temps_actuel, temps_debut) > 5.0) flag = 1;
		}
		else HP = 1050;
	}
	

	SetHyso(HP);
	if(flag) old_flap = message->intData;

#ifdef _DEBUG	
	///////////////// remove later ////////////////////////////////
	char buffer[128];
	sprintf(buffer, "%d-%.2f-%d", message->intData, suctMessage.realData, flag);
	APIDrawNoticeToUser(buffer,10);
	///////////////// remove later ////////////////////////////////
#endif
}

int DLLRead(SDLLObject *object, SStream *stream, unsigned int tag)
{
	SMessage *message = (SMessage *) object->dllObject;
	int result = TAG_READ;

	switch(tag)
	{
	case 'mes1' :
		APIReadMessage(message, stream);
		message->id = MSG_GETDATA;
		break;

	default:
		result = TAG_IGNORED;
	}

	return(result);
}

int	DLLInit(DLLFunctionRegistry *dll, SDLLCopyright *copyright, SDLLRegisterTypeList **types)
{
	//
	//	populate copyright info
	//

	strcpy(copyright->product, "P51HydSystem DLL ROTW");
	strcpy(copyright->company, "ROTW");
	strcpy(copyright->programmer, "LC");
	strcpy(copyright->dateTimeVersion, "12/10/2002 1.00");
	strcpy(copyright->email, "x@y.z");
	copyright->internalVersion = 100;

	//
	//	return function pointers of available DLL functions
	//

	dll->DLLInstantiate = DLLInstantiate;
	dll->DLLRead = DLLRead;
	dll->DLLTimeSlice = DLLTimeSlice;
	dll->DLLDestroyObject = DLLDestroyObject;
	dll->DLLInitObject = DLLInitObject;

	//	Define list of object types we can create


	APIAddRegisteredType(types, TYPE_DLL_SYSTEM, 'hyso');
	//
	//	result code
	//

	return(1);
}

void	DLLKill(void)
{
	//
	//	nothing mandatory to do here
	//	except internal cleanup
	//
}

