
/*
	///////////////////////////////////////
	//
	//	AMP file add lines
	//
	///////////////////////////////////////

	<subs> --  --
	pcom
	<bgno>
		<unId>
		pcom
	<endo>

 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>   // For strncpy()


#define	FOR_EXPORT
#include "FlyDll.h"

/*
 * GLOBALS
 *
 */

char buffer[128];

SFlyObjectRef user;
float freqCOM; // active

void GetUserAircraftData()
{
	APIGetUserObject(&user);
	freqCOM = APIGetTunedFreq(&user, RADIO_COM, 1, FREQ_ACTIVE) * 100;
}

SMessage PCOMMessage; // 
void SetPCOM(int x)
{	
	PCOMMessage.id = MSG_SETDATA;
	PCOMMessage.group = 'pcom';
	PCOMMessage.user.u.datatag = 'indn';
	PCOMMessage.dataType = TYPE_INT;
	PCOMMessage.intData = x;
	APISendMessage(&PCOMMessage);
}

/*
 * Local Functions
 *
 */


/**************************************************************************************/




void	DLLInstantiate(const long type, const long id, SDLLObject **object)
{
	if ((type == TYPE_DLL_SYSTEM) && (id == 'pcom'))
	{
		*object = APICreateDLLObject();
		(**object).dllObject = APIAllocMem(sizeof(SMessage));
	}
}

void DLLInitObject(SDLLObject *object)
{
	memset(&PCOMMessage, 0, sizeof(SMessage));
}

void DLLDestroyObject(SDLLObject *object)
{
	APIFreeMem(object->dllObject);
}

void	DLLTimeSlice(SDLLObject *object, const float deltaTimeSecs)
{
	GetUserAircraftData();
	SetPCOM((int)freqCOM);

	// ///////////////// remove later ////////////////////////////////
//	 char buffer[32];
	// GetTest(); 
	// sprintf(buffer, "%d %d", message->intData, PADFMessage.intData);
//	 sprintf(buffer, "%f %f", freqCOM, PCOMMessage.intData);
//	 APIDrawNoticeToUser(buffer,10);
	// ///////////////// remove later ////////////////////////////////
}

int	DLLInit(DLLFunctionRegistry *dll, SDLLCopyright *copyright, SDLLRegisterTypeList **types)
{
	//
	//	populate copyright info
	//

	strcpy(copyright->product, "P51RADIOCOM1 DLL");
	strcpy(copyright->company, "ROTW");
	strcpy(copyright->programmer, "LC");
	strcpy(copyright->dateTimeVersion, "21/08/2002 1.00");
	strcpy(copyright->email, "??@??");
	copyright->internalVersion = 100;

	//
	//	return function pointers of available DLL functions
	//

	dll->DLLInstantiate = DLLInstantiate;
	dll->DLLTimeSlice = DLLTimeSlice;
	dll->DLLDestroyObject = DLLDestroyObject;
	dll->DLLInitObject = DLLInitObject;

	//	Define list of object types we can create


	APIAddRegisteredType(types, TYPE_DLL_SYSTEM, 'pcom');

	//
	//	result code
	//

	return(1);
}

void	DLLKill(void)
{
	//
	//	nothing mandatory to do here
	//	except internal cleanup
	//
}

