
/*
	///////////////////////////////////////
	//
	//	AMP file add lines
	//
	///////////////////////////////////////

	<subs> --  --
	pcsb
	<bgno>
		<unId>
		pcsb
	<endo>

 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>   // For strncpy()


#define	FOR_EXPORT
#include "FlyDll.h"

/*
 * GLOBALS
 *
 */

char buffer[128];

SFlyObjectRef user;
float freqCOMSB; // active and stand-by

void GetUserAircraftData()
{
	APIGetUserObject(&user);
	freqCOMSB = APIGetTunedFreq(&user, RADIO_COM, 1, FREQ_STANDBY) * 100;
}

SMessage PCOMSBMessage; // 
void SetPCOMSB(int x)
{	
	PCOMSBMessage.id = MSG_SETDATA;
	PCOMSBMessage.group = 'pcsb';
	PCOMSBMessage.user.u.datatag = 'indn';
	PCOMSBMessage.dataType = TYPE_INT;
	PCOMSBMessage.intData = x;
	APISendMessage(&PCOMSBMessage);
}
/*
 * Local Functions
 *
 */


/**************************************************************************************/




void	DLLInstantiate(const long type, const long id, SDLLObject **object)
{
	if ((type == TYPE_DLL_SYSTEM) && (id == 'pcsb'))
	{
		*object = APICreateDLLObject();
		(**object).dllObject = APIAllocMem(sizeof(SMessage));
	}
}

void DLLInitObject(SDLLObject *object)
{
	memset(&PCOMSBMessage, 0, sizeof(SMessage));
}

void DLLDestroyObject(SDLLObject *object)
{
	APIFreeMem(object->dllObject);
}

void	DLLTimeSlice(SDLLObject *object, const float deltaTimeSecs)
{
	GetUserAircraftData();
	SetPCOMSB((int)freqCOMSB);	

#ifdef _DEBUG	
	// ///////////////// remove later ////////////////////////////////
	 char buffer[32];
	 sprintf(buffer, "%s %f %f", "test", freqCOMSB, PCOMSBMessage.intData);
	 APIDrawNoticeToUser(buffer,10);
	// ///////////////// remove later ////////////////////////////////
#endif
}

int	DLLInit(DLLFunctionRegistry *dll, SDLLCopyright *copyright, SDLLRegisterTypeList **types)
{
	//
	//	populate copyright info
	//

	strcpy(copyright->product, "P51RADIOCOMSB DLL");
	strcpy(copyright->company, "ROTW");
	strcpy(copyright->programmer, "LC");
	strcpy(copyright->dateTimeVersion, "08/12/2002 1.00");
	strcpy(copyright->email, "??@??");
	copyright->internalVersion = 100;

	//
	//	return function pointers of available DLL functions
	//

	dll->DLLInstantiate = DLLInstantiate;
	dll->DLLTimeSlice = DLLTimeSlice;
	dll->DLLDestroyObject = DLLDestroyObject;
	dll->DLLInitObject = DLLInitObject;

	//	Define list of object types we can create


	APIAddRegisteredType(types, TYPE_DLL_SYSTEM, 'pcsb');

	//
	//	result code
	//

	return(1);
}

void	DLLKill(void)
{
	//
	//	nothing mandatory to do here
	//	except internal cleanup
	//
}

