/*
	///////////////////////////////////////
	//
	//	AMP file add lines
	//
	///////////////////////////////////////

	<subs> --
	ptdr
	<bgno>
		<unId>
		ptdr
		<hwId> ---- hardware ----
		GAUGE
		<fuse> ---- circuit breaker ----
		adf1
		<load> - circuit load (amps) -
		2
	<endo>

 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>   // For strncpy()


#define	FOR_EXPORT
#include "FlyDll.h"

/*
 * GLOBALS
 *
 */

char buffer[128];

SFlyObjectRef user;
float freqTRPD;

void GetUserAircraftData()
{
	APIGetUserObject(&user);
	freqTRPD = APIGetTunedFreq(&user, RADIO_XPDR, 1, FREQ_ACTIVE);

}

SMessage PTPRDMessage; // 
void SetPTPRD(float x)
{	
	PTPRDMessage.id = MSG_SETDATA;
	PTPRDMessage.group = 'ptdr';
	PTPRDMessage.user.u.datatag = 'indn';
	PTPRDMessage.dataType = TYPE_REAL;
	PTPRDMessage.realData = x;
	APISendMessage(&PTPRDMessage);
}

/*
 * Local Functions
 *
 */


/**************************************************************************************/




/*
 * DLLKeyCallback
 *
 * This function is called whenever any of the keys that we have bound in via the
 * function APIBindKeyCallback are pressed by the user.
 *
 */



void	DLLInstantiate(const long type, const long id, SDLLObject **object)
{
	if ((type == TYPE_DLL_SYSTEM) && (id == 'ptdr'))
	{
		*object = APICreateDLLObject();
		(**object).dllObject = APIAllocMem(sizeof(SMessage));
	}
}

void DLLInitObject(SDLLObject *object)
{
	memset(&PTPRDMessage, 0, sizeof(SMessage));
}

void DLLDestroyObject(SDLLObject *object)
{
	APIFreeMem(object->dllObject);
}

void	DLLTimeSlice(SDLLObject *object, const float deltaTimeSecs)
{

	GetUserAircraftData();
	SetPTPRD(freqTRPD);

#ifdef _DEBUG	
	char buffer[128] = {0};
	sprintf(buffer,
         "%.5f",
		 freqTRPD);
	APIDrawNoticeToUser(buffer,10);
#endif
}

int	DLLInit(DLLFunctionRegistry *dll, SDLLCopyright *copyright, SDLLRegisterTypeList **types)
{
	//
	//	populate copyright info
	//

	strcpy(copyright->product, "P51RADIOTRPD DLL");
	strcpy(copyright->company, "ROTW");
	strcpy(copyright->programmer, "LC");
	strcpy(copyright->dateTimeVersion, "21/11/2002 1.00");
	strcpy(copyright->email, "??@??");
	copyright->internalVersion = 100;

	//
	//	return function pointers of available DLL functions
	//

	dll->DLLInstantiate = DLLInstantiate;
	dll->DLLTimeSlice = DLLTimeSlice;
	dll->DLLDestroyObject = DLLDestroyObject;
	dll->DLLInitObject = DLLInitObject;

	//	Define list of object types we can create


	APIAddRegisteredType(types, TYPE_DLL_SYSTEM, 'ptdr');
	//
	//	result code
	//

	return(1);
}

void	DLLKill(void)
{
	//
	//	nothing mandatory to do here
	//	except internal cleanup
	//
}

