unit traitements_images;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, fonctions_images, Buttons, FileCtrl, ComCtrls;

type
  Ttraitement_Images = class(TForm)
    liste: TListBox;
    Button1: TButton;
    renommer: TButton;
    Trier: TButton;
    GroupBox1: TGroupBox;
    SpeedButton2: TSpeedButton;
    Button3: TButton;
    Button4: TButton;
    Button6: TButton;
    Directory: TDirectoryListBox;
    cDrive: TDriveComboBox;
    Dialog_file: TOpenDialog;
    GroupBox2: TGroupBox;
    Label1: TLabel;
    GroupBox3: TGroupBox;
    GroupBox4: TGroupBox;
    GroupBox5: TGroupBox;
    GroupBox6: TGroupBox;
    ck_image1: TCheckBox;
    ck_image2: TCheckBox;
    ck_image3: TCheckBox;
    ck_image4: TCheckBox;
    Directorysav: TDirectoryListBox;
    Drivesav: TDriveComboBox;
    init_liste_scan: TCheckBox;
    avancement: TProgressBar;
    info: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure trierClick(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure cDriveChange(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
    procedure Dialog_fileCanClose(Sender: TObject; var CanClose: Boolean);
    procedure renommerClick(Sender: TObject);
    procedure DrivesavChange(Sender: TObject);
  private
    { Dclarations prives }
  public
    { Dclarations publiques }
  end;

var
  traitement_Images: Ttraitement_Images;

implementation

{$R *.DFM}

procedure Ttraitement_Images.Button1Click(Sender: TObject);
var
Bitmap : TBitMap;
res1 : TBitMap;
res2 : TBitMap;
res3 : TBitMap;
res4 : TBitMap;
X,Z : Integer;
Hauteur_image : Integer;
Largeur_image : Integer;
Nb_images : integer;
cote_bitmap : Integer;
superposition : Integer;
I : Integer;
Path_sav : String;
debug : boolean;

begin
debug := false;
info.caption := 'Avancement';
Hauteur_image := 7696;
Largeur_image := Hauteur_image;
cote_bitmap := 240;
superposition := 16;
Nb_images := (Hauteur_image - superposition) div cote_bitmap;
Bitmap := TBitmap.Create;
Bitmap.PixelFormat := pf16bit;
Path_sav := trim(Directorysav.GetItemPath(Directorysav.ItemIndex))+'\';

if ck_image1.Checked Then
begin
   res1 := TBitmap.Create;
   res1.PixelFormat := pf16bit;
   res1.width:= largeur_image;
   res1.height:= Hauteur_image;
end;

if ck_image2.Checked Then
begin
   res2 := TBitmap.Create;
   res2.PixelFormat := pf16bit;
   res2.width:= largeur_image;
   res2.height:= Hauteur_image;
end;

if ck_image3.Checked Then
begin
   res3 := TBitmap.Create;
   res3.PixelFormat := pf16bit;
   res3.width:= largeur_image;
   res3.height:= Hauteur_image;
end;

if ck_image4.Checked Then
begin
   res4 := TBitmap.Create;
   res4.PixelFormat := pf16bit;
   res4.width:= largeur_image;
   res4.height:= Hauteur_image;
end;

avancement.max := liste.items.Count;

For I:=0 to ( liste.items.Count -1 ) do
begin
     BitMap.LoadFromFile(liste.items[I]);
     calcul_coordonnees ( liste.items[I],X ,Z,debug);

     // dtermination de l'image
     case recherche_image ( X,Z,debug) of
          1 : If  ck_image1.Checked Then res1.Canvas.Draw(( (X)*cote_bitmap),(hauteur_image-((Z+1-Nb_images)*cote_bitmap + superposition) ),BitMap);
          2 : If  ck_image2.Checked Then res2.Canvas.Draw(( (X-Nb_images)*cote_bitmap),(hauteur_image-((Z+1 -Nb_images)*cote_bitmap + superposition ) ),BitMap);
          3 : If  ck_image3.Checked Then res3.Canvas.Draw(( (X)*cote_bitmap),(hauteur_image-((Z+1)*cote_bitmap + superposition ) ),BitMap);
          4 : If  ck_image4.Checked Then res4.Canvas.Draw(( (X-Nb_images)*cote_bitmap),(hauteur_image-((Z+1)*cote_bitmap + superposition) ),BitMap);
     end;
     avancement.stepit;
end;

Bitmap.Free;
avancement.max := 0;
info.caption := 'Enregistrement...';

If ck_image1.Checked Then avancement.max := avancement.max + 1;
If ck_image2.Checked Then avancement.max := avancement.max + 1;
If ck_image3.Checked Then avancement.max := avancement.max + 1;
If ck_image4.Checked Then avancement.max := avancement.max + 1;

info.repaint;

if ck_image1.Checked Then
begin
     res1.saveToFile(Path_sav+'image1.bmp') ;
     res1.free;
     avancement.stepit;
end;

if ck_image2.Checked Then
begin
     res2.saveToFile(Path_sav+'image2.bmp') ;
     res2.free;
     avancement.stepit;
end;

if ck_image3.Checked Then
begin
     res3.saveToFile(Path_sav+'image3.bmp') ;
     res3.free;
     avancement.stepit;
end;

if ck_image4.Checked Then
begin
    res4.saveToFile(Path_sav+'image4.bmp') ;
    res4.free;
    avancement.stepit;
end;

ShowMessage('Traitement Termin');
avancement.max:=0;
info.caption := 'Avancement';
end;

procedure Ttraitement_Images.trierClick(Sender: TObject);

var
Bitmap : TBitMap;
X,Z : Integer;
I : Integer;
Path_sav : String;
Nom_fichier : String;
debug : boolean;
begin
debug := false ;
info.caption := 'Avancement';
Bitmap := TBitmap.Create;
Bitmap.PixelFormat := pf32bit;
Path_sav := trim(Directorysav.GetItemPath(Directorysav.ItemIndex))+'\';

If ck_image1.Checked and Not DirectoryExists( Path_sav +'image1' ) Then
   CreateDir (Path_sav+'image1');

If ck_image2.Checked and Not DirectoryExists( Path_sav +'image2' ) Then
   CreateDir (Path_sav+'image2');

If ck_image3.Checked and Not DirectoryExists( Path_sav +'image3' ) Then
   CreateDir (Path_sav+'image3');

If ck_image4.Checked and Not DirectoryExists( Path_sav +'image4' ) Then
   CreateDir (Path_sav+'image4');

avancement.max := liste.items.Count;
For I:=0 to ( liste.items.Count -1 ) do
begin
     BitMap.LoadFromFile(liste.items[I]);
     calcul_coordonnees ( liste.items[I],X ,Z,debug);
     Nom_fichier := liste.items[I];
     while Pos ('\',Nom_fichier ) > 0  do
     begin
           delete ( Nom_fichier, 1,pos ('\',Nom_fichier ));
     End;
     If debug Then showmessage (Nom_fichier);

     // dtermination de l'image
     case recherche_image ( X,Z, debug) of
          1 : If  ck_image1.Checked Then BitMap.saveToFile(Path_sav +'image1\'+Nom_fichier);
          2 : If  ck_image2.Checked Then BitMap.saveToFile(Path_sav +'image2\'+Nom_fichier);
          3 : If  ck_image3.Checked Then BitMap.saveToFile(Path_sav +'image3\'+Nom_fichier);
          4 : If  ck_image4.Checked Then BitMap.saveToFile(Path_sav +'image4\'+Nom_fichier);
     end;
     avancement.StepIt;
end;

Bitmap.Free;
ShowMessage('Traitement Termin');
avancement.max:=0;

end;

procedure Ttraitement_Images.Button4Click(Sender: TObject);
begin
If liste .ItemIndex >= 0 Then liste.items.delete ( liste .ItemIndex);

end;


procedure Ttraitement_Images.Button6Click(Sender: TObject);
begin
liste.clear;
end;

procedure Ttraitement_Images.Button3Click(Sender: TObject);
var
path : String;
rechercher : TSearchRec;
erreur : Integer;
begin
If init_liste_scan.checked Then liste.clear;
path := trim(Directory.GetItemPath(Directory.ItemIndex))+'\*.bmp';

Erreur := findfirst ( path, faAnyFile, rechercher);
       while Erreur = 0 Do
       Begin
             liste.items.add ( trim(Directory.GetItemPath(Directory.ItemIndex))+'\'+rechercher.name);
             Erreur := FindNext (rechercher);
       End;
       FindClose(rechercher)
end;

procedure Ttraitement_Images.FormCreate(Sender: TObject);
var path : string;
begin
GetDir(0,path);


end;





procedure Ttraitement_Images.cDriveChange(Sender: TObject);
begin
 Directory.drive :=  cDrive.drive;
end;

procedure Ttraitement_Images.SpeedButton2Click(Sender: TObject);
begin
Dialog_file.execute();
end;

procedure Ttraitement_Images.Dialog_fileCanClose(Sender: TObject;
  var CanClose: Boolean);
begin
    liste.Items.add(Dialog_file.FileName);
end;

procedure Ttraitement_Images.renommerClick(Sender: TObject);

var
Bitmap : TBitMap;
X,Z : Integer;
I : Integer;
Path_sav : String;
Nom_fichier : String;
debug : boolean;
begin
debug := false ;
info.caption := 'Avancement';
Bitmap := TBitmap.Create;
Bitmap.PixelFormat := pf32bit;
Path_sav := trim(Directorysav.GetItemPath(Directorysav.ItemIndex))+'\';

If ck_image1.Checked and Not DirectoryExists( Path_sav +'image1' ) Then
   CreateDir (Path_sav+'image1');

If ck_image2.Checked and Not DirectoryExists( Path_sav +'image2' ) Then
   CreateDir (Path_sav+'image2');

If ck_image3.Checked and Not DirectoryExists( Path_sav +'image3' ) Then
   CreateDir (Path_sav+'image3');

If ck_image4.Checked and Not DirectoryExists( Path_sav +'image4' ) Then
   CreateDir (Path_sav+'image4');

avancement.max := liste.items.Count;
For I:=0 to ( liste.items.Count -1 ) do
begin
     BitMap.LoadFromFile(liste.items[I]);
     calcul_coordonnees ( liste.items[I],X ,Z,debug);
     Nom_fichier := liste.items[I];
     while Pos ('\',Nom_fichier ) > 0  do
     begin
           delete ( Nom_fichier, 1,pos ('\',Nom_fichier ));
     End;
     If debug Then showmessage (Nom_fichier);

     // dtermination de l'image
     case recherche_image ( X,Z, debug) of
          1 : If  ck_image1.Checked Then BitMap.saveToFile(Path_sav +'image1\'+inttostr(X)+'_'+inttostr(Z)+'_'+Nom_fichier);
          2 : If  ck_image2.Checked Then BitMap.saveToFile(Path_sav +'image2\'+inttostr(X)+'_'+inttostr(Z)+'_'+Nom_fichier);
          3 : If  ck_image3.Checked Then BitMap.saveToFile(Path_sav +'image3\'+inttostr(X)+'_'+inttostr(Z)+'_'+Nom_fichier);
          4 : If  ck_image4.Checked Then BitMap.saveToFile(Path_sav +'image4\'+inttostr(X)+'_'+inttostr(Z)+'_'+Nom_fichier);
     end;
     avancement.stepit;
end;

Bitmap.Free;
ShowMessage('Traitement Termin');
avancement.max:=0;

end;

procedure Ttraitement_Images.DrivesavChange(Sender: TObject);
begin
 Directorysav.drive :=  Drivesav.drive;
end;

end.

